/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.themes;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.MessageService;
import com.limegroup.gnutella.settings.FileSetting;
import com.limegroup.gnutella.settings.LimeProps;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.Expand;
import com.limegroup.gnutella.util.FileUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public final class ThemeSettings
extends LimeProps {
    public static final String EXTENSION = "lwtp";
    public static final File THEME_DIR_FILE;
    public static final String LIMEWIRE_THEME_NAME = "limewire_theme.lwtp";
    public static final String PINSTRIPES_OSX_THEME_NAME = "pinstripes_theme_osx.lwtp";
    public static final String BRUSHED_METAL_OSX_THEME_NAME = "brushed_metal_theme_osx.lwtp";
    public static final String WINDOWS_LAF_THEME_NAME = "windows_theme.lwtp";
    public static final String GTK_LAF_THEME_NAME = "GTK_theme.lwtp";
    public static final String PRO_THEME_NAME = "limewirePro_theme.lwtp";
    public static final String OTHER_THEME_NAME = "other_theme.lwtp";
    public static final File LIMEWIRE_THEME_FILE;
    static final File PINSTRIPES_OSX_THEME_FILE;
    static final File BRUSHED_METAL_OSX_THEME_FILE;
    static final File WINDOWS_LAF_THEME_FILE;
    static final File GTK_LAF_THEME_FILE;
    static final File PRO_THEME_FILE;
    static final File OTHER_THEME_FILE;
    public static final File THEME_DEFAULT;
    public static final File THEME_DEFAULT_DIR;
    public static final FileSetting THEME_FILE;
    public static final FileSetting THEME_DIR;

    private ThemeSettings() {
    }

    private static void copyZipWithNewTimestamp(String name, File themeFile) {
        CommonUtils.copyResourceFile(name, themeFile, true);
        File themeDir = ThemeSettings.extractThemeDir(themeFile);
        ThemeSettings.expandTheme(themeFile, themeDir, true);
    }

    static boolean expandTheme(File themeFile, File themeDir, boolean overwrite) {
        themeDir.mkdirs();
        try {
            FileUtils.setWriteable(themeDir);
            Expand.expandFile(themeFile, themeDir, overwrite);
        }
        catch (ZipException ze) {
            MessageService.showError("ERROR_APPLYING_INVALID_THEME_FILE");
            return false;
        }
        catch (IOException e) {
            ErrorService.error(e);
            return false;
        }
        return true;
    }

    static File extractThemeDir(File themeFile) {
        String dirName = themeFile.getName();
        dirName = dirName.substring(0, dirName.length() - 5);
        return new File(new File(CommonUtils.getUserSettingsDir(), "themes"), dirName);
    }

    static boolean isThemeFile(File f) {
        return f.getName().toLowerCase().endsWith(".lwtp");
    }

    public static boolean isDefaultTheme() {
        return THEME_FILE.getValue().equals(THEME_DEFAULT);
    }

    public static boolean isGTKTheme() {
        return THEME_FILE.getValue().equals(GTK_LAF_THEME_FILE);
    }

    public static boolean isWindowsTheme() {
        return THEME_FILE.getValue().equals(WINDOWS_LAF_THEME_FILE);
    }

    public static boolean isBrushedMetalTheme() {
        return THEME_FILE.getValue().equals(BRUSHED_METAL_OSX_THEME_FILE);
    }

    public static boolean isPinstripesTheme() {
        return THEME_FILE.getValue().equals(PINSTRIPES_OSX_THEME_FILE);
    }

    public static boolean isNativeOSXTheme() {
        return CommonUtils.isMacOSX() && (ThemeSettings.isPinstripesTheme() || ThemeSettings.isBrushedMetalTheme());
    }

    public static boolean isNativeTheme() {
        return ThemeSettings.isNativeOSXTheme() || ThemeSettings.isWindowsTheme() || ThemeSettings.isGTKTheme();
    }

    public static boolean isOtherTheme() {
        return THEME_FILE.getValue().equals(OTHER_THEME_FILE);
    }

    public static boolean isValid() {
        if (ThemeSettings.isOtherTheme()) {
            String name = ThemeSettings.getOtherLF();
            if (name != null) {
                try {
                    Class.forName(name);
                    return true;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getOtherLF() {
        block11: {
            in = null;
            try {
                try {
                    in = new BufferedReader(new InputStreamReader(new FileInputStream(new File(ThemeSettings.THEME_DIR_FILE, "other_theme/name.txt"))));
                    classname = in.readLine();
                    if (classname == null) break block11;
                    var2_3 = classname.trim();
                    var4_4 = null;
                    if (in == null) return var2_3;
                }
                catch (IOException var1_2) {
                    var4_6 = null;
                    if (in == null) return null;
                    try {
                        in.close();
                        return null;
                    }
                    catch (IOException ignored) {
                        return null;
                    }
                }
            }
            catch (Throwable var3_12) {
                var4_7 = null;
                if (in == null) throw var3_12;
                ** try [egrp 2[TRYBLOCK] [5 : 80->87)] { 
lbl26:
                // 1 sources

                in.close();
                throw var3_12;
lbl28:
                // 1 sources

                catch (IOException ignored) {
                    // empty catch block
                }
                throw var3_12;
            }
            try {}
            catch (IOException ignored) {
                // empty catch block
                return var2_3;
            }
            in.close();
            return var2_3;
        }
        var4_5 = null;
        if (in == null) return null;
        try {}
        catch (IOException ignored) {}
        in.close();
        return null;
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setOtherLF(String classname) {
        BufferedWriter out = null;
        out = new BufferedWriter(new FileWriter(new File(THEME_DIR_FILE, "other_theme/name.txt"), false));
        out.write(classname);
        out.flush();
        Object var4_2 = null;
        if (out == null) return;
        try {
            out.close();
            return;
        }
        catch (IOException ignored) {}
        return;
        {
            catch (IOException iOException) {
                Object var4_3 = null;
                if (out == null) return;
                try {
                    out.close();
                    return;
                }
                catch (IOException ignored) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (out == null) throw throwable;
            try {
                out.close();
                throw throwable;
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public static String formatName(String name) {
        name = name.substring(0, name.length() - 5);
        StringBuffer formatted = new StringBuffer(name.length());
        StringTokenizer st = new StringTokenizer(name, "_");
        while (st.hasMoreTokens()) {
            String next = st.nextToken();
            String lower = next.toLowerCase();
            if (lower.equals("osx")) {
                next = "(OSX)";
            } else if (lower.equals("limewire")) {
                next = "LimeWire";
            } else if (lower.equals("limewirepro")) {
                next = "LimeWire PRO";
            }
            formatted.append(" " + next.substring(0, 1).toUpperCase(Locale.US));
            if (next.length() <= 1) continue;
            formatted.append(next.substring(1));
        }
        return formatted.toString().trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        block21: {
            ThemeSettings.THEME_DIR_FILE = new File(CommonUtils.getUserSettingsDir(), "themes");
            ThemeSettings.LIMEWIRE_THEME_FILE = new File(ThemeSettings.THEME_DIR_FILE, "limewire_theme.lwtp");
            ThemeSettings.PINSTRIPES_OSX_THEME_FILE = new File(ThemeSettings.THEME_DIR_FILE, "pinstripes_theme_osx.lwtp");
            ThemeSettings.BRUSHED_METAL_OSX_THEME_FILE = new File(ThemeSettings.THEME_DIR_FILE, "brushed_metal_theme_osx.lwtp");
            ThemeSettings.WINDOWS_LAF_THEME_FILE = new File(ThemeSettings.THEME_DIR_FILE, "windows_theme.lwtp");
            ThemeSettings.GTK_LAF_THEME_FILE = new File(ThemeSettings.THEME_DIR_FILE, "GTK_theme.lwtp");
            ThemeSettings.PRO_THEME_FILE = new File(ThemeSettings.THEME_DIR_FILE, "limewirePro_theme.lwtp");
            ThemeSettings.OTHER_THEME_FILE = new File(ThemeSettings.THEME_DIR_FILE, "other_theme.lwtp");
            themesJar = new File("themes.jar");
            if (!themesJar.isFile() && (url = ThemeSettings.class.getClassLoader().getResource("limewire_theme.lwtp").toString()) != null && url.startsWith("jar:file:")) {
                url = url.substring("jar:file:".length(), url.length());
                url = url.substring(0, url.length() - "limewire_theme.lwtp".length() - "!/".length());
                themesJar = new File(url);
            }
            if (themesJar.isFile()) {
                zf = null;
                try {
                    try {
                        jarMod = themesJar.lastModified();
                        zf = new ZipFile(themesJar);
                        entries = zf.entries();
                        while (entries.hasMoreElements()) {
                            ze = entries.nextElement();
                            name = ze.getName();
                            if (!name.endsWith(".lwtp")) continue;
                            existingFile = new File(ThemeSettings.THEME_DIR_FILE, name);
                            if (existingFile.isFile()) {
                                if (jarMod <= existingFile.lastModified()) continue;
                                ThemeSettings.copyZipWithNewTimestamp(name, existingFile);
                                continue;
                            }
                            if (existingFile.exists()) continue;
                            ThemeSettings.copyZipWithNewTimestamp(name, existingFile);
                        }
                        var9_8 = null;
                        if (zf == null) break block21;
                    }
                    catch (IOException ioe) {
                        ErrorService.error(ioe);
                        var9_9 = null;
                        if (zf != null) {
                            try {
                                zf.close();
                            }
                            catch (IOException ignored) {}
                        }
                        break block21;
                    }
                }
                catch (Throwable var8_14) {
                    var9_10 = null;
                    if (zf == null) throw var8_14;
                    ** try [egrp 2[TRYBLOCK] [4 : 390->397)] { 
lbl51:
                    // 1 sources

                    zf.close();
                    throw var8_14;
lbl53:
                    // 1 sources

                    catch (IOException ignored) {
                        // empty catch block
                    }
                    throw var8_14;
                }
                try {}
                catch (IOException ignored) {}
                zf.close();
            }
        }
        if (CommonUtils.isMacOSX()) {
            theme = ThemeSettings.PINSTRIPES_OSX_THEME_FILE;
            dir = new File(ThemeSettings.THEME_DIR_FILE, "pinstripes_theme_osx");
        } else if (CommonUtils.isPro()) {
            theme = ThemeSettings.PRO_THEME_FILE;
            dir = new File(ThemeSettings.THEME_DIR_FILE, "limewirePro_theme");
        } else if (CommonUtils.isWindowsXP()) {
            theme = ThemeSettings.WINDOWS_LAF_THEME_FILE;
            dir = new File(ThemeSettings.THEME_DIR_FILE, "windows_theme");
        } else if (CommonUtils.isLinux() && CommonUtils.isJava15OrLater()) {
            theme = ThemeSettings.GTK_LAF_THEME_FILE;
            dir = new File(ThemeSettings.THEME_DIR_FILE, "GTK_theme");
        } else {
            theme = ThemeSettings.LIMEWIRE_THEME_FILE;
            dir = new File(ThemeSettings.THEME_DIR_FILE, "limewire_theme");
        }
        ThemeSettings.THEME_DEFAULT = theme;
        ThemeSettings.THEME_DEFAULT_DIR = dir;
        ThemeSettings.THEME_FILE = ThemeSettings.FACTORY.createFileSetting("THEME_FILE", ThemeSettings.THEME_DEFAULT);
        ThemeSettings.THEME_DIR = ThemeSettings.FACTORY.createFileSetting("THEME_DIR", ThemeSettings.THEME_DEFAULT_DIR);
    }
}

