/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.xml.editor;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileEventListener;
import com.limegroup.gnutella.archive.Archives;
import com.limegroup.gnutella.archive.Contribution;
import com.limegroup.gnutella.archive.DescriptionTooShortException;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.SizedPasswordField;
import com.limegroup.gnutella.gui.SizedTextField;
import com.limegroup.gnutella.gui.URLLabel;
import com.limegroup.gnutella.gui.xml.editor.AbstractMetaEditorPanel;
import com.limegroup.gnutella.gui.xml.editor.CCRDFOuptut;
import com.limegroup.gnutella.gui.xml.editor.InternetArchiveIdentifierRetriever;
import com.limegroup.gnutella.gui.xml.editor.InternetArchiveUploader;
import com.limegroup.gnutella.licenses.License;
import com.limegroup.gnutella.licenses.PublishedCCLicense;
import com.limegroup.gnutella.settings.InternetArchiveSetting;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.util.NameValue;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public class CCPublisherTab
extends AbstractMetaEditorPanel {
    private static final long serialVersionUID = 4529973794308191398L;
    private final int DIALOG_WIDTH = 600;
    private final JTextField COPYRIGHT_HOLDER = new SizedTextField(24);
    private final JLabel COPYRIGHT_HOLDER_LABEL = new JLabel(GUIMediator.getStringResource("CC_PUBLISHER_COPYRIGHT_HOLDER_LABEL"));
    private final JTextField WORK_TITLE = new SizedTextField(24);
    private final JLabel WORK_TITLE_LABEL = new JLabel(GUIMediator.getStringResource("CC_PUBLISHER_WORK_TITLE_LABEL"));
    private final JTextField COPYRIGHT_YEAR = new SizedTextField(6);
    private final JLabel COPYRIGHT_YEAR_LABEL = new JLabel(GUIMediator.getStringResource("CC_PUBLISHER_COPYRIGHT_YEAR_LABEL"));
    private final JTextField DESCRIPTION = new SizedTextField(24);
    private final JLabel DESCRIPTION_LABEL = new JLabel(GUIMediator.getStringResource("CC_PUBLISHER_DESCRIPTION_LABEL"));
    private final JLabel REMOVE_LICENSE_LABEL = new JLabel(GUIMediator.getStringResource("CC_PUBLISHER_REMOVE_LICENSE_LABEL"));
    private final JTextField VERIFICATION_URL_FIELD = new SizedTextField(20);
    private final JLabel VERIFICATION_URL_LABEL = new JLabel(GUIMediator.getStringResource("CC_PUBLISHER_LICENSE_VERIFICATION_URL"));
    private final String VERIFICATION_ARCHIVE = GUIMediator.getStringResource("CC_PUBLISHER_LICENSE_VERIFICATION_ARCHIVE");
    private final String VERIFICATION_SELF = GUIMediator.getStringResource("CC_PUBLISHER_LICENSE_VERIFICATION_SELF");
    private final String WARNING_MESSAGE_CREATE = GUIMediator.getStringResource("CC_PUBLISHER_WARNING_CREATE");
    private final String WARNING_MESSAGE_MODIFY = GUIMediator.getStringResource("CC_PUBLISHER_WARNING_MODIFY");
    private final JCheckBox WARNING_CHECKBOX = new JCheckBox("<html>" + this.WARNING_MESSAGE_CREATE + "</html>");
    private final JLabel INTRO_LABEL = new JLabel(GUIMediator.getStringResource("CC_PUBLISHER_INTRO"));
    private final JCheckBox LICENSE_ALLOWCOM = new JCheckBox(GUIMediator.getStringResource("CC_PUBLISHER_LICENSE_ALLOWCOM_LABEL"));
    private final JLabel LICENSE_ALLOWMOD_LABEL = new JLabel(GUIMediator.getStringResource("CC_PUBLISHER_LICENSE_ALLOWMOD_LABEL"));
    private final String ALLOWMOD_SHAREALIKE = GUIMediator.getStringResource("CC_PUBLISHER_LICENSE_ALLOWMOD_SHAREALIKE");
    private final String ALLOWMOD_YES = GUIMediator.getStringResource("YES");
    private final String ALLOWMOD_NO = GUIMediator.getStringResource("NO");
    private final JComboBox LICENSE_ALLOWMOD_BOX = new JComboBox<String>(new String[]{this.ALLOWMOD_YES, this.ALLOWMOD_SHAREALIKE, this.ALLOWMOD_NO});
    private final JLabel CC_INTRO_URL_LABEL = new URLLabel(SharingSettings.CREATIVE_COMMONS_INTRO_URL.getValue(), GUIMediator.getStringResource("CC_PUBLISHER_CC_INTRO_URL_LABEL"));
    private final JLabel CC_VERIFICATION_WHATIS_LABEL = new URLLabel(SharingSettings.CREATIVE_COMMONS_VERIFICATION_URL.getValue(), GUIMediator.getStringResource("CC_PUBLISHER_CC_VERIFICATION_URL_LABEL"));
    private final JRadioButton ARCHIVE_VERIFICATION = new JRadioButton(this.VERIFICATION_ARCHIVE);
    private final JRadioButton SELF_VERIFICATION = new JRadioButton(this.VERIFICATION_SELF);
    private final JLabel ARCHIVE_USERNAME_LABEL = new JLabel(GUIMediator.getStringResource("CC_PUBLISHER_ARCHIVE_USERNAME_LABEL"));
    private final JLabel ARCHIVE_PASSWORD_LABEL = new JLabel(GUIMediator.getStringResource("CC_PUBLISHER_ARCHIVE_PASSWORD_LABEL"));
    private final JTextField ARCHIVE_USERNAME_FIELD = new SizedTextField(6);
    private final JTextField ARCHIVE_PASSWORD_FIELD = new SizedPasswordField(6);
    private final MouseListener _removeLicenseListener = new RemoveLabelMouseListener();
    private LimeXMLDocument _xmlDoc;
    private FileDesc _fd;
    private boolean _licenseRemoved = false;
    private JPanel _warningPanel = new JPanel(new GridBagLayout());
    private ButtonGroup _verificationURLgroup;
    private Contribution _contribution;

    public CCPublisherTab(FileDesc[] fds, LimeXMLDocument doc) {
        this._xmlDoc = doc;
        this._fd = fds[0];
        this.init();
        this.initInfo();
        this.updateDisplay();
    }

    private void init() {
        this.setName(GUIMediator.getStringResource("CC_PUBLISHER_TITLE"));
        this.setLayout(new GridBagLayout());
        GridBagConstraints mainConstraints = new GridBagConstraints();
        this._warningPanel.setOpaque(false);
        GridBagConstraints warnConstraints = new GridBagConstraints();
        warnConstraints.anchor = 17;
        this._warningPanel.add((Component)this.INTRO_LABEL, warnConstraints);
        warnConstraints.gridx = 1;
        this._warningPanel.add((Component)this.CC_INTRO_URL_LABEL, warnConstraints);
        warnConstraints.gridx = 0;
        warnConstraints.gridy = 1;
        warnConstraints.gridwidth = 2;
        this.WARNING_CHECKBOX.addItemListener(new WarningCheckBoxListener());
        this.WARNING_CHECKBOX.setOpaque(false);
        this.WARNING_CHECKBOX.setPreferredSize(new Dimension(600, 50));
        this._warningPanel.add((Component)this.WARNING_CHECKBOX, warnConstraints);
        warnConstraints.anchor = 10;
        warnConstraints.gridy = 2;
        this.REMOVE_LICENSE_LABEL.setForeground(Color.BLUE);
        this.REMOVE_LICENSE_LABEL.addMouseListener(this._removeLicenseListener);
        this.REMOVE_LICENSE_LABEL.setVisible(false);
        this._warningPanel.add((Component)this.REMOVE_LICENSE_LABEL, warnConstraints);
        mainConstraints.anchor = 17;
        this.add((Component)this._warningPanel, mainConstraints);
        mainConstraints.gridy = 1;
        JSeparator separator = new JSeparator();
        separator.setPreferredSize(new Dimension(600, 2));
        this.add((Component)separator, mainConstraints);
        JPanel licenseDetailsPanel = new JPanel(new GridBagLayout());
        GridBagConstraints licenseConstraints = new GridBagConstraints();
        licenseDetailsPanel.setOpaque(false);
        licenseConstraints.anchor = 17;
        licenseConstraints.insets = new Insets(2, 2, 2, 2);
        licenseDetailsPanel.add((Component)this.COPYRIGHT_HOLDER_LABEL, licenseConstraints);
        licenseConstraints.gridy = 1;
        licenseDetailsPanel.add((Component)this.COPYRIGHT_HOLDER, licenseConstraints);
        licenseConstraints.gridy = 2;
        licenseDetailsPanel.add((Component)this.WORK_TITLE_LABEL, licenseConstraints);
        licenseConstraints.gridy = 3;
        licenseDetailsPanel.add((Component)this.WORK_TITLE, licenseConstraints);
        licenseConstraints.gridx = 1;
        licenseConstraints.gridy = 0;
        licenseConstraints.insets = new Insets(2, 40, 2, 2);
        licenseDetailsPanel.add((Component)this.COPYRIGHT_YEAR_LABEL, licenseConstraints);
        licenseConstraints.gridy = 1;
        licenseDetailsPanel.add((Component)this.COPYRIGHT_YEAR, licenseConstraints);
        licenseConstraints.gridy = 2;
        licenseDetailsPanel.add((Component)this.DESCRIPTION_LABEL, licenseConstraints);
        licenseConstraints.gridy = 3;
        licenseDetailsPanel.add((Component)this.DESCRIPTION, licenseConstraints);
        licenseConstraints.insets = new Insets(10, 2, 10, 2);
        licenseConstraints.gridx = 0;
        licenseConstraints.gridy = 4;
        this.LICENSE_ALLOWCOM.setOpaque(false);
        this.LICENSE_ALLOWCOM.setHorizontalTextPosition(2);
        licenseDetailsPanel.add((Component)this.LICENSE_ALLOWCOM, licenseConstraints);
        JPanel licenseAllowModPanel = new JPanel(new GridBagLayout());
        GridBagConstraints constr = new GridBagConstraints();
        licenseAllowModPanel.setOpaque(false);
        constr.anchor = 13;
        licenseAllowModPanel.add((Component)this.LICENSE_ALLOWMOD_LABEL, constr);
        constr.gridx = 1;
        constr.insets = new Insets(0, 5, 0, 0);
        this.LICENSE_ALLOWMOD_BOX.setOpaque(false);
        licenseAllowModPanel.add((Component)this.LICENSE_ALLOWMOD_BOX, constr);
        licenseConstraints.gridx = 1;
        licenseConstraints.insets = new Insets(10, 40, 10, 2);
        licenseDetailsPanel.add((Component)licenseAllowModPanel, licenseConstraints);
        mainConstraints.gridy = 2;
        this.add((Component)licenseDetailsPanel, mainConstraints);
        separator = new JSeparator();
        separator.setPreferredSize(new Dimension(600, 2));
        mainConstraints.gridy = 3;
        this.add((Component)separator, mainConstraints);
        JPanel verificationPanel = new JPanel(new GridBagLayout());
        licenseConstraints = new GridBagConstraints();
        licenseConstraints.anchor = 17;
        licenseConstraints.insets = new Insets(5, 0, 2, 2);
        licenseConstraints.gridwidth = 2;
        JPanel panel = new JPanel(new GridBagLayout());
        constr = new GridBagConstraints();
        panel.add((Component)this.VERIFICATION_URL_LABEL, constr);
        constr.gridx = 1;
        constr.insets = new Insets(0, 5, 0, 0);
        panel.add((Component)this.CC_VERIFICATION_WHATIS_LABEL, constr);
        verificationPanel.add((Component)panel, licenseConstraints);
        licenseConstraints.gridwidth = 1;
        licenseConstraints.insets = new Insets(2, 2, 2, 2);
        licenseConstraints.gridy = 1;
        this.ARCHIVE_VERIFICATION.setOpaque(false);
        this.ARCHIVE_VERIFICATION.addActionListener(new VerificationURLButtonListener());
        this.SELF_VERIFICATION.setOpaque(false);
        this.SELF_VERIFICATION.addActionListener(new VerificationURLButtonListener());
        this._verificationURLgroup = new ButtonGroup();
        this._verificationURLgroup.add(this.ARCHIVE_VERIFICATION);
        this._verificationURLgroup.add(this.SELF_VERIFICATION);
        this._verificationURLgroup.setSelected(this.ARCHIVE_VERIFICATION.getModel(), true);
        licenseConstraints.insets = new Insets(10, 2, 2, 2);
        verificationPanel.add((Component)this.ARCHIVE_VERIFICATION, licenseConstraints);
        licenseConstraints.insets = new Insets(2, 2, 2, 2);
        licenseConstraints.gridy = 2;
        verificationPanel.add((Component)this.SELF_VERIFICATION, licenseConstraints);
        licenseConstraints.gridy = 1;
        licenseConstraints.gridx = 1;
        licenseConstraints.insets = new Insets(10, 2, 2, 2);
        licenseConstraints.gridwidth = 0;
        panel = new JPanel(new GridBagLayout());
        constr = new GridBagConstraints();
        panel.add((Component)this.ARCHIVE_USERNAME_LABEL, constr);
        constr.gridx = 1;
        constr.insets = new Insets(0, 2, 0, 0);
        panel.add((Component)this.ARCHIVE_USERNAME_FIELD, constr);
        constr.gridx = 2;
        constr.insets = new Insets(0, 10, 0, 0);
        panel.add((Component)this.ARCHIVE_PASSWORD_LABEL, constr);
        constr.insets = new Insets(0, 2, 0, 0);
        constr.gridx = 3;
        panel.add((Component)this.ARCHIVE_PASSWORD_FIELD, constr);
        verificationPanel.add((Component)panel, licenseConstraints);
        licenseConstraints.gridwidth = 0;
        licenseConstraints.gridy = 2;
        licenseConstraints.insets = new Insets(2, 2, 2, 2);
        panel = new JPanel(new GridBagLayout());
        constr = new GridBagConstraints();
        this.VERIFICATION_URL_FIELD.setText("http://");
        constr.gridx = 1;
        panel.add((Component)this.VERIFICATION_URL_FIELD, constr);
        verificationPanel.add((Component)panel, licenseConstraints);
        this.setOpaque(false);
        mainConstraints.gridy = 4;
        this.add((Component)verificationPanel, mainConstraints);
    }

    private void initInfo() {
        License license = this._fd.getLicense();
        this.ARCHIVE_USERNAME_FIELD.setText(InternetArchiveSetting.INTERNETARCHIVE_USERNAME.getValue());
        this.ARCHIVE_PASSWORD_FIELD.setText(InternetArchiveSetting.INTERNETARCHIVE_PASS.getValue());
        if (license != null) {
            String licenseDeed;
            this.WARNING_CHECKBOX.setText("<html>" + this.WARNING_MESSAGE_MODIFY + "</html>");
            this.REMOVE_LICENSE_LABEL.setVisible(true);
            this._warningPanel.setPreferredSize(new Dimension(600, 80));
            if (license.getLicenseURI() != null) {
                this.VERIFICATION_URL_FIELD.setText(license.getLicenseURI().toString());
                this._verificationURLgroup.setSelected(this.SELF_VERIFICATION.getModel(), true);
                this.updateVerification();
            }
            if ((licenseDeed = license.getLicenseDeed(this._fd.getSHA1Urn()).toString()) != null) {
                if (licenseDeed.equals("http://creativecommons.org/licenses/by-nc-nd/2.5/")) {
                    this.LICENSE_ALLOWCOM.setSelected(false);
                    this.LICENSE_ALLOWMOD_BOX.setSelectedItem(this.ALLOWMOD_NO);
                } else if (licenseDeed.equals("http://creativecommons.org/licenses/by-nd/2.5/")) {
                    this.LICENSE_ALLOWCOM.setSelected(true);
                    this.LICENSE_ALLOWMOD_BOX.setSelectedItem(this.ALLOWMOD_NO);
                } else if (licenseDeed.equals("http://creativecommons.org/licenses/by-nc/2.5/")) {
                    this.LICENSE_ALLOWCOM.setSelected(false);
                    this.LICENSE_ALLOWMOD_BOX.setSelectedItem(this.ALLOWMOD_YES);
                } else if (licenseDeed.equals("http://creativecommons.org/licenses/by-nc-sa/2.5/")) {
                    this.LICENSE_ALLOWCOM.setSelected(false);
                    this.LICENSE_ALLOWMOD_BOX.setSelectedItem(this.ALLOWMOD_SHAREALIKE);
                } else if (licenseDeed.equals("http://creativecommons.org/licenses/by-sa/2.5/")) {
                    this.LICENSE_ALLOWCOM.setSelected(true);
                    this.LICENSE_ALLOWMOD_BOX.setSelectedItem(this.ALLOWMOD_SHAREALIKE);
                } else {
                    this.LICENSE_ALLOWCOM.setSelected(true);
                    this.LICENSE_ALLOWMOD_BOX.setSelectedItem(this.ALLOWMOD_YES);
                }
            }
        } else if (this._xmlDoc != null) {
            this.COPYRIGHT_HOLDER.setText(this._xmlDoc.getValue("audios__audio__artist__"));
            this.COPYRIGHT_YEAR.setText(this._xmlDoc.getValue("audios__audio__year__"));
            this.WORK_TITLE.setText(this._xmlDoc.getValue("audios__audio__title__"));
        }
    }

    private void updateDisplay() {
        this.WORK_TITLE.setEnabled(this.WARNING_CHECKBOX.isSelected());
        this.WORK_TITLE_LABEL.setEnabled(this.WARNING_CHECKBOX.isSelected());
        this.COPYRIGHT_HOLDER.setEnabled(this.WARNING_CHECKBOX.isSelected());
        this.COPYRIGHT_HOLDER_LABEL.setEnabled(this.WARNING_CHECKBOX.isSelected());
        this.COPYRIGHT_YEAR.setEnabled(this.WARNING_CHECKBOX.isSelected());
        this.COPYRIGHT_YEAR_LABEL.setEnabled(this.WARNING_CHECKBOX.isSelected());
        this.DESCRIPTION.setEnabled(this.WARNING_CHECKBOX.isSelected());
        this.DESCRIPTION_LABEL.setEnabled(this.WARNING_CHECKBOX.isSelected());
        this.LICENSE_ALLOWMOD_LABEL.setEnabled(this.WARNING_CHECKBOX.isSelected());
        this.VERIFICATION_URL_FIELD.setEnabled(this.WARNING_CHECKBOX.isSelected());
        this.VERIFICATION_URL_LABEL.setEnabled(this.WARNING_CHECKBOX.isSelected());
        this.CC_VERIFICATION_WHATIS_LABEL.setEnabled(this.WARNING_CHECKBOX.isSelected());
        this.LICENSE_ALLOWCOM.setEnabled(this.WARNING_CHECKBOX.isSelected());
        this.LICENSE_ALLOWMOD_BOX.setEnabled(this.WARNING_CHECKBOX.isSelected());
        this.SELF_VERIFICATION.setEnabled(this.WARNING_CHECKBOX.isSelected());
        this.ARCHIVE_VERIFICATION.setEnabled(this.WARNING_CHECKBOX.isSelected());
        this.updateVerification();
    }

    private void updateVerification() {
        boolean archiveSelected = this.ARCHIVE_VERIFICATION.getModel().isSelected();
        this.ARCHIVE_PASSWORD_FIELD.setEnabled(archiveSelected && this.WARNING_CHECKBOX.isSelected());
        this.ARCHIVE_PASSWORD_LABEL.setEnabled(archiveSelected && this.WARNING_CHECKBOX.isSelected());
        this.ARCHIVE_USERNAME_FIELD.setEnabled(archiveSelected && this.WARNING_CHECKBOX.isSelected());
        this.ARCHIVE_USERNAME_LABEL.setEnabled(archiveSelected && this.WARNING_CHECKBOX.isSelected());
        this.VERIFICATION_URL_FIELD.setEnabled(!archiveSelected && this.WARNING_CHECKBOX.isSelected());
    }

    public boolean reserveIdentifier() {
        if (this.ARCHIVE_VERIFICATION.getModel().isSelected() && !this._licenseRemoved) {
            String username = this.ARCHIVE_USERNAME_FIELD.getText();
            String password = this.ARCHIVE_PASSWORD_FIELD.getText();
            String title = this.WORK_TITLE.getText();
            String description = this.DESCRIPTION.getText();
            try {
                this._contribution = Archives.createContribution(username, password, title, description, 3, 2, 2);
            }
            catch (DescriptionTooShortException e) {
                GUIMediator.showFormattedError("ERROR_CCPUBLISHER_DESCRIPTION_START", new Object[]{String.valueOf(e.getMinWords())});
                return false;
            }
            String id = title;
            InternetArchiveIdentifierRetriever idRetriever = new InternetArchiveIdentifierRetriever(this._contribution, id);
            idRetriever.reserveIdentifier();
            return this._contribution.getVerificationUrl() != null;
        }
        return true;
    }

    private boolean inputValid() {
        String holder = this.COPYRIGHT_HOLDER.getText();
        String year = this.COPYRIGHT_YEAR.getText();
        String title = this.WORK_TITLE.getText();
        String url = null;
        if (holder.equals("")) {
            GUIMediator.showError("ERROR_CCPUBLISHER_MISSING_HOLDER");
            return false;
        }
        if (year.equals("")) {
            GUIMediator.showError("ERROR_CCPUBLISHER_MISSING_YEAR");
            return false;
        }
        if (title.equals("")) {
            GUIMediator.showError("ERROR_CCPUBLISHER_MISSING_TITLE");
            return false;
        }
        if (this.ARCHIVE_VERIFICATION.getModel().isSelected()) {
            String username = this.ARCHIVE_USERNAME_FIELD.getText();
            String password = this.ARCHIVE_PASSWORD_FIELD.getText();
            if (username == null || username.equals("") || password == null || password.equals("")) {
                GUIMediator.showError("ERROR_CCPUBLISHER_MISSING_ARCHIVE_LOGIN");
                return false;
            }
        } else {
            url = this.VERIFICATION_URL_FIELD.getText();
            if (url.equals("") || !url.startsWith("http://") || url.length() < 8) {
                GUIMediator.showError("ERROR_CCPUBLISHER_MISSING_URL");
                this.VERIFICATION_URL_FIELD.setText("http://");
                return false;
            }
            try {
                new URL(url);
            }
            catch (MalformedURLException invalidURL) {
                GUIMediator.showError("ERROR_CCPUBLISHER_URL");
                return false;
            }
            try {
                Integer.parseInt(year);
            }
            catch (NumberFormatException badDate) {
                GUIMediator.showError("ERROR_CCPUBLISHER_DATE");
                return false;
            }
        }
        return true;
    }

    public boolean checkInput() {
        return !this.WARNING_CHECKBOX.isSelected() || this._licenseRemoved || this.inputValid();
    }

    public void removeLicense() {
        int answer = GUIMediator.showYesNoMessage("CC_PUBLISHER_REMOVELICENSE_LABEL");
        if (answer == 101) {
            this.setVisible(false);
            this._licenseRemoved = true;
            if (this.WARNING_CHECKBOX.isSelected()) {
                this.WARNING_CHECKBOX.doClick();
            }
            this.INTRO_LABEL.setVisible(false);
            this.CC_INTRO_URL_LABEL.setVisible(false);
            this.WARNING_CHECKBOX.setVisible(false);
            this.REMOVE_LICENSE_LABEL.setText(GUIMediator.getStringResource("CC_PUBLISHER_LICENSEREMOVED_LABEL"));
            this.REMOVE_LICENSE_LABEL.setForeground(Color.BLACK);
            this.REMOVE_LICENSE_LABEL.removeMouseListener(this._removeLicenseListener);
            this.REMOVE_LICENSE_LABEL.addMouseListener(new MouseAdapter(){

                public void mouseEntered(MouseEvent e) {
                    e.getComponent().setCursor(Cursor.getDefaultCursor());
                }
            });
        }
    }

    public FileEventListener getFileEventListener() {
        if (this._licenseRemoved) {
            return null;
        }
        if (this.ARCHIVE_VERIFICATION.getModel().isSelected()) {
            return new InternetArchiveUploader(this._fd, this._contribution);
        }
        return new CCRDFOuptut(this._fd, this.COPYRIGHT_HOLDER.getText(), this.WORK_TITLE.getText(), this.COPYRIGHT_YEAR.getText(), this.DESCRIPTION.getText(), this.VERIFICATION_URL_FIELD.getText(), this.getLicenseType());
    }

    private int getLicenseType() {
        String mod;
        int type = 0;
        if (!this.LICENSE_ALLOWCOM.isSelected()) {
            type |= 2;
        }
        if ((mod = (String)this.LICENSE_ALLOWMOD_BOX.getSelectedItem()).equals(this.ALLOWMOD_SHAREALIKE)) {
            type |= 4;
        } else if (mod.equals(this.ALLOWMOD_NO)) {
            type |= 1;
        }
        return type;
    }

    public List getInput() {
        ArrayList<NameValue> valList = new ArrayList<NameValue>();
        if (this._licenseRemoved) {
            valList.addAll(this.getPreviousValList());
            NameValue nameVal = new NameValue("audios__audio__license__", "no license");
            valList.add(nameVal);
            nameVal = new NameValue("audios__audio__licensetype__", "");
            valList.add(nameVal);
        } else if (this.WARNING_CHECKBOX.isSelected() && this.inputValid()) {
            String holder = this.COPYRIGHT_HOLDER.getText();
            String year = this.COPYRIGHT_YEAR.getText();
            String title = this.WORK_TITLE.getText();
            String description = this.DESCRIPTION.getText();
            int type = this.getLicenseType();
            String url = null;
            if (this.ARCHIVE_VERIFICATION.getModel().isSelected()) {
                InternetArchiveSetting.INTERNETARCHIVE_USERNAME.setValue(this.ARCHIVE_USERNAME_FIELD.getText());
                InternetArchiveSetting.INTERNETARCHIVE_PASS.setValue(this.ARCHIVE_PASSWORD_FIELD.getText());
                url = this._contribution.getVerificationUrl();
            } else {
                url = this.VERIFICATION_URL_FIELD.getText();
            }
            valList.addAll(this.getPreviousValList());
            String embeddedLicense = PublishedCCLicense.getEmbeddableString(holder, title, year, url, description, type);
            if (embeddedLicense != null) {
                NameValue nameVal = new NameValue("audios__audio__license__", embeddedLicense);
                valList.add(nameVal);
                nameVal = new NameValue("audios__audio__licensetype__", "creativecommons.org/licenses/");
                valList.add(nameVal);
            }
        }
        return valList;
    }

    private List getPreviousValList() {
        ArrayList<NameValue> valList = new ArrayList<NameValue>();
        if (this._xmlDoc != null) {
            Iterator iter = this._xmlDoc.getNameValueSet().iterator();
            while (iter.hasNext()) {
                Map.Entry oldNameVal = (Map.Entry)iter.next();
                String key = (String)oldNameVal.getKey();
                if (key.equals("audios__audio__license__") || key.equals("audios__audio__licensetype__")) continue;
                valList.add(new NameValue((String)oldNameVal.getKey(), (String)oldNameVal.getValue()));
            }
        }
        return valList;
    }

    private class VerificationURLButtonListener
    implements ActionListener {
        private VerificationURLButtonListener() {
        }

        public void actionPerformed(ActionEvent arg0) {
            CCPublisherTab.this.updateVerification();
        }
    }

    private class RemoveLabelMouseListener
    extends MouseAdapter {
        private RemoveLabelMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            CCPublisherTab.this.removeLicense();
        }

        public void mouseEntered(MouseEvent e) {
            e.getComponent().setCursor(Cursor.getPredefinedCursor(12));
        }

        public void mouseExited(MouseEvent e) {
            e.getComponent().setCursor(Cursor.getDefaultCursor());
        }
    }

    private class WarningCheckBoxListener
    implements ItemListener {
        private WarningCheckBoxListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            CCPublisherTab.this.updateDisplay();
        }
    }
}

