/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.xml.editor;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileEventListener;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.library.LibraryMediator;
import com.limegroup.gnutella.gui.xml.editor.MetaEditorTabbedPane;
import com.limegroup.gnutella.gui.xml.editor.MetaEditorUtil;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLReplyCollection;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import com.limegroup.gnutella.xml.SchemaNotFoundException;
import com.limegroup.gnutella.xml.SchemaReplyCollectionMapper;
import java.io.IOException;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

public class MetaDataSaver {
    private static final Log LOG = LogFactory.getLog(MetaDataSaver.class);
    protected final MetaEditorTabbedPane _pane;
    private FileDesc[] fds;

    public MetaDataSaver(MetaEditorTabbedPane pane, FileDesc[] fds) {
        this._pane = pane;
        this.fds = fds;
    }

    public boolean saveMetaData() {
        if (!this._pane.checkInput()) {
            return false;
        }
        this.doSave();
        return true;
    }

    protected void doSave() {
        Iterator iter = this._pane.getFileEventListeners().iterator();
        while (iter.hasNext()) {
            FileEventListener listener = (FileEventListener)iter.next();
            RouterService.getFileManager().registerFileManagerEventListener(listener);
        }
        GUIMediator.instance().schedule(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    GUIMediator.safeInvokeAndWait(new Runnable(this){
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            LibraryMediator.instance().setAnnotateEnabled(false);
                        }
                    });
                    MetaDataSaver.this.saveMeta();
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    GUIMediator.safeInvokeAndWait(new Runnable(this){
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            LibraryMediator.instance().setAnnotateEnabled(true);
                        }
                    });
                    Iterator iter = MetaDataSaver.this._pane.getFileEventListeners().iterator();
                    while (iter.hasNext()) {
                        FileEventListener listener = (FileEventListener)iter.next();
                        RouterService.getFileManager().unregisterFileManagerEventListener(listener);
                    }
                    throw throwable;
                }
                GUIMediator.safeInvokeAndWait(new /* invalid duplicate definition of identical inner class */);
                Iterator iter = MetaDataSaver.this._pane.getFileEventListeners().iterator();
                while (iter.hasNext()) {
                    FileEventListener listener = (FileEventListener)iter.next();
                    RouterService.getFileManager().unregisterFileManagerEventListener(listener);
                }
            }
        });
    }

    private void saveMeta() {
        String XMLString = this._pane.getInput();
        FileDesc[] fds = this._pane.getFileDesc();
        if (XMLString == null) {
            return;
        }
        if (fds.length == 1 && XMLString.trim().length() == 0) {
            this.removeMeta(fds, this._pane.getSchema());
            return;
        }
        LimeXMLDocument newDoc = null;
        try {
            newDoc = new LimeXMLDocument(XMLString);
        }
        catch (SAXException e) {
            GUIMediator.showError("ERROR_SAVE_META_DOC");
            return;
        }
        catch (SchemaNotFoundException e) {
            GUIMediator.showError("ERROR_SAVE_META_DOC");
            return;
        }
        catch (IOException e) {
            GUIMediator.showError("ERROR_SAVE_META_DOC");
            return;
        }
        SchemaReplyCollectionMapper map = SchemaReplyCollectionMapper.instance();
        String schemaURI = newDoc.getSchemaURI();
        LimeXMLReplyCollection collection = map.getReplyCollection(schemaURI);
        Assert.that(collection != null, "Cant add doc to nonexistent collection");
        for (int i = 0; i < fds.length; ++i) {
            String fileName = null;
            try {
                fileName = fds[i].getFile().getCanonicalPath();
            }
            catch (IOException err) {
                if (fds.length != 1) continue;
                GUIMediator.showError("ERROR_SAVE_META_DOC");
                return;
            }
            LimeXMLDocument oldDoc = fds[i].getXMLDocument(schemaURI);
            LimeXMLDocument result = null;
            if (oldDoc != null) {
                result = MetaEditorUtil.merge(oldDoc, newDoc);
                oldDoc = collection.replaceDoc(fds[i], result);
            } else {
                result = newDoc;
                collection.addReply(fds[i], result);
            }
            if (LimeXMLUtils.isSupportedFormat(fileName)) {
                int committed = collection.mediaFileToDisk(fds[i], fileName, result, false);
                switch (committed) {
                    case 1: {
                        GUIMediator.showError("ERROR_SAVE_META_FILE");
                        break;
                    }
                    case 2: {
                        GUIMediator.showError("ERROR_SAVE_META_RW");
                        break;
                    }
                    case 3: {
                        GUIMediator.showError("ERROR_SAVE_META_ID3");
                        break;
                    }
                    case 4: {
                        GUIMediator.showError("ERROR_SAVE_META_ID3");
                        break;
                    }
                    case 5: {
                        this.cleanUpChanges(fds[i], "audios__audio__artist__", collection, oldDoc);
                        break;
                    }
                    case 6: {
                        this.cleanUpChanges(fds[i], "audios__audio__album__", collection, oldDoc);
                        break;
                    }
                    case 7: {
                        this.cleanUpChanges(fds[i], "audios__audio__year__", collection, oldDoc);
                        break;
                    }
                    case 8: {
                        this.cleanUpChanges(fds[i], "audios__audio__comments__", collection, oldDoc);
                        break;
                    }
                    case 9: {
                        this.cleanUpChanges(fds[i], "audios__audio__track__", collection, oldDoc);
                        break;
                    }
                    case 10: {
                        this.cleanUpChanges(fds[i], "audios__audio__genre__", collection, oldDoc);
                        break;
                    }
                    case 11: {
                        GUIMediator.showError("ERROR_SAVE_META_DISK");
                    }
                }
                continue;
            }
            if (collection.writeMapToDisk()) continue;
            GUIMediator.showError("ERROR_SAVE_META_DISK");
        }
    }

    private void cleanUpChanges(FileDesc fd, String canonicalFieldName, LimeXMLReplyCollection collection, LimeXMLDocument oldDoc) {
        GUIMediator.showError("ERROR_SAVE_META_BAD");
        if (oldDoc == null) {
            collection.removeDoc(fd);
        } else {
            collection.replaceDoc(fd, oldDoc);
        }
    }

    private void removeMeta(FileDesc[] fds, LimeXMLSchema schema) {
        String uri = schema.getSchemaURI();
        SchemaReplyCollectionMapper map = SchemaReplyCollectionMapper.instance();
        LimeXMLReplyCollection collection = map.getReplyCollection(uri);
        Assert.that(collection != null, "Trying to remove data from a non-existent collection");
        for (int i = 0; i < fds.length; ++i) {
            if (collection.removeDoc(fds[i])) continue;
            GUIMediator.showError("ERROR_DEL_META_SYSTEM");
        }
    }
}

