/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.xml.editor;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileEventListener;
import com.limegroup.gnutella.gui.xml.ComboBoxValue;
import com.limegroup.gnutella.gui.xml.editor.AbstractMetaEditorPanel;
import com.limegroup.gnutella.util.NameValue;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.SchemaFieldInfo;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;

public abstract class MetaEditorPanel
extends AbstractMetaEditorPanel {
    private Map nameToComponent;
    private Map componentToCheckbox;
    private Map nameToUneditedField;
    protected final FileDesc[] fds;
    protected final LimeXMLDocument document;
    protected final LimeXMLSchema schema;
    private boolean multiEdit = false;

    public MetaEditorPanel(FileDesc[] fds, LimeXMLSchema schema, LimeXMLDocument document) {
        this.fds = fds;
        this.schema = schema;
        this.document = document;
        this.nameToComponent = new HashMap();
        this.componentToCheckbox = new HashMap();
        this.nameToUneditedField = new HashMap();
        this.initWithDocumentFields();
    }

    public void setMultiEdit(boolean multiEdit) {
        this.multiEdit = multiEdit;
        this.setCheckBoxesVisible(multiEdit);
    }

    public boolean isMultiEdit() {
        return this.multiEdit;
    }

    public FileDesc[] getFileDesc() {
        return this.fds;
    }

    public LimeXMLDocument getDocument() {
        return this.document;
    }

    public LimeXMLSchema getSchema() {
        return this.schema;
    }

    public String getValue(String name) {
        return this.document != null ? this.document.getValue(name) : null;
    }

    public void addComponent(String name, JComponent component) {
        this.addComponent(name, null, component);
    }

    public void addComponent(String name, JCheckBox checkbox, JComponent component) {
        this.nameToComponent.put(name, component);
        this.nameToUneditedField.remove(name);
        if (checkbox != null) {
            this.link(name, checkbox, component);
        }
    }

    public JComponent getComponent(String name) {
        return (JComponent)this.nameToComponent.get(name);
    }

    public JCheckBox getCheckBox(String name) {
        return (JCheckBox)this.componentToCheckbox.get(name);
    }

    public Iterator getComponentIterator() {
        return this.nameToComponent.keySet().iterator();
    }

    public Iterator getUneditedFieldsIterator() {
        return this.nameToUneditedField.values().iterator();
    }

    private void link(String name, final JCheckBox checkbox, JComponent comp) {
        if (comp instanceof JTextComponent) {
            ((JTextComponent)comp).addKeyListener(new KeyAdapter(){

                public void keyTyped(KeyEvent evt) {
                    checkbox.setSelected(true);
                }
            });
            this.componentToCheckbox.put(name, checkbox);
        } else if (comp instanceof JComboBox) {
            JComboBox comboBox = (JComboBox)comp;
            comboBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent evt) {
                    checkbox.setSelected(true);
                }
            });
            if (comboBox.isEditable()) {
                JTextComponent editor = (JTextComponent)comboBox.getEditor().getEditorComponent();
                editor.addKeyListener(new KeyAdapter(){

                    public void keyTyped(KeyEvent evt) {
                        checkbox.setSelected(true);
                    }
                });
            }
            this.componentToCheckbox.put(name, checkbox);
        }
    }

    public boolean hasChanged() {
        Iterator it = this.componentToCheckbox.values().iterator();
        while (it.hasNext()) {
            if (!((JCheckBox)it.next()).isSelected()) continue;
            return true;
        }
        return false;
    }

    public void setCheckBoxesSelected(boolean selected) {
        Iterator it = this.componentToCheckbox.values().iterator();
        while (it.hasNext()) {
            ((JCheckBox)it.next()).setSelected(selected);
        }
    }

    public void setCheckBoxesVisible(boolean visible) {
        Iterator it = this.componentToCheckbox.values().iterator();
        while (it.hasNext()) {
            ((JCheckBox)it.next()).setVisible(visible);
        }
    }

    public void reset() {
        Iterator it = this.getComponentIterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            JComponent comp = this.getComponent(name);
            if (comp instanceof JTextComponent) {
                ((JTextComponent)comp).setText("");
                continue;
            }
            if (!(comp instanceof JComboBox)) continue;
            ((JComboBox)comp).setSelectedIndex(0);
        }
        this.setCheckBoxesSelected(true);
    }

    protected void initFields() {
        Iterator it = this.getComponentIterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            String value = this.getValue(name);
            JComponent comp = this.getComponent(name);
            if (comp instanceof JTextComponent) {
                if (value == null) continue;
                ((JTextComponent)comp).setText(value);
                if (!(comp instanceof JTextArea)) continue;
                ((JTextArea)comp).setCaretPosition(0);
                continue;
            }
            if (!(comp instanceof JComboBox)) continue;
            JComboBox box = (JComboBox)comp;
            LimeXMLSchema schema = this.getSchema();
            List enums = schema.getEnumerationFields();
            Iterator it2 = enums.iterator();
            while (it2.hasNext()) {
                ComboBoxValue combVal;
                SchemaFieldInfo infoField = (SchemaFieldInfo)it2.next();
                String currField = infoField.getCanonicalizedFieldName();
                if (!currField.equals(name)) continue;
                ArrayList<ComboBoxValue> values = new ArrayList<ComboBoxValue>();
                values.add(0, new ComboBoxValue());
                this.addEnums(infoField.getEnumerationList(), values);
                int index = 0;
                if (value != null && !value.equals("") && !values.contains(combVal = new ComboBoxValue(value))) {
                    values.add(combVal);
                }
                if (name.indexOf("__licensetype__") >= 0 && value != null && !value.equals("creativecommons.org/licenses/")) {
                    values.remove(new ComboBoxValue("creativecommons.org/licenses/"));
                }
                Object[] arr = values.toArray(new Object[0]);
                Arrays.sort(arr);
                if (value != null && !value.equals("")) {
                    index = Arrays.asList(arr).indexOf(new ComboBoxValue(value));
                }
                box.setModel(new DefaultComboBoxModel<Object>(arr));
                box.setSelectedIndex(index);
            }
        }
        this.setCheckBoxesSelected(false);
    }

    protected void prepareSave() {
    }

    public List getInput() {
        ArrayList<NameValue> nameValueList = new ArrayList<NameValue>();
        this.prepareSave();
        Iterator it = this.getComponentIterator();
        while (it.hasNext()) {
            String cbvalue;
            JComboBox box;
            ComboBoxValue cbv;
            String name = (String)it.next();
            JComponent comp = this.getComponent(name);
            JCheckBox checkbox = this.getCheckBox(name);
            if (checkbox != null && !checkbox.isSelected()) continue;
            String value = null;
            if (comp instanceof JTextComponent) {
                value = ((JTextComponent)comp).getText().trim();
            } else if (comp instanceof JComboBox && (cbv = (ComboBoxValue)(box = (JComboBox)comp).getSelectedItem()) != null && (cbvalue = cbv.getValue()) != null) {
                value = cbvalue.trim();
            }
            if (value == null) continue;
            NameValue namValue = new NameValue(name, value);
            nameValueList.add(namValue);
        }
        it = this.getUneditedFieldsIterator();
        while (it.hasNext()) {
            nameValueList.add((NameValue)it.next());
        }
        return nameValueList;
    }

    protected void addEnums(List nameValues, List comboValues) {
        Iterator it = nameValues.iterator();
        while (it.hasNext()) {
            comboValues.add(new ComboBoxValue((NameValue)it.next()));
        }
    }

    private void initWithDocumentFields() {
        if (this.document != null) {
            Iterator it = this.document.getNameValueSet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                String name = (String)entry.getKey();
                Object value = entry.getValue();
                this.nameToUneditedField.put(name, new NameValue(name, value));
            }
        }
    }

    public boolean checkInput() {
        return true;
    }

    public FileEventListener getFileEventListener() {
        return null;
    }
}

