/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.xml.editor;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileEventListener;
import com.limegroup.gnutella.gui.xml.editor.AbstractMetaEditorPanel;
import com.limegroup.gnutella.gui.xml.editor.MetaEditorUtil;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLReplyCollection;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.LimeXMLSchemaRepository;
import com.limegroup.gnutella.xml.SchemaReplyCollectionMapper;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTabbedPane;

public abstract class MetaEditorTabbedPane
extends JTabbedPane {
    protected final FileDesc[] fds;
    protected final LimeXMLDocument document;
    protected final LimeXMLSchema schema;

    public MetaEditorTabbedPane(FileDesc[] fds, String uri) {
        this.fds = fds;
        LimeXMLDocument[] docs = MetaEditorUtil.intersection(fds, uri);
        SchemaReplyCollectionMapper map = SchemaReplyCollectionMapper.instance();
        LimeXMLReplyCollection collection = map.getReplyCollection(uri);
        LimeXMLSchemaRepository rep = LimeXMLSchemaRepository.instance();
        this.schema = rep.getSchema(uri);
        LimeXMLDocument doc = null;
        for (int i = 0; i < docs.length; ++i) {
            if (!this.schema.equals(docs[i].getSchema())) continue;
            doc = docs[i];
            break;
        }
        this.document = doc;
    }

    public FileDesc[] getFileDesc() {
        return this.fds;
    }

    public LimeXMLDocument getDocument() {
        return this.document;
    }

    public LimeXMLSchema getSchema() {
        return this.schema;
    }

    public String getInput() {
        ArrayList nameValueList = new ArrayList();
        int count = this.getTabCount();
        for (int i = 0; i < count; ++i) {
            AbstractMetaEditorPanel panel;
            List list;
            Component tab = this.getComponentAt(i);
            if (!(tab instanceof AbstractMetaEditorPanel) || (list = (panel = (AbstractMetaEditorPanel)tab).getInput()) == null || list.isEmpty()) continue;
            nameValueList.addAll(list);
        }
        if (nameValueList.isEmpty()) {
            return null;
        }
        return new LimeXMLDocument(nameValueList, this.getSchema().getSchemaURI()).getXMLString();
    }

    public boolean checkInput() {
        int count = this.getTabCount();
        boolean inputValid = true;
        for (int i = 0; i < count; ++i) {
            Component tab = this.getComponentAt(i);
            if (!(tab instanceof AbstractMetaEditorPanel)) continue;
            AbstractMetaEditorPanel editor = (AbstractMetaEditorPanel)tab;
            inputValid &= editor.checkInput();
        }
        return inputValid;
    }

    public List getFileEventListeners() {
        ArrayList<FileEventListener> listenerList = new ArrayList<FileEventListener>();
        int count = this.getTabCount();
        for (int i = 0; i < count; ++i) {
            AbstractMetaEditorPanel panel;
            FileEventListener listener;
            Component tab = this.getComponentAt(i);
            if (!(tab instanceof AbstractMetaEditorPanel) || (listener = (panel = (AbstractMetaEditorPanel)tab).getFileEventListener()) == null) continue;
            listenerList.add(listener);
        }
        return listenerList;
    }
}

