/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.xml.editor;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.gui.LimeTextField;
import com.limegroup.gnutella.gui.xml.editor.MetaEditorPanel;
import com.limegroup.gnutella.gui.xml.editor.MetaEditorUtil;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class VideoEditor
extends MetaEditorPanel {
    private JLabel titleLabel;
    private LimeTextField titleTextField;
    private JLabel typeLabel;
    private JComboBox typeComboBox;
    private JCheckBox typeCheckBox;
    private JLabel yearLabel;
    private LimeTextField yearTextField;
    private JCheckBox yearCheckBox;
    private JLabel ratingLabel;
    private JComboBox ratingComboBox;
    private JCheckBox ratingCheckBox;
    private JLabel directorLabel;
    private LimeTextField directorTextField;
    private JCheckBox directorCheckBox;
    private JLabel studioLabel;
    private LimeTextField studioTextField;
    private JCheckBox studioCheckBox;
    private JLabel commentsLabel;
    private JScrollPane commentsScrollPane;
    private JTextArea commentsTextArea;
    private JCheckBox commentsCheckBox;
    private JLabel languageLabel;
    private LimeTextField languageTextField;
    private JCheckBox languageCheckBox;
    private JLabel starsLabel;
    private LimeTextField starsTextField;
    private JCheckBox starsCheckBox;
    private JLabel producerLabel;
    private LimeTextField producerTextField;
    private JCheckBox producerCheckBox;
    private JLabel subtitlesLabel;
    private LimeTextField subtitlesTextField;
    private JCheckBox subtitlesCheckBox;
    private JLabel licenseLabel;
    private LimeTextField licenseTextField;
    private JCheckBox licenseCheckBox;
    private String title = null;
    private boolean titleEdited = false;

    public VideoEditor(FileDesc[] fds, LimeXMLSchema schema, LimeXMLDocument doc) {
        super(fds, schema, doc);
        super.setName(MetaEditorUtil.getStringResource("videos__video"));
        this.init();
        this.initFields();
        this.setMultiEdit(fds.length > 1);
        if (this.licenseTextField.getText().equals("")) {
            this.licenseTextField.setVisible(false);
            this.licenseLabel.setVisible(false);
            this.licenseCheckBox.setVisible(false);
        }
        this.titleTextField.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent evt) {
                VideoEditor.this.titleEdited = true;
            }
        });
    }

    public void setMultiEdit(boolean multiEdit) {
        super.setMultiEdit(multiEdit);
        this.titleLabel.setVisible(!multiEdit);
        this.titleTextField.setVisible(!multiEdit);
    }

    public boolean hasChanged() {
        return this.titleEdited || super.hasChanged();
    }

    protected void prepareSave() {
        String text;
        if (this.title != null && (text = this.titleTextField.getText().trim()).equals("")) {
            this.titleTextField.setText(this.title);
        }
    }

    protected void initFields() {
        this.addComponent("videos__video__title__", this.titleTextField);
        this.addComponent("videos__video__comments__", this.commentsCheckBox, this.commentsTextArea);
        this.addComponent("videos__video__year__", this.yearCheckBox, this.yearTextField);
        this.addComponent("videos__video__type__", this.typeCheckBox, this.typeComboBox);
        this.addComponent("videos__video__director__", this.directorCheckBox, this.directorTextField);
        this.addComponent("videos__video__studio__", this.studioCheckBox, this.studioTextField);
        this.addComponent("videos__video__rating__", this.ratingCheckBox, this.ratingComboBox);
        this.addComponent("videos__video__license__", this.licenseCheckBox, this.licenseTextField);
        this.addComponent("videos__video__stars__", this.starsCheckBox, this.starsTextField);
        this.addComponent("videos__video__producer__", this.producerCheckBox, this.producerTextField);
        this.addComponent("videos__video__language__", this.languageCheckBox, this.languageTextField);
        this.addComponent("videos__video__subtitles__", this.subtitlesCheckBox, this.subtitlesTextField);
        super.initFields();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 3, 0, 2);
        gbc.gridx = 1;
        gbc.gridy = 0;
        this.titleLabel = new JLabel(MetaEditorUtil.getStringResource("videos__video__title__"));
        this.add((Component)this.titleLabel, gbc);
        gbc.insets = new Insets(0, 3, 2, 2);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 3;
        this.titleTextField = new LimeTextField(35);
        this.add((Component)this.titleTextField, gbc);
        gbc.insets = new Insets(5, 3, 0, 2);
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        this.directorLabel = new JLabel(MetaEditorUtil.getStringResource("videos__video__director__"));
        this.add((Component)this.directorLabel, gbc);
        gbc.insets = new Insets(0, 3, 0, 0);
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        this.directorCheckBox = new JCheckBox();
        this.add((Component)this.directorCheckBox, gbc);
        gbc.insets = new Insets(0, 3, 2, 2);
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        this.directorTextField = new LimeTextField(24);
        this.add((Component)this.directorTextField, gbc);
        gbc.insets = new Insets(5, 3, 0, 2);
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        this.starsLabel = new JLabel(MetaEditorUtil.getStringResource("videos__video__stars__"));
        this.add((Component)this.starsLabel, gbc);
        gbc.insets = new Insets(0, 3, 0, 0);
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        this.starsCheckBox = new JCheckBox();
        this.add((Component)this.starsCheckBox, gbc);
        gbc.insets = new Insets(0, 3, 2, 2);
        gbc.gridx = 1;
        gbc.gridy = 5;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        this.starsTextField = new LimeTextField(24);
        this.add((Component)this.starsTextField, gbc);
        gbc.insets = new Insets(5, 3, 0, 2);
        gbc.gridx = 1;
        gbc.gridy = 6;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        this.producerLabel = new JLabel(MetaEditorUtil.getStringResource("videos__video__producer__"));
        this.add((Component)this.producerLabel, gbc);
        gbc.insets = new Insets(0, 3, 0, 0);
        gbc.gridx = 0;
        gbc.gridy = 7;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        this.producerCheckBox = new JCheckBox();
        this.add((Component)this.producerCheckBox, gbc);
        gbc.insets = new Insets(0, 3, 2, 2);
        gbc.gridx = 1;
        gbc.gridy = 7;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        this.producerTextField = new LimeTextField(24);
        this.add((Component)this.producerTextField, gbc);
        gbc.insets = new Insets(5, 3, 0, 2);
        gbc.gridx = 1;
        gbc.gridy = 8;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        this.studioLabel = new JLabel(MetaEditorUtil.getStringResource("videos__video__studio__"));
        this.add((Component)this.studioLabel, gbc);
        gbc.insets = new Insets(0, 3, 0, 0);
        gbc.gridx = 0;
        gbc.gridy = 9;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        this.studioCheckBox = new JCheckBox();
        this.add((Component)this.studioCheckBox, gbc);
        gbc.insets = new Insets(0, 3, 2, 2);
        gbc.gridx = 1;
        gbc.gridy = 9;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        this.studioTextField = new LimeTextField(24);
        this.add((Component)this.studioTextField, gbc);
        gbc.insets = new Insets(5, 3, 0, 2);
        gbc.gridx = 1;
        gbc.gridy = 10;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        this.commentsLabel = new JLabel(MetaEditorUtil.getStringResource("videos__video__comments__"));
        this.add((Component)this.commentsLabel, gbc);
        gbc.insets = new Insets(0, 3, 0, 0);
        gbc.gridx = 0;
        gbc.gridy = 11;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        this.commentsCheckBox = new JCheckBox();
        this.add((Component)this.commentsCheckBox, gbc);
        gbc.insets = new Insets(0, 3, 2, 2);
        gbc.gridx = 1;
        gbc.gridy = 11;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        this.commentsTextArea = new JTextArea();
        this.commentsTextArea.setLineWrap(true);
        this.commentsTextArea.setWrapStyleWord(true);
        this.commentsScrollPane = new JScrollPane(this.commentsTextArea);
        this.commentsScrollPane.setHorizontalScrollBarPolicy(31);
        this.commentsScrollPane.setPreferredSize(new Dimension(22, 50));
        this.add((Component)this.commentsScrollPane, gbc);
        gbc.fill = 0;
        gbc.insets = new Insets(5, 3, 0, 2);
        gbc.gridx = 1;
        gbc.gridy = 12;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        this.subtitlesLabel = new JLabel(MetaEditorUtil.getStringResource("videos__video__subtitles__"));
        this.add((Component)this.subtitlesLabel, gbc);
        gbc.insets = new Insets(0, 3, 0, 0);
        gbc.gridx = 0;
        gbc.gridy = 13;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        this.subtitlesCheckBox = new JCheckBox();
        this.add((Component)this.subtitlesCheckBox, gbc);
        gbc.insets = new Insets(0, 3, 2, 2);
        gbc.gridx = 1;
        gbc.gridy = 13;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        this.subtitlesTextField = new LimeTextField(24);
        this.add((Component)this.subtitlesTextField, gbc);
        gbc.insets = new Insets(5, 3, 0, 2);
        gbc.gridx = 1;
        gbc.gridy = 14;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        this.licenseLabel = new JLabel(MetaEditorUtil.getStringResource("videos__video__license__"));
        this.add((Component)this.licenseLabel, gbc);
        gbc.insets = new Insets(0, 3, 0, 0);
        gbc.gridx = 0;
        gbc.gridy = 15;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        this.licenseCheckBox = new JCheckBox();
        this.add((Component)this.licenseCheckBox, gbc);
        gbc.insets = new Insets(0, 3, 2, 2);
        gbc.gridx = 1;
        gbc.gridy = 15;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        this.licenseTextField = new LimeTextField(24);
        this.licenseTextField.setEnabled(false);
        this.add((Component)this.licenseTextField, gbc);
        gbc.fill = 2;
        gbc.insets = new Insets(5, 3, 0, 2);
        gbc.gridx = 3;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        this.yearLabel = new JLabel(MetaEditorUtil.getStringResource("videos__video__year__"));
        this.add((Component)this.yearLabel, gbc);
        gbc.insets = new Insets(0, 3, 0, 0);
        gbc.gridx = 2;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        this.yearCheckBox = new JCheckBox();
        this.add((Component)this.yearCheckBox, gbc);
        gbc.insets = new Insets(0, 3, 2, 2);
        gbc.gridx = 3;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        this.yearTextField = new LimeTextField(6);
        this.add((Component)this.yearTextField, gbc);
        gbc.insets = new Insets(5, 3, 0, 2);
        gbc.gridx = 3;
        gbc.gridy = 4;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        this.ratingLabel = new JLabel(MetaEditorUtil.getStringResource("videos__video__rating__"));
        this.add((Component)this.ratingLabel, gbc);
        gbc.insets = new Insets(0, 3, 0, 0);
        gbc.gridx = 2;
        gbc.gridy = 5;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        this.ratingCheckBox = new JCheckBox();
        this.add((Component)this.ratingCheckBox, gbc);
        gbc.insets = new Insets(0, 3, 2, 2);
        gbc.gridx = 3;
        gbc.gridy = 5;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        this.ratingComboBox = new JComboBox();
        this.add((Component)this.ratingComboBox, gbc);
        gbc.insets = new Insets(5, 3, 0, 2);
        gbc.gridx = 3;
        gbc.gridy = 6;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        this.languageLabel = new JLabel(MetaEditorUtil.getStringResource("videos__video__language__"));
        this.add((Component)this.languageLabel, gbc);
        gbc.insets = new Insets(0, 3, 0, 0);
        gbc.gridx = 2;
        gbc.gridy = 7;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        this.languageCheckBox = new JCheckBox();
        this.add((Component)this.languageCheckBox, gbc);
        gbc.insets = new Insets(0, 3, 2, 2);
        gbc.gridx = 3;
        gbc.gridy = 7;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        this.languageTextField = new LimeTextField(6);
        this.add((Component)this.languageTextField, gbc);
        gbc.insets = new Insets(5, 3, 0, 2);
        gbc.gridx = 3;
        gbc.gridy = 8;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        this.typeLabel = new JLabel(MetaEditorUtil.getStringResource("videos__video__type__"));
        this.add((Component)this.typeLabel, gbc);
        gbc.insets = new Insets(0, 3, 0, 0);
        gbc.gridx = 2;
        gbc.gridy = 9;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        this.typeCheckBox = new JCheckBox();
        this.add((Component)this.typeCheckBox, gbc);
        gbc.insets = new Insets(0, 3, 2, 2);
        gbc.gridx = 3;
        gbc.gridy = 9;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        this.typeComboBox = new JComboBox();
        this.add((Component)this.typeComboBox, gbc);
    }
}

