/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.xml.editor.audio;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.gui.LimeTextField;
import com.limegroup.gnutella.gui.xml.ComboBoxValue;
import com.limegroup.gnutella.gui.xml.editor.AutoCompleteComboBoxEditor;
import com.limegroup.gnutella.gui.xml.editor.MetaEditorPanel;
import com.limegroup.gnutella.gui.xml.editor.MetaEditorUtil;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.SchemaFieldInfo;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

class AudioEditor
extends MetaEditorPanel {
    private String title = null;
    private boolean titleEdited = false;
    private JCheckBox albumCheckBox;
    private JLabel albumLabel;
    private LimeTextField albumTextField;
    private JCheckBox artistCheckBox;
    private JLabel artistLabel;
    private LimeTextField artistTextField;
    private JCheckBox commentsCheckBox;
    private JLabel commentsLabel;
    private JScrollPane commentsScrollPane;
    private JTextArea commentsTextArea;
    private JCheckBox genreCheckBox;
    private JComboBox genreComboBox;
    private JLabel genreLabel;
    private JCheckBox languageCheckBox;
    private JLabel languageLabel;
    private LimeTextField languageTextField;
    private JLabel titleLabel;
    private LimeTextField titleTextField;
    private JCheckBox trackCheckBox;
    private JLabel trackLabel;
    private LimeTextField trackTextField;
    private JCheckBox typeCheckBox;
    private JComboBox typeComboBox;
    private JLabel typeLabel;
    private JCheckBox yearCheckBox;
    private JLabel yearLabel;
    private LimeTextField yearTextField;

    public AudioEditor(FileDesc[] fds, LimeXMLSchema schema, LimeXMLDocument doc) {
        super(fds, schema, doc);
        this.initComponents();
        this.initLabels();
        super.setName(MetaEditorUtil.getStringResource("audios__audio"));
        AutoCompleteComboBoxEditor editor = new AutoCompleteComboBoxEditor();
        this.genreComboBox.setEditor(editor);
        this.initTextFields();
        editor.setModel(this.genreComboBox.getModel());
        this.setMultiEdit(fds.length > 1);
    }

    public boolean hasChanged() {
        return this.titleEdited || super.hasChanged();
    }

    public void setMultiEdit(boolean multiEdit) {
        super.setMultiEdit(multiEdit);
        this.titleLabel.setVisible(!multiEdit);
        this.titleTextField.setVisible(!multiEdit);
    }

    private void initTextFields() {
        LimeXMLDocument doc = this.getDocument();
        this.title = null;
        String track = null;
        String artist = null;
        String album = null;
        String genre = null;
        String comments = null;
        String year = null;
        String type = null;
        String language = null;
        if (doc != null) {
            this.title = doc.getValue("audios__audio__title__");
            track = doc.getValue("audios__audio__track__");
            artist = doc.getValue("audios__audio__artist__");
            album = doc.getValue("audios__audio__album__");
            genre = doc.getValue("audios__audio__genre__");
            comments = doc.getValue("audios__audio__comments__");
            year = doc.getValue("audios__audio__year__");
            type = doc.getValue("audios__audio__type__");
            language = doc.getValue("audios__audio__language__");
        }
        this.addComponent("audios__audio__title__", this.titleTextField);
        this.addComponent("audios__audio__artist__", this.artistCheckBox, this.artistTextField);
        this.addComponent("audios__audio__album__", this.albumCheckBox, this.albumTextField);
        this.addComponent("audios__audio__year__", this.yearCheckBox, this.yearTextField);
        this.addComponent("audios__audio__track__", this.trackCheckBox, this.trackTextField);
        this.addComponent("audios__audio__language__", this.languageCheckBox, this.languageTextField);
        this.addComponent("audios__audio__comments__", this.commentsCheckBox, this.commentsTextArea);
        this.addComponent("audios__audio__type__", this.typeCheckBox, this.typeComboBox);
        this.addComponent("audios__audio__genre__", this.genreCheckBox, this.genreComboBox);
        if (this.title != null) {
            this.titleTextField.setText(this.title);
        }
        if (artist != null) {
            this.artistTextField.setText(artist);
        }
        if (album != null) {
            this.albumTextField.setText(album);
        }
        if (year != null) {
            this.yearTextField.setText(year);
        }
        if (track != null) {
            this.trackTextField.setText(track);
        }
        if (language != null) {
            this.languageTextField.setText(language);
        }
        if (comments != null) {
            this.commentsTextArea.setText(comments);
            this.commentsTextArea.setCaretPosition(0);
        }
        LimeXMLSchema schema = this.getSchema();
        List enums = schema.getEnumerationFields();
        Iterator it = enums.iterator();
        while (it.hasNext()) {
            Object[] arr;
            SchemaFieldInfo infoField = (SchemaFieldInfo)it.next();
            String currField = infoField.getCanonicalizedFieldName();
            if (currField.equals("audios__audio__genre__")) {
                ComboBoxValue value;
                ArrayList<ComboBoxValue> values = new ArrayList<ComboBoxValue>();
                values.add(0, new ComboBoxValue());
                this.addEnums(infoField.getEnumerationList(), values);
                int index = 0;
                if (genre != null && !genre.equals("") && !values.contains(value = new ComboBoxValue(genre))) {
                    values.add(value);
                }
                arr = values.toArray(new Object[0]);
                Arrays.sort(arr);
                if (genre != null && !genre.equals("")) {
                    index = Arrays.asList(arr).indexOf(new ComboBoxValue(genre));
                }
                this.genreComboBox.setModel(new DefaultComboBoxModel<Object>(arr));
                this.genreComboBox.setSelectedIndex(index);
                this.genreComboBox.setMaximumRowCount(15);
                continue;
            }
            if (!currField.equals("audios__audio__type__")) continue;
            int index = 0;
            ArrayList<ComboBoxValue> values = new ArrayList<ComboBoxValue>();
            values.add(0, new ComboBoxValue());
            this.addEnums(infoField.getEnumerationList(), values);
            arr = values.toArray(new Object[0]);
            Arrays.sort(arr);
            if (type != null && !type.equals("")) {
                index = Arrays.asList(arr).indexOf(new ComboBoxValue(type));
            }
            this.typeComboBox.setModel(new DefaultComboBoxModel<Object>(arr));
            this.typeComboBox.setSelectedIndex(index);
        }
        this.titleTextField.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent evt) {
                AudioEditor.this.titleEdited = true;
            }
        });
        this.setCheckBoxesSelected(false);
    }

    private void initLabels() {
        this.titleLabel.setText(MetaEditorUtil.getStringResource("audios__audio__title__"));
        this.artistLabel.setText(MetaEditorUtil.getStringResource("audios__audio__artist__"));
        this.albumLabel.setText(MetaEditorUtil.getStringResource("audios__audio__album__"));
        this.yearLabel.setText(MetaEditorUtil.getStringResource("audios__audio__year__"));
        this.trackLabel.setText(MetaEditorUtil.getStringResource("audios__audio__track__"));
        this.languageLabel.setText(MetaEditorUtil.getStringResource("audios__audio__language__"));
        this.commentsLabel.setText(MetaEditorUtil.getStringResource("audios__audio__comments__"));
        this.genreLabel.setText(MetaEditorUtil.getStringResource("audios__audio__genre__"));
        this.typeLabel.setText(MetaEditorUtil.getStringResource("audios__audio__type__"));
    }

    protected void prepareSave() {
        String text;
        if (this.title != null && !this.isMultiEdit() && (text = this.titleTextField.getText().trim()).equals("")) {
            this.titleTextField.setText(this.title);
        }
    }

    private void initComponents() {
        this.titleLabel = new JLabel();
        this.titleTextField = new LimeTextField();
        this.artistLabel = new JLabel();
        this.artistTextField = new LimeTextField();
        this.albumLabel = new JLabel();
        this.albumTextField = new LimeTextField();
        this.commentsLabel = new JLabel();
        this.commentsScrollPane = new JScrollPane();
        this.commentsTextArea = new JTextArea();
        this.genreLabel = new JLabel();
        this.genreComboBox = new JComboBox();
        this.yearLabel = new JLabel();
        this.trackLabel = new JLabel();
        this.yearCheckBox = new JCheckBox();
        this.artistCheckBox = new JCheckBox();
        this.albumCheckBox = new JCheckBox();
        this.commentsCheckBox = new JCheckBox();
        this.genreCheckBox = new JCheckBox();
        this.trackCheckBox = new JCheckBox();
        this.languageLabel = new JLabel();
        this.languageTextField = new LimeTextField();
        this.languageCheckBox = new JCheckBox();
        this.typeLabel = new JLabel();
        this.typeComboBox = new JComboBox();
        this.typeCheckBox = new JCheckBox();
        this.yearTextField = new LimeTextField();
        this.trackTextField = new LimeTextField();
        JPanel spacer1 = new JPanel();
        JPanel spacer2 = new JPanel();
        JPanel spacer3 = new JPanel();
        JPanel spacer4 = new JPanel();
        this.setLayout(new GridBagLayout());
        this.setNextFocusableComponent(this.titleTextField);
        this.setOpaque(false);
        this.titleLabel.setText("TITLE");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 300;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.add((Component)this.titleLabel, gridBagConstraints);
        this.titleTextField.setNextFocusableComponent(this.artistTextField);
        this.titleTextField.setPreferredSize(new Dimension(4, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        this.add((Component)this.titleTextField, gridBagConstraints);
        this.artistLabel.setText("ARTIST");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 300;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.add((Component)this.artistLabel, gridBagConstraints);
        this.artistTextField.setNextFocusableComponent(this.yearTextField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.add((Component)this.artistTextField, gridBagConstraints);
        this.albumLabel.setText("ALBUM");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.add((Component)this.albumLabel, gridBagConstraints);
        this.albumTextField.setNextFocusableComponent(this.trackTextField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        this.add((Component)this.albumTextField, gridBagConstraints);
        this.commentsLabel.setText("COMMENTS");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.add((Component)this.commentsLabel, gridBagConstraints);
        this.commentsScrollPane.setHorizontalScrollBarPolicy(31);
        this.commentsScrollPane.setPreferredSize(new Dimension(22, 22));
        this.commentsTextArea.setLineWrap(true);
        this.commentsTextArea.setWrapStyleWord(true);
        this.commentsTextArea.setMinimumSize(new Dimension(8, 13));
        this.commentsTextArea.setNextFocusableComponent(this.genreComboBox);
        this.commentsTextArea.setPreferredSize(new Dimension(8, 13));
        this.commentsScrollPane.setViewportView(this.commentsTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 80;
        this.add((Component)this.commentsScrollPane, gridBagConstraints);
        this.genreLabel.setText("GENRE");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.add((Component)this.genreLabel, gridBagConstraints);
        this.genreComboBox.setEditable(true);
        this.genreComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"", "GENRE1", "GENRE2", "GENRE3"}));
        this.genreComboBox.setMinimumSize(new Dimension(160, 22));
        this.genreComboBox.setNextFocusableComponent(this);
        this.genreComboBox.setPreferredSize(new Dimension(160, 22));
        this.genreComboBox.setAutoscrolls(true);
        this.genreComboBox.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.genreComboBox, gridBagConstraints);
        this.yearLabel.setText("YEAR");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.add((Component)this.yearLabel, gridBagConstraints);
        this.trackLabel.setText("TRACK");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.add((Component)this.trackLabel, gridBagConstraints);
        this.yearCheckBox.setFocusPainted(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        this.add((Component)this.yearCheckBox, gridBagConstraints);
        this.artistCheckBox.setFocusPainted(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        this.add((Component)this.artistCheckBox, gridBagConstraints);
        this.albumCheckBox.setFocusPainted(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        this.add((Component)this.albumCheckBox, gridBagConstraints);
        this.commentsCheckBox.setFocusPainted(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        this.add((Component)this.commentsCheckBox, gridBagConstraints);
        this.genreCheckBox.setFocusPainted(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        this.add((Component)this.genreCheckBox, gridBagConstraints);
        this.trackCheckBox.setFocusPainted(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        this.add((Component)this.trackCheckBox, gridBagConstraints);
        this.languageLabel.setText("LANGUAGE");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.add((Component)this.languageLabel, gridBagConstraints);
        this.languageTextField.setNextFocusableComponent(this.typeComboBox);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        this.add((Component)this.languageTextField, gridBagConstraints);
        this.languageCheckBox.setFocusPainted(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        this.add((Component)this.languageCheckBox, gridBagConstraints);
        this.typeLabel.setText("TYPE");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.add((Component)this.typeLabel, gridBagConstraints);
        this.typeComboBox.setMaximumRowCount(15);
        this.typeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"", "TYPE1", "TYPE2", "TYPE3"}));
        this.typeComboBox.setNextFocusableComponent(this.commentsTextArea);
        this.typeComboBox.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        this.add((Component)this.typeComboBox, gridBagConstraints);
        this.typeCheckBox.setFocusPainted(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        this.add((Component)this.typeCheckBox, gridBagConstraints);
        this.yearTextField.setNextFocusableComponent(this.albumTextField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.add((Component)this.yearTextField, gridBagConstraints);
        this.trackTextField.setNextFocusableComponent(this.languageTextField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        this.add((Component)this.trackTextField, gridBagConstraints);
        spacer1.setMaximumSize(new Dimension(22, 10));
        spacer1.setMinimumSize(new Dimension(22, 10));
        spacer1.setPreferredSize(new Dimension(22, 10));
        spacer1.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)spacer1, gridBagConstraints);
        spacer2.setMaximumSize(new Dimension(22, 10));
        spacer2.setMinimumSize(new Dimension(22, 10));
        spacer2.setPreferredSize(new Dimension(22, 10));
        spacer2.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.add((Component)spacer2, gridBagConstraints);
        spacer3.setMinimumSize(new Dimension(22, 10));
        spacer3.setPreferredSize(new Dimension(22, 10));
        spacer3.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        this.add((Component)spacer3, gridBagConstraints);
        spacer4.setMinimumSize(new Dimension(22, 10));
        spacer4.setPreferredSize(new Dimension(22, 10));
        spacer4.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        this.add((Component)spacer4, gridBagConstraints);
    }
}

