/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.handshaking;

import com.limegroup.gnutella.handshaking.BadHandshakeException;
import com.limegroup.gnutella.handshaking.BlockingHandshakeSupport;
import com.limegroup.gnutella.handshaking.HandshakeResponder;
import com.limegroup.gnutella.handshaking.HandshakeResponse;
import com.limegroup.gnutella.handshaking.Handshaker;
import com.limegroup.gnutella.handshaking.NoGnutellaOkException;
import com.limegroup.gnutella.statistics.HandshakingStat;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class BlockingIncomingHandshaker
implements Handshaker {
    private HandshakeResponder responder;
    private BlockingHandshakeSupport support;

    public BlockingIncomingHandshaker(HandshakeResponder responder, Socket socket, InputStream in, OutputStream out) {
        this.responder = responder;
        this.support = new BlockingHandshakeSupport(socket, in, out);
    }

    public void shake() throws IOException, BadHandshakeException, NoGnutellaOkException {
        this.initializeIncoming();
        this.concludeIncomingHandshake();
    }

    public HandshakeResponse getReadHeaders() {
        return this.support.getReadHandshakeResponse();
    }

    public HandshakeResponse getWrittenHeaders() {
        return this.support.getWrittenHandshakeResponse();
    }

    private void initializeIncoming() throws IOException {
        String connectString = this.support.readLine();
        if (!this.support.notLessThan06(connectString)) {
            throw new IOException("Unexpected connect string: " + connectString);
        }
        this.support.readHeaders();
    }

    private void concludeIncomingHandshake() throws IOException {
        HandshakeResponse theirRequest = this.support.getReadHandshakeResponse();
        HandshakeResponse ourResponse = this.responder.respond(theirRequest, false);
        this.support.writeResponse(ourResponse);
        if (theirRequest.isCrawler()) {
            this.support.readLine();
            throw new IOException("crawler");
        }
        switch (ourResponse.getStatusCode()) {
            case 200: {
                break;
            }
            case 503: {
                HandshakingStat.INCOMING_CLIENT_REJECT.incrementStat();
                throw NoGnutellaOkException.CLIENT_REJECT;
            }
            default: {
                HandshakingStat.INCOMING_CLIENT_UNKNOWN.incrementStat();
                throw NoGnutellaOkException.createClientUnknown(ourResponse.getStatusCode());
            }
        }
        String connectLine = this.support.readLine();
        if (!this.support.isConnectLineValid(connectLine)) {
            HandshakingStat.INCOMING_BAD_CONNECT.incrementStat();
            throw new IOException("Bad connect string");
        }
        this.support.readHeaders();
        HandshakeResponse theirResponse = this.support.createRemoteResponse(connectLine);
        switch (theirResponse.getStatusCode()) {
            case 200: {
                HandshakingStat.SUCCESSFUL_INCOMING.incrementStat();
                break;
            }
            default: {
                HandshakingStat.INCOMING_SERVER_UNKNOWN.incrementStat();
                throw NoGnutellaOkException.createServerUnknown(theirResponse.getStatusCode());
            }
        }
    }
}

