/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.handshaking;

import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.handshaking.HandshakeResponse;
import com.limegroup.gnutella.http.HeaderSupport;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.StringSetting;
import com.limegroup.gnutella.util.NetworkUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Properties;

class HandshakeSupport
extends HeaderSupport {
    private String GNUTELLA_CONNECT_06 = "GNUTELLA CONNECT/0.6";
    private static final String GNUTELLA_06 = "GNUTELLA/0.6";
    private static final String CONNECT = "CONNECT/";
    private static final String CRLF = "\r\n";
    private final Properties readHeaders;
    private final Properties writtenHeaders;
    private final String remoteAddress;
    private String remoteResponse;

    HandshakeSupport(String remoteAddress) {
        this.remoteAddress = remoteAddress;
        this.readHeaders = new Properties();
        this.writtenHeaders = new Properties();
    }

    HandshakeResponse createRemoteResponse(String connectLine) throws IOException {
        this.remoteResponse = connectLine.substring(GNUTELLA_06.length()).trim();
        return HandshakeResponse.createRemoteResponse(this.remoteResponse, this.readHeaders);
    }

    void appendConnectLine(StringBuffer sb) {
        sb.append(this.GNUTELLA_CONNECT_06).append(CRLF);
    }

    void appendResponse(HandshakeResponse response, StringBuffer sb) {
        sb.append(GNUTELLA_06).append(" ").append(response.getStatusLine()).append(CRLF);
        this.appendHeaders(response.props(), sb);
    }

    void appendHeaders(Properties props, StringBuffer sb) {
        if (props != null) {
            Enumeration<?> names = props.propertyNames();
            while (names.hasMoreElements()) {
                String key = (String)names.nextElement();
                String value = props.getProperty(key);
                String toWrite = this.processKeyValueForWriting(key, value);
                sb.append(toWrite);
            }
        }
        sb.append(CRLF);
    }

    boolean isConnectLineValid(String s) {
        return s.startsWith(GNUTELLA_06);
    }

    boolean notLessThan06(String line) {
        int i = line.indexOf(CONNECT);
        if (i < 0) {
            return false;
        }
        try {
            float f = Float.parseFloat(line.substring(i + CONNECT.length()));
            return f >= 0.6f;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public boolean processReadHeader(String line) {
        if (line.equals("")) {
            return false;
        }
        int i = line.indexOf(58);
        if (i > 0) {
            String key = line.substring(0, i);
            String value = line.substring(i + 1).trim();
            if ("Remote-IP".equals(key)) {
                this.changeAddress(value);
            }
            this.readHeaders.put(key, value);
        }
        return true;
    }

    String processKeyValueForWriting(String key, String value) {
        if ("Remote-IP".equals(key)) {
            value = this.remoteAddress;
        }
        if (value == null) {
            value = "";
        }
        this.writtenHeaders.put(key, value);
        return key + ": " + value + CRLF;
    }

    private void changeAddress(String v) {
        InetAddress ia = null;
        try {
            ia = InetAddress.getByName(v);
        }
        catch (UnknownHostException uhe) {
            return;
        }
        if (!NetworkUtils.isValidAddress(ia) || NetworkUtils.isPrivateAddress(ia)) {
            return;
        }
        if (ConnectionSettings.FORCE_IP_ADDRESS.getValue()) {
            StringSetting addr = ConnectionSettings.FORCED_IP_ADDRESS_STRING;
            if (!v.equals(addr.getValue())) {
                addr.setValue(v);
                RouterService.addressChanged();
            }
        } else if (!NetworkUtils.isValidAddress(RouterService.getAddress())) {
            RouterService.getAcceptor().setAddress(ia);
        }
        RouterService.getAcceptor().setExternalAddress(ia);
    }

    public int getHeadersReadSize() {
        return this.readHeaders.size();
    }

    HandshakeResponse getReadHandshakeRemoteResponse() throws IOException {
        return HandshakeResponse.createRemoteResponse(this.remoteResponse, this.readHeaders);
    }

    HandshakeResponse getReadHandshakeResponse() {
        return HandshakeResponse.createResponse(this.readHeaders);
    }

    HandshakeResponse getWrittenHandshakeResponse() {
        return HandshakeResponse.createResponse(this.writtenHeaders);
    }
}

