/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.handshaking;

import com.limegroup.gnutella.handshaking.DefaultHandshakeResponder;
import com.limegroup.gnutella.handshaking.HandshakeResponse;
import com.limegroup.gnutella.handshaking.HandshakeStatus;
import com.limegroup.gnutella.handshaking.HeaderNames;
import com.limegroup.gnutella.handshaking.LeafHeaders;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.statistics.HandshakingStat;
import java.util.Properties;

public final class LeafHandshakeResponder
extends DefaultHandshakeResponder {
    public LeafHandshakeResponder(String host) {
        super(host);
    }

    protected HandshakeResponse respondToOutgoing(HandshakeResponse response) {
        if (!response.isUltrapeer()) {
            HandshakingStat.LEAF_OUTGOING_REJECT_LEAF.incrementStat();
            return HandshakeResponse.createLeafRejectOutgoingResponse(HandshakeStatus.WE_ARE_LEAVES);
        }
        if (this.getLocalePreferencing() && !ApplicationSettings.LANGUAGE.getValue().equals(response.getLocalePref())) {
            return HandshakeResponse.createLeafRejectLocaleOutgoingResponse();
        }
        HandshakeStatus status = this._manager.allowConnection(response);
        if (!status.isAcceptable()) {
            HandshakingStat.LEAF_OUTGOING_REJECT_OLD_UP.incrementStat();
            return HandshakeResponse.createLeafRejectOutgoingResponse(status);
        }
        Properties ret = new Properties();
        if (response.isDeflateAccepted()) {
            ret.put(HeaderNames.CONTENT_ENCODING, HeaderNames.DEFLATE_VALUE);
        }
        HandshakingStat.LEAF_OUTGOING_ACCEPT.incrementStat();
        return HandshakeResponse.createAcceptOutgoingResponse(ret);
    }

    protected HandshakeResponse respondToIncoming(HandshakeResponse hr) {
        if (hr.isCrawler()) {
            HandshakingStat.INCOMING_CRAWLER.incrementStat();
            return HandshakeResponse.createCrawlerResponse();
        }
        if (!hr.isUltrapeer()) {
            HandshakingStat.LEAF_INCOMING_REJECT.incrementStat();
            return HandshakeResponse.createLeafRejectOutgoingResponse(HandshakeStatus.WE_ARE_LEAVES);
        }
        LeafHeaders ret = new LeafHeaders(this.getRemoteIP());
        HandshakeStatus status = this._manager.allowConnection(hr);
        if (!status.isAcceptable()) {
            HandshakingStat.LEAF_INCOMING_REJECT.incrementStat();
            return HandshakeResponse.createLeafRejectIncomingResponse(hr, status);
        }
        if (hr.isDeflateAccepted()) {
            ret.put(HeaderNames.CONTENT_ENCODING, HeaderNames.DEFLATE_VALUE);
        }
        HandshakingStat.LEAF_INCOMING_ACCEPT.incrementStat();
        return HandshakeResponse.createAcceptIncomingResponse(hr, ret);
    }
}

