/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.handshaking;

import com.limegroup.gnutella.handshaking.HandshakeResponse;
import com.limegroup.gnutella.handshaking.HandshakeSupport;
import com.limegroup.gnutella.handshaking.NoGnutellaOkException;
import com.limegroup.gnutella.http.ReadHeadersIOState;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.statistics.BandwidthStat;
import com.limegroup.gnutella.statistics.HandshakingStat;
import java.io.IOException;

abstract class ReadHandshakeState
extends ReadHeadersIOState {
    protected ReadHandshakeState(HandshakeSupport support) {
        super(support, BandwidthStat.GNUTELLA_HEADER_DOWNSTREAM_BANDWIDTH, ConnectionSettings.MAX_HANDSHAKE_HEADERS.getValue(), ConnectionSettings.MAX_HANDSHAKE_LINE_SIZE.getValue());
    }

    static class ReadResponseState
    extends ReadHandshakeState {
        ReadResponseState(HandshakeSupport support) {
            super(support);
        }

        protected void processConnectLine() throws IOException {
            if (((HandshakeSupport)this.support).getReadHandshakeResponse().isCrawler()) {
                throw new IOException("crawler");
            }
            if (!((HandshakeSupport)this.support).isConnectLineValid(this.connectLine)) {
                HandshakingStat.INCOMING_BAD_CONNECT.incrementStat();
                throw new IOException("Bad connect string");
            }
        }

        protected void processHeaders() throws IOException {
            HandshakeResponse theirResponse = ((HandshakeSupport)this.support).createRemoteResponse(this.connectLine);
            switch (theirResponse.getStatusCode()) {
                case 200: {
                    HandshakingStat.SUCCESSFUL_INCOMING.incrementStat();
                    break;
                }
                default: {
                    HandshakingStat.INCOMING_SERVER_UNKNOWN.incrementStat();
                    throw NoGnutellaOkException.createServerUnknown(theirResponse.getStatusCode());
                }
            }
        }
    }

    static class ReadRequestState
    extends ReadHandshakeState {
        ReadRequestState(HandshakeSupport support) {
            super(support);
        }

        protected void processConnectLine() throws IOException {
            if (!((HandshakeSupport)this.support).notLessThan06(this.connectLine)) {
                throw new IOException("not a valid connect string!");
            }
        }

        protected void processHeaders() throws IOException {
        }
    }
}

