/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.http;

import com.limegroup.gnutella.util.Sockets;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpClientManager {
    private static final Log LOG = LogFactory.getLog(HttpClientManager.class);
    private static final int CONNECTION_TIMEOUT = 5000;
    private static final int TIMEOUT = 8000;
    private static final int MAXIMUM_REDIRECTS = 10;
    private static final long IDLE_TIME = 30000L;
    private static final HttpConnectionManager MANAGER = new MultiThreadedHttpConnectionManager();

    public static HttpClient getNewClient() {
        return HttpClientManager.getNewClient(5000, 8000);
    }

    public static HttpClient getNewClient(int connectTimeout, int soTimeout) {
        HttpClient client = new HttpClient(MANAGER);
        client.setConnectionTimeout(connectTimeout);
        client.setTimeout(soTimeout);
        return client;
    }

    public static void executeMethodRedirecting(HttpClient client, HttpMethod methid) throws IOException, HttpException {
        HttpClientManager.executeMethodRedirecting(client, methid, 10);
    }

    public static void executeMethodRedirecting(HttpClient client, HttpMethod methid, int redirects) throws IOException, HttpException {
        block5: for (int i = 0; i < redirects; ++i) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Attempting connection (" + i + ") to " + methid.getURI().getEscapedURI());
            }
            try {
                client.executeMethod(methid);
            }
            catch (IllegalArgumentException iae) {
                throw (IOException)new IOException().initCause(iae);
            }
            switch (methid.getStatusCode()) {
                case 301: 
                case 302: 
                case 303: 
                case 307: {
                    if (!methid.getFollowRedirects()) {
                        if (LOG.isInfoEnabled()) {
                            LOG.warn("Redirect requested but not supported");
                        }
                        throw new HttpException("Redirect requested");
                    }
                    Header locationHeader = methid.getResponseHeader("location");
                    if (locationHeader == null) {
                        if (LOG.isInfoEnabled()) {
                            LOG.warn("Redirect requested, no location header");
                        }
                        throw new HttpException("Redirected without a location");
                    }
                    String location = locationHeader.getValue();
                    if (LOG.isInfoEnabled()) {
                        LOG.info("Redirected requested to: " + location);
                    }
                    URI newLocation = new URI(location.toCharArray());
                    Header[] requestHeaders = methid.getRequestHeaders();
                    methid.recycle();
                    HostConfiguration hc = methid.getHostConfiguration();
                    hc.setHost(newLocation.getHost(), newLocation.getPort(), newLocation.getScheme());
                    methid.setFollowRedirects(true);
                    for (int j = 0; j < requestHeaders.length; ++j) {
                        if (requestHeaders[j].getName().equals("Host")) continue;
                        methid.addRequestHeader(requestHeaders[j]);
                    }
                    methid.setPath(newLocation.getEscapedPath());
                    methid.setQueryString(newLocation.getEscapedQuery());
                    methid.removeRequestHeader("Authorization");
                    continue block5;
                }
                default: {
                    return;
                }
            }
        }
        throw new HttpException("Maximum redirects encountered, bailing");
    }

    static {
        ((MultiThreadedHttpConnectionManager)MANAGER).setIdleConnectionTime(30000L);
        Protocol limeProtocol = new Protocol("http", new LimeSocketFactory(), 80);
        Protocol.registerProtocol("http", limeProtocol);
    }

    private static class LimeSocketFactory
    implements ProtocolSocketFactory {
        private LimeSocketFactory() {
        }

        public Socket createSocket(String host, int port, InetAddress clientHost, int clientPort) throws IOException, UnknownHostException {
            return Sockets.connect(host, port, 0);
        }

        public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
            return Sockets.connect(host, port, 0);
        }

        public Socket createSocket(String host, int port, int timeout) throws IOException, UnknownHostException {
            return Sockets.connect(host, port, timeout);
        }
    }
}

