/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.http;

import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import com.limegroup.gnutella.http.HTTPUtils;
import com.limegroup.gnutella.http.WriteHeadersIOState;
import com.limegroup.gnutella.statistics.Statistic;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Map;

public class SimpleWriteHeaderState
extends WriteHeadersIOState {
    private final String connectLine;
    private final Map headers;

    public SimpleWriteHeaderState(String connectLine, Map headers, Statistic stat) {
        super(stat);
        this.connectLine = connectLine;
        this.headers = headers;
    }

    protected ByteBuffer createOutgoingData() throws IOException {
        StringBuffer sb = new StringBuffer(this.connectLine.length() + this.headers.size() * 25);
        sb.append(this.connectLine).append("\r\n");
        Iterator i = this.headers.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry next = i.next();
            Object header = next.getKey();
            Object value = next.getValue();
            if (header instanceof String && value instanceof String) {
                sb.append(HTTPUtils.createHeader((String)header, (String)value));
                continue;
            }
            if (header instanceof HTTPHeaderName && value instanceof String) {
                sb.append(HTTPUtils.createHeader((HTTPHeaderName)header, (String)value));
                continue;
            }
            if (header instanceof HTTPHeaderName && value instanceof HTTPHeaderValue) {
                sb.append(HTTPUtils.createHeader((HTTPHeaderName)header, (HTTPHeaderValue)value));
                continue;
            }
            if (header instanceof String && value instanceof HTTPHeaderValue) {
                sb.append(HTTPUtils.createHeader((String)header, (HTTPHeaderValue)value));
                continue;
            }
            throw new IllegalArgumentException("bad header: " + header + ", value: " + value);
        }
        sb.append("\r\n");
        return ByteBuffer.wrap(sb.toString().getBytes());
    }

    protected void processWrittenHeaders() throws IOException {
    }
}

