/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.io;

import com.limegroup.gnutella.io.ChannelReadObserver;
import com.limegroup.gnutella.io.ChannelReader;
import com.limegroup.gnutella.io.ChannelWriter;
import com.limegroup.gnutella.io.ConnectObserver;
import com.limegroup.gnutella.io.Future;
import com.limegroup.gnutella.io.InterestReadChannel;
import com.limegroup.gnutella.io.InterestWriteChannel;
import com.limegroup.gnutella.io.InterruptedIOException;
import com.limegroup.gnutella.io.NBSocket;
import com.limegroup.gnutella.io.NIODispatcher;
import com.limegroup.gnutella.io.NIOInputStream;
import com.limegroup.gnutella.io.NIOMultiplexor;
import com.limegroup.gnutella.io.NIOOutputStream;
import com.limegroup.gnutella.io.NoOpReader;
import com.limegroup.gnutella.io.NoOpWriter;
import com.limegroup.gnutella.io.ReadObserver;
import com.limegroup.gnutella.io.ReadTimeout;
import com.limegroup.gnutella.io.ReadWriteObserver;
import com.limegroup.gnutella.io.Shutdownable;
import com.limegroup.gnutella.io.SoTimeout;
import com.limegroup.gnutella.io.ThrottleListener;
import com.limegroup.gnutella.io.WriteObserver;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractNBSocket
extends NBSocket
implements ConnectObserver,
ReadWriteObserver,
NIOMultiplexor,
ReadTimeout,
SoTimeout {
    private static final Log LOG = LogFactory.getLog(AbstractNBSocket.class);
    private final Object LOCK = new Object();
    protected ReadObserver reader;
    protected WriteObserver writer;
    protected volatile ConnectObserver connecter;
    protected volatile Shutdownable shutdownObserver;
    private boolean shutdown = false;

    protected abstract InterestReadChannel getBaseReadChannel();

    protected abstract InterestWriteChannel getBaseWriteChannel();

    protected abstract void shutdownImpl();

    public final void setInitialReader() {
        this.reader = new NIOInputStream(this, this, this.getBaseReadChannel());
    }

    public final void setInitialWriter() {
        this.writer = new NIOOutputStream(this, this.getBaseWriteChannel());
    }

    public final void setShutdownObserver(Shutdownable observer) {
        this.shutdownObserver = observer;
    }

    public final void setReadObserver(final ChannelReadObserver newReader) {
        NIODispatcher.instance().invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ReadObserver oldReader = AbstractNBSocket.this.reader;
                try {
                    Object object = AbstractNBSocket.this.LOCK;
                    synchronized (object) {
                        if (AbstractNBSocket.this.shutdown) {
                            newReader.shutdown();
                            return;
                        }
                        AbstractNBSocket.this.reader = newReader;
                    }
                    ChannelReader lastChannel = newReader;
                    while (lastChannel.getReadChannel() instanceof ChannelReader) {
                        lastChannel = (ChannelReader)((Object)lastChannel.getReadChannel());
                    }
                    if (oldReader instanceof InterestReadChannel && oldReader != newReader) {
                        if (lastChannel instanceof ThrottleListener) {
                            ((ThrottleListener)((Object)lastChannel)).setAttachment(AbstractNBSocket.this);
                        }
                        lastChannel.setReadChannel((InterestReadChannel)((Object)oldReader));
                        AbstractNBSocket.this.reader.handleRead();
                        oldReader.shutdown();
                    }
                    InterestReadChannel source = AbstractNBSocket.this.getBaseReadChannel();
                    lastChannel.setReadChannel(source);
                    NIODispatcher.instance().interestRead(AbstractNBSocket.this.getChannel(), true);
                }
                catch (IOException iox) {
                    AbstractNBSocket.this.shutdown();
                    oldReader.shutdown();
                }
            }
        });
    }

    public final void setWriteObserver(final ChannelWriter newWriter) {
        NIODispatcher.instance().invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    if (AbstractNBSocket.this.writer.handleWrite()) {
                        throw new IllegalStateException("data still in old writer!");
                    }
                    AbstractNBSocket.this.writer.shutdown();
                    ChannelWriter lastChannel = newWriter;
                    while (lastChannel.getWriteChannel() instanceof ChannelWriter) {
                        if (!((lastChannel = (ChannelWriter)((Object)lastChannel.getWriteChannel())) instanceof ThrottleListener)) continue;
                        ((ThrottleListener)((Object)lastChannel)).setAttachment(AbstractNBSocket.this);
                    }
                    InterestWriteChannel source = AbstractNBSocket.this.getBaseWriteChannel();
                    Object object = AbstractNBSocket.this.LOCK;
                    synchronized (object) {
                        lastChannel.setWriteChannel(source);
                        if (AbstractNBSocket.this.shutdown) {
                            source.shutdown();
                            return;
                        }
                        AbstractNBSocket.this.writer = source;
                    }
                }
                catch (IOException iox) {
                    AbstractNBSocket.this.shutdown();
                    newWriter.shutdown();
                }
            }
        });
    }

    public final void handleConnect(Socket s) throws IOException {
        ConnectObserver observer = this.connecter;
        this.connecter = null;
        observer.handleConnect(this);
    }

    public final void handleRead() throws IOException {
        this.reader.handleRead();
    }

    public final boolean handleWrite() throws IOException {
        return this.writer.handleWrite();
    }

    public final void close() {
        this.shutdown();
    }

    public final void connect(SocketAddress addr) throws IOException {
        this.connect(addr, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void connect(SocketAddress addr, int timeout) throws IOException {
        BlockingConnecter connecter;
        BlockingConnecter blockingConnecter = connecter = new BlockingConnecter();
        synchronized (blockingConnecter) {
            if (!this.connect(addr, timeout, connecter)) {
                long then = System.currentTimeMillis();
                try {
                    connecter.wait();
                }
                catch (InterruptedException ie) {
                    this.shutdown();
                    throw new InterruptedIOException(ie);
                }
                if (!this.isConnected()) {
                    this.shutdown();
                    long now = System.currentTimeMillis();
                    if (timeout != 0 && now - then >= (long)timeout) {
                        throw new SocketTimeoutException("operation timed out (" + timeout + ")");
                    }
                    throw new ConnectException("Unable to connect!");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean connect(SocketAddress addr, int timeout, ConnectObserver observer) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.shutdown) {
                observer.shutdown();
                return false;
            }
            this.connecter = observer;
        }
        try {
            InetSocketAddress iaddr = (InetSocketAddress)addr;
            if (iaddr.isUnresolved()) {
                throw new IOException("unresolved: " + addr);
            }
            if (this.getChannel().connect(addr)) {
                observer.handleConnect(this);
                return true;
            }
            NIODispatcher.instance().registerConnect(this.getChannel(), this, timeout);
            return false;
        }
        catch (IOException failed) {
            NIODispatcher.instance().invokeReallyLater(new Runnable(){

                public void run() {
                    AbstractNBSocket.this.shutdown();
                }
            });
            return false;
        }
    }

    public final InputStream getInputStream() throws IOException {
        if (this.isClosed() || this.isShutdown()) {
            throw new IOException("Socket closed.");
        }
        if (this.reader instanceof NIOInputStream) {
            InputStream stream = ((NIOInputStream)this.reader).getInputStream();
            NIODispatcher.instance().interestRead(this.getChannel(), true);
            return stream;
        }
        Future future = new Future(){
            private Object result;

            public void run() {
                try {
                    NIOInputStream stream = new NIOInputStream(AbstractNBSocket.this, AbstractNBSocket.this, null).init();
                    AbstractNBSocket.this.setReadObserver(stream);
                    this.result = stream.getInputStream();
                }
                catch (IOException iox) {
                    LOG.error("IOXed after creation", iox);
                }
            }

            public Object getResult() {
                return this.result;
            }
        };
        try {
            NIODispatcher.instance().invokeAndWait(future);
        }
        catch (InterruptedException ie) {
            throw (IOException)new IOException().initCause(ie);
        }
        InputStream result = (InputStream)future.getResult();
        if (result == null) {
            throw new IOException("error constructing InputStream");
        }
        return result;
    }

    public final OutputStream getOutputStream() throws IOException {
        if (this.isClosed() || this.isShutdown()) {
            throw new IOException("Socket closed.");
        }
        if (this.writer instanceof NIOOutputStream) {
            return ((NIOOutputStream)this.writer).getOutputStream();
        }
        if (this.isClosed() || this.isShutdown()) {
            throw new IOException("Socket closed.");
        }
        throw new IllegalStateException("writer not NIOOutputStream, it's a: " + this.writer);
    }

    public final long getReadTimeout() {
        if (this.reader instanceof NIOInputStream) {
            return 0L;
        }
        try {
            return this.getSoTimeout();
        }
        catch (SocketException se) {
            return 0L;
        }
    }

    public final void handleIOException(IOException iox) {
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void shutdown() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.shutdown) {
                return;
            }
            this.shutdown = true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Shutting down socket & streams for: " + this);
        }
        this.shutdownImpl();
        try {
            this.getChannel().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.reader.shutdown();
        this.writer.shutdown();
        if (this.connecter != null) {
            this.connecter.shutdown();
        }
        if (this.shutdownObserver != null) {
            this.shutdownObserver.shutdown();
        }
        NIODispatcher.instance().invokeLater(new Runnable(){

            public void run() {
                AbstractNBSocket.this.reader = new NoOpReader();
                AbstractNBSocket.this.writer = new NoOpWriter();
                AbstractNBSocket.this.connecter = null;
                AbstractNBSocket.this.shutdownObserver = null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isShutdown() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.shutdown;
        }
    }

    private static class BlockingConnecter
    implements ConnectObserver {
        BlockingConnecter() {
        }

        public synchronized void handleConnect(Socket s) {
            this.notify();
        }

        public synchronized void shutdown() {
            this.notify();
        }

        public void handleIOException(IOException iox) {
        }
    }
}

