/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.io;

import com.limegroup.gnutella.io.AcceptObserver;
import com.limegroup.gnutella.util.ThreadFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.ServerSocketChannel;

public class BlockingServerSocketAdapter
extends ServerSocket {
    private final AcceptObserver observer;
    private final ServerSocket delegate = new ServerSocket();

    public BlockingServerSocketAdapter() throws IOException {
        this((AcceptObserver)null);
    }

    public BlockingServerSocketAdapter(AcceptObserver observer) throws IOException {
        this.observer = observer;
    }

    public BlockingServerSocketAdapter(int port) throws IOException {
        this(port, null);
    }

    public BlockingServerSocketAdapter(int port, AcceptObserver observer) throws IOException {
        this(observer);
        this.bind(new InetSocketAddress(port));
    }

    public BlockingServerSocketAdapter(int port, int backlog) throws IOException {
        this(port, backlog, (AcceptObserver)null);
    }

    public BlockingServerSocketAdapter(int port, int backlog, AcceptObserver observer) throws IOException {
        this(observer);
        this.bind(new InetSocketAddress(port), backlog);
    }

    public BlockingServerSocketAdapter(int port, int backlog, InetAddress bindAddr) throws IOException {
        this(port, backlog, bindAddr, null);
    }

    public BlockingServerSocketAdapter(int port, int backlog, InetAddress bindAddr, AcceptObserver observer) throws IOException {
        this(observer);
        this.bind(new InetSocketAddress(bindAddr, port), backlog);
    }

    public void bind(SocketAddress endpoint, int backlog) throws IOException {
        this.delegate.bind(endpoint, backlog);
        this.startListening();
    }

    public void bind(SocketAddress endpoint) throws IOException {
        this.delegate.bind(endpoint);
        this.startListening();
    }

    public Socket accept() throws IOException {
        if (this.observer != null) {
            throw new IllegalBlockingModeException();
        }
        return this.delegate.accept();
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public ServerSocketChannel getChannel() {
        return this.delegate.getChannel();
    }

    public InetAddress getInetAddress() {
        return this.delegate.getInetAddress();
    }

    public int getLocalPort() {
        return this.delegate.getLocalPort();
    }

    public SocketAddress getLocalSocketAddress() {
        return this.delegate.getLocalSocketAddress();
    }

    public int getReceiveBufferSize() throws SocketException {
        return this.delegate.getReceiveBufferSize();
    }

    public boolean getReuseAddress() throws SocketException {
        return this.delegate.getReuseAddress();
    }

    public int getSoTimeout() throws IOException {
        return this.delegate.getSoTimeout();
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public boolean isBound() {
        return this.delegate.isBound();
    }

    public boolean isClosed() {
        return this.delegate.isClosed();
    }

    public void setReceiveBufferSize(int size) throws SocketException {
        this.delegate.setReceiveBufferSize(size);
    }

    public void setReuseAddress(boolean on) throws SocketException {
        this.delegate.setReuseAddress(on);
    }

    public void setSoTimeout(int timeout) throws SocketException {
        this.delegate.setSoTimeout(timeout);
    }

    public String toString() {
        return this.delegate.toString();
    }

    private void startListening() {
        if (this.observer != null) {
            ThreadFactory.startThread(new Runnable(){

                public void run() {
                    while (!BlockingServerSocketAdapter.this.isClosed()) {
                        try {
                            Socket s = BlockingServerSocketAdapter.this.delegate.accept();
                            BlockingServerSocketAdapter.this.observer.handleAccept(s);
                        }
                        catch (IOException iOException) {}
                    }
                    BlockingServerSocketAdapter.this.observer.shutdown();
                }
            }, "BlockingServerSocketEmulator");
        }
    }
}

