/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.io;

import com.limegroup.gnutella.io.InterestReadChannel;
import com.limegroup.gnutella.io.InterruptedIOException;
import com.limegroup.gnutella.io.ReadTimeout;
import com.limegroup.gnutella.io.Shutdownable;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class BufferInputStream
extends InputStream
implements Shutdownable {
    private static final Log LOG = LogFactory.getLog(BufferInputStream.class);
    private final Object LOCK = new Object();
    private final Shutdownable shutdownHandler;
    private final ReadTimeout readTimeoutHandler;
    private final ByteBuffer buffer;
    private InterestReadChannel channel;
    private boolean shutdown = false;
    private boolean finished = false;

    BufferInputStream(ByteBuffer buffer, ReadTimeout timeout, Shutdownable shutdown, InterestReadChannel channel) {
        this.readTimeoutHandler = timeout;
        this.shutdownHandler = shutdown;
        this.buffer = buffer;
        this.channel = channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setReadChannel(InterestReadChannel newChannel) {
        Object object = this.LOCK;
        synchronized (object) {
            this.channel = newChannel;
        }
    }

    Object getBufferLock() {
        return this.LOCK;
    }

    void finished() {
        this.finished = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        Object object = this.LOCK;
        synchronized (object) {
            this.waitImpl();
            if (this.finished && this.buffer.position() == 0) {
                return -1;
            }
            this.buffer.flip();
            byte read = this.buffer.get();
            this.buffer.compact();
            this.channel.interest(true);
            return read & 0xFF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] buf, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        Object object = this.LOCK;
        synchronized (object) {
            this.waitImpl();
            if (this.finished && this.buffer.position() == 0) {
                return -1;
            }
            this.buffer.flip();
            int available = Math.min(this.buffer.remaining(), len);
            this.buffer.get(buf, off, available);
            if (this.buffer.hasRemaining()) {
                this.buffer.compact();
            } else {
                this.buffer.clear();
            }
            this.channel.interest(true);
            return available;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int available() throws IOException {
        Object object = this.LOCK;
        synchronized (object) {
            return this.buffer.position();
        }
    }

    private void waitImpl() throws IOException {
        long timeout = this.readTimeoutHandler.getReadTimeout();
        if (timeout == -1L) {
            throw new SocketException("unable to get read timeout");
        }
        boolean looped = false;
        while (this.buffer.position() == 0 && !this.finished) {
            if (this.shutdown) {
                throw new IOException("socket closed");
            }
            if (looped && timeout != 0L) {
                throw new java.io.InterruptedIOException("read timed out (" + timeout + ")");
            }
            try {
                this.LOCK.wait(timeout);
            }
            catch (InterruptedException ix) {
                throw new InterruptedIOException(ix);
            }
            looped = true;
        }
        if (this.shutdown) {
            throw new IOException("socket closed");
        }
    }

    public void close() throws IOException {
        this.shutdownHandler.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.LOCK;
        synchronized (object) {
            this.shutdown = true;
            this.LOCK.notify();
        }
    }
}

