/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.io;

import com.limegroup.gnutella.io.ChannelWriter;
import com.limegroup.gnutella.io.InterestWriteChannel;
import com.limegroup.gnutella.io.WriteObserver;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DelayedBufferWriter
implements ChannelWriter,
InterestWriteChannel {
    private static final Log LOG = LogFactory.getLog(DelayedBufferWriter.class);
    private static final int MAX_TIME = 200;
    private volatile InterestWriteChannel sink;
    private volatile WriteObserver observer;
    private final ByteBuffer buf;
    private long lastFlushTime;

    public DelayedBufferWriter(int size) {
        this.buf = ByteBuffer.allocate(size);
    }

    public synchronized void interest(WriteObserver observer, boolean status) {
        this.observer = status ? observer : null;
        InterestWriteChannel source = this.sink;
        if (source != null) {
            source.interest(this, true);
        }
    }

    public void close() throws IOException {
        InterestWriteChannel chan = this.sink;
        if (chan != null) {
            chan.close();
        }
    }

    public boolean isOpen() {
        InterestWriteChannel chan = this.sink;
        return chan != null ? chan.isOpen() : false;
    }

    public InterestWriteChannel getWriteChannel() {
        return this.sink;
    }

    public void setWriteChannel(InterestWriteChannel newChannel) {
        this.sink = newChannel;
        newChannel.interest(this, true);
    }

    public void handleIOException(IOException iox) {
        throw new RuntimeException("Unsupported", iox);
    }

    public void shutdown() {
        WriteObserver listener = this.observer;
        if (listener != null) {
            listener.shutdown();
        }
    }

    public int write(ByteBuffer buffer) throws IOException {
        int originalPos = buffer.position();
        while (buffer.hasRemaining()) {
            if (this.buf.hasRemaining()) {
                int adding;
                int remaining = this.buf.remaining();
                if (remaining >= (adding = buffer.remaining())) {
                    this.buf.put(buffer);
                    continue;
                }
                int oldLimit = buffer.limit();
                int position = buffer.position();
                buffer.limit(position + remaining);
                this.buf.put(buffer);
                buffer.limit(oldLimit);
                continue;
            }
            this.flush(System.currentTimeMillis());
            if (this.buf.hasRemaining()) continue;
            break;
        }
        return buffer.position() - originalPos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleWrite() throws IOException {
        WriteObserver upper = this.observer;
        if (upper != null) {
            upper.handleWrite();
        }
        long now = System.currentTimeMillis();
        if (this.lastFlushTime == 0L) {
            this.lastFlushTime = now;
        }
        if (now - this.lastFlushTime > 200L || upper == null) {
            this.flush(now);
        }
        if (this.buf.position() == 0) {
            DelayedBufferWriter delayedBufferWriter = this;
            synchronized (delayedBufferWriter) {
                upper = this.observer;
                if (upper == null) {
                    this.sink.interest(this, false);
                }
            }
            return false;
        }
        return true;
    }

    private void flush(long now) throws IOException {
        this.buf.flip();
        InterestWriteChannel chan = this.sink;
        chan.write(this.buf);
        if (this.buf.position() > 0) {
            this.lastFlushTime = now;
            if (this.buf.hasRemaining()) {
                this.buf.compact();
            } else {
                this.buf.clear();
            }
        } else {
            this.buf.position(this.buf.limit()).limit(this.buf.capacity());
        }
    }
}

