/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.io;

import com.limegroup.gnutella.io.BufferUtils;
import com.limegroup.gnutella.io.ChannelReadObserver;
import com.limegroup.gnutella.io.ChannelWriter;
import com.limegroup.gnutella.io.IOState;
import com.limegroup.gnutella.io.IOStateObserver;
import com.limegroup.gnutella.io.InterestReadChannel;
import com.limegroup.gnutella.io.InterestWriteChannel;
import com.limegroup.gnutella.io.NIODispatcher;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IOStateMachine
implements ChannelReadObserver,
ChannelWriter,
InterestReadChannel {
    private static final Log LOG = LogFactory.getLog(IOStateMachine.class);
    private IOStateObserver observer;
    private List states;
    private IOState currentState;
    private InterestWriteChannel writeSink;
    private InterestReadChannel readSink;
    private ByteBuffer readBuffer;
    private volatile boolean shutdown;

    public IOStateMachine(IOStateObserver observer, List states) {
        this(observer, states, 2048);
    }

    public IOStateMachine(IOStateObserver observer, List states, int bufferSize) {
        this.observer = observer;
        this.states = states;
        this.readBuffer = NIODispatcher.instance().getBufferCache().getHeap(bufferSize);
        if (!states.isEmpty()) {
            this.currentState = (IOState)states.remove(0);
        }
    }

    public void addState(final IOState newState) {
        NIODispatcher.instance().invokeLater(new Runnable(){

            public void run() {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Adding single state: " + newState);
                }
                IOStateMachine.this.states.add(newState);
                if (IOStateMachine.this.states.size() == 1) {
                    IOStateMachine.this.nextState(false, false);
                }
            }
        });
    }

    public void addStates(final List newStates) {
        NIODispatcher.instance().invokeLater(new Runnable(){

            public void run() {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Adding multiple states: " + newStates);
                }
                IOStateMachine.this.states.addAll(newStates);
                if (IOStateMachine.this.states.size() == newStates.size()) {
                    IOStateMachine.this.nextState(false, false);
                }
            }
        });
    }

    public void addStates(final IOState[] newStates) {
        NIODispatcher.instance().invokeLater(new Runnable(){

            public void run() {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Adding multiple states...");
                }
                for (int i = 0; i < newStates.length; ++i) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(" state[" + i + "]: " + newStates[i]);
                    }
                    IOStateMachine.this.states.add(newStates[i]);
                }
                if (IOStateMachine.this.states.size() == newStates.length) {
                    IOStateMachine.this.nextState(false, false);
                }
            }
        });
    }

    public void handleRead() {
        if (this.currentState != null) {
            if (this.currentState.isWriting()) {
                LOG.warn("Got a read notification while writing.");
                this.processCurrentState(null, true);
                this.readSink.interest(false);
            } else {
                this.processCurrentState(this.currentState, true);
            }
        } else {
            LOG.warn("Got a read notification with no current state");
            this.processCurrentState(null, true);
            this.readSink.interest(false);
        }
    }

    public boolean handleWrite() {
        if (this.currentState != null) {
            if (this.currentState.isReading()) {
                LOG.warn("Got a write notification while reading");
                this.writeSink.interest(this, false);
                return false;
            }
            return this.processCurrentState(this.currentState, false);
        }
        LOG.warn("Got a write notification with no current state");
        this.writeSink.interest(this, false);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processCurrentState(IOState state, boolean reading) {
        block18: {
            if (!this.shutdown) {
                try {
                    if (reading) {
                        if (state == null) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Processing a read with no state");
                            }
                            while (this.readBuffer.hasRemaining() && this.readSink.read(this.readBuffer) > 0) {
                            }
                        } else if (!state.process(this.readSink, this.readBuffer)) {
                            this.nextState(true, false);
                        }
                        break block18;
                    }
                    if (!state.process(this.writeSink, null)) {
                        this.nextState(false, true);
                        break block18;
                    }
                    return true;
                }
                catch (IOException iox) {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn("IOX while processing state: " + state, iox);
                    }
                    IOStateMachine iOStateMachine = this;
                    synchronized (iOStateMachine) {
                        this.shutdown = true;
                    }
                    try {
                        this.close();
                    }
                    catch (IOException ignored) {
                        // empty catch block
                    }
                    NIODispatcher.instance().getBufferCache().release(this.readBuffer);
                    this.observer.handleIOException(iox);
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Ignoring processing because machine is shutdown");
            }
        }
        return false;
    }

    private void nextState(boolean reading, boolean writing) {
        if (this.states.isEmpty()) {
            LOG.debug("No more states, processing finished.");
            this.readSink.interest(false);
            this.writeSink.interest(this, false);
            this.observer.handleStatesFinished();
        } else {
            this.currentState = (IOState)this.states.remove(0);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Incrementing state to: " + this.currentState);
            }
            if (this.currentState.isReading() && !reading) {
                this.writeSink.interest(this, false);
                if (this.readSink != null) {
                    this.readSink.interest(true);
                }
            }
            if (this.currentState.isWriting() && !writing) {
                this.readSink.interest(false);
                if (this.writeSink != null) {
                    this.writeSink.interest(this, true);
                }
            }
            if (this.currentState.isReading()) {
                this.processCurrentState(this.currentState, true);
            }
        }
    }

    public InterestWriteChannel getWriteChannel() {
        return this.writeSink;
    }

    public void setWriteChannel(InterestWriteChannel newChannel) {
        this.writeSink = newChannel;
        if (this.currentState != null) {
            this.writeSink.interest(this, true);
        }
    }

    public InterestReadChannel getReadChannel() {
        return this.readSink;
    }

    public void setReadChannel(InterestReadChannel newChannel) {
        this.readSink = newChannel;
        if (this.currentState != null) {
            this.readSink.interest(true);
        }
    }

    public boolean isOpen() {
        return this.readSink.isOpen() && this.writeSink.isOpen();
    }

    public void close() throws IOException {
        this.readSink.close();
        this.writeSink.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        IOStateMachine iOStateMachine = this;
        synchronized (iOStateMachine) {
            if (this.shutdown) {
                return;
            }
            this.shutdown = true;
        }
        if (!this.isOpen()) {
            this.observer.shutdown();
        }
        NIODispatcher.instance().invokeLater(new Runnable(){

            public void run() {
                NIODispatcher.instance().getBufferCache().release(IOStateMachine.this.readBuffer);
            }
        });
    }

    public void interest(boolean status) {
        if (this.currentState != null) {
            this.readSink.interest(status);
        }
    }

    public int read(ByteBuffer toBuffer) throws ClosedChannelException {
        if (this.shutdown) {
            throw new ClosedChannelException();
        }
        return BufferUtils.transfer(this.readBuffer, toBuffer);
    }

    public void handleIOException(IOException iox) {
    }
}

