/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.io;

import com.limegroup.gnutella.io.IOErrorObserver;
import com.limegroup.gnutella.io.NIODispatcher;
import com.limegroup.gnutella.io.Throttle;
import com.limegroup.gnutella.io.ThrottleListener;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NBThrottle
implements Throttle {
    private static final Log LOG = LogFactory.getLog(NBThrottle.class);
    private static final int DEFAULT_TICK_TIME = 100;
    private final int MILLIS_PER_TICK;
    private final int MAXIMUM_TO_GIVE;
    private final int MINIMUM_TO_GIVE;
    private final boolean _write;
    private final int _processOp;
    private int _bytesPerTick;
    private int _available;
    private long _nextTickTime = -1L;
    private Set _requests = new HashSet();
    private Map _interested = new LinkedHashMap();
    private Map _ready = new HashMap();
    private boolean _active = false;

    public NBThrottle(boolean forWriting, float bytesPerSecond) {
        this(forWriting, bytesPerSecond, true, 100);
    }

    public NBThrottle(boolean forWriting, float bytesPerSecond, int maxRequestors, int maxLatency) {
        this(forWriting, bytesPerSecond, true, maxRequestors == 0 ? 100 : maxLatency / maxRequestors);
    }

    protected NBThrottle(boolean forWriting, float bytesPerSecond, boolean addToDispatcher, int millisPerTick) {
        this.MILLIS_PER_TICK = Math.min(100, Math.max(50, millisPerTick));
        int ticksPerSecond = 1000 / this.MILLIS_PER_TICK;
        this._write = forWriting;
        this._processOp = forWriting ? 4 : 1;
        this._bytesPerTick = (int)(bytesPerSecond / (float)ticksPerSecond);
        if (addToDispatcher) {
            NIODispatcher.instance().addThrottle(this);
        }
        if (forWriting) {
            this.MAXIMUM_TO_GIVE = 1400;
            this.MINIMUM_TO_GIVE = 30;
        } else {
            this.MAXIMUM_TO_GIVE = Integer.MAX_VALUE;
            this.MINIMUM_TO_GIVE = 0;
        }
    }

    public void setRate(float bytesPerSecond) {
        int ticksPerSecond = 1000 / this.MILLIS_PER_TICK;
        this._bytesPerTick = (int)(bytesPerSecond / (float)ticksPerSecond);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void selectableKeys(Collection keys) {
        if (this._available >= this.MINIMUM_TO_GIVE && !this._interested.isEmpty()) {
            Iterator i = keys.iterator();
            while (i.hasNext()) {
                SelectionKey key = (SelectionKey)i.next();
                try {
                    IOErrorObserver attachment;
                    if (!key.isValid() || !(this._write ? key.isWritable() : key.isReadable()) || !this._interested.containsKey(attachment = NIODispatcher.instance().attachment(key.attachment()))) continue;
                    this._ready.put(attachment, key);
                }
                catch (CancelledKeyException ignored) {
                    i.remove();
                }
            }
            this._active = true;
            long now = System.currentTimeMillis();
            Iterator i2 = this._interested.entrySet().iterator();
            while (!this._ready.isEmpty() && i2.hasNext()) {
                Map.Entry next = i2.next();
                ThrottleListener listener = (ThrottleListener)next.getValue();
                Object attachment = next.getKey();
                SelectionKey key = (SelectionKey)this._ready.remove(attachment);
                if (!listener.isOpen()) {
                    i2.remove();
                    continue;
                }
                if (key == null) continue;
                listener.requestBandwidth();
                try {
                    NIODispatcher.instance().process(now, key, key.attachment(), this._processOp);
                }
                finally {
                    listener.releaseBandwidth();
                }
                i2.remove();
                if (this._available >= this.MINIMUM_TO_GIVE) continue;
                break;
            }
            this._active = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interest(ThrottleListener writer) {
        Set set = this._requests;
        synchronized (set) {
            this._requests.add(writer);
        }
    }

    public int request() {
        if (!this._active) {
            return 0;
        }
        int ret = Math.min(this._available, this.MAXIMUM_TO_GIVE);
        this._available -= ret;
        return ret;
    }

    public void release(int amount) {
        if (this._active) {
            this._available += amount;
        }
    }

    void tick(long currentTime) {
        if (currentTime >= this._nextTickTime) {
            this._available = this._bytesPerTick;
            this._nextTickTime = currentTime + (long)this.MILLIS_PER_TICK;
            this.spreadBandwidth();
        } else if (this._available > this.MINIMUM_TO_GIVE) {
            this.spreadBandwidth();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void spreadBandwidth() {
        Set set = this._requests;
        synchronized (set) {
            if (!this._requests.isEmpty()) {
                Iterator i = this._requests.iterator();
                while (i.hasNext()) {
                    ThrottleListener req = (ThrottleListener)i.next();
                    Object attachment = req.getAttachment();
                    if (attachment == null) {
                        throw new IllegalStateException("must have an attachment");
                    }
                    if (this._interested.containsKey(attachment) || !req.bandwidthAvailable()) continue;
                    this._interested.put(attachment, req);
                }
                this._requests.clear();
            }
        }
    }
}

