/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.io;

import com.limegroup.gnutella.io.BufferInputStream;
import com.limegroup.gnutella.io.BufferUtils;
import com.limegroup.gnutella.io.ChannelReadObserver;
import com.limegroup.gnutella.io.InterestReadChannel;
import com.limegroup.gnutella.io.NIODispatcher;
import com.limegroup.gnutella.io.ReadTimeout;
import com.limegroup.gnutella.io.Shutdownable;
import com.limegroup.gnutella.io.SoTimeout;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.nio.ByteBuffer;

class NIOInputStream
implements ChannelReadObserver,
InterestReadChannel,
ReadTimeout {
    private final Shutdownable shutdownHandler;
    private final SoTimeout soTimeoutHandler;
    private InterestReadChannel channel;
    private BufferInputStream source;
    private volatile Object bufferLock;
    private ByteBuffer buffer;
    private boolean shutdown;

    NIOInputStream(SoTimeout soTimeouter, Shutdownable shutdowner, InterestReadChannel channel) {
        this.soTimeoutHandler = soTimeouter;
        this.shutdownHandler = shutdowner;
        this.channel = channel;
    }

    synchronized NIOInputStream init() throws IOException {
        if (this.buffer != null) {
            throw new IllegalStateException("already init'd!");
        }
        if (this.shutdown) {
            throw new IOException("Already closed!");
        }
        this.buffer = NIODispatcher.instance().getBufferCache().getHeap();
        this.source = new BufferInputStream(this.buffer, this, this.shutdownHandler, this.channel);
        this.bufferLock = this.source.getBufferLock();
        return this;
    }

    public int read(ByteBuffer toBuffer) {
        return BufferUtils.transfer(this.buffer, toBuffer);
    }

    synchronized InputStream getInputStream() throws IOException {
        if (this.buffer == null) {
            this.init();
        }
        return this.source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRead() throws IOException {
        Object object = this.bufferLock;
        synchronized (object) {
            int read = 0;
            while (this.buffer.hasRemaining() && (read = this.channel.read(this.buffer)) > 0) {
            }
            if (read == -1) {
                this.source.finished();
            }
            if (this.buffer.position() > 0 || read == -1) {
                this.bufferLock.notify();
            }
            if (!this.buffer.hasRemaining() || read == -1) {
                this.channel.interest(false);
            }
        }
    }

    public synchronized void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        if (this.source != null) {
            this.source.shutdown();
        }
        if (this.buffer != null) {
            NIODispatcher.instance().invokeLater(new Runnable(){

                public void run() {
                    NIODispatcher.instance().getBufferCache().release(NIOInputStream.this.buffer);
                }
            });
        }
    }

    public void handleIOException(IOException iox) {
        throw new RuntimeException("unsupported operation", iox);
    }

    public void close() throws IOException {
    }

    public boolean isOpen() {
        return true;
    }

    public void interest(boolean status) {
    }

    public InterestReadChannel getReadChannel() {
        return this.channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReadChannel(InterestReadChannel newChannel) {
        Object object = this.bufferLock;
        synchronized (object) {
            this.channel = newChannel;
            this.source.setReadChannel(newChannel);
        }
    }

    public long getReadTimeout() {
        try {
            return this.soTimeoutHandler.getSoTimeout();
        }
        catch (SocketException se) {
            return -1L;
        }
    }
}

