/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.io;

import com.limegroup.gnutella.io.BufferUtils;
import com.limegroup.gnutella.io.ReadState;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

public class ReadSkipState
extends ReadState {
    private long leftToRead;

    public ReadSkipState(long length) {
        this.leftToRead = length;
    }

    protected boolean processRead(ReadableByteChannel rc, ByteBuffer buffer) throws IOException {
        this.leftToRead = BufferUtils.delete(buffer, this.leftToRead);
        int read = 0;
        while (this.leftToRead > 0L && (read = rc.read(buffer)) > 0) {
            this.leftToRead = BufferUtils.delete(buffer, this.leftToRead);
        }
        if (this.leftToRead > 0L && read == -1) {
            throw new IOException("EOF");
        }
        return this.leftToRead > 0L;
    }

    public long getAmountProcessed() {
        return -1L;
    }
}

