/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.io;

import com.limegroup.gnutella.io.InterestWriteChannel;
import com.limegroup.gnutella.io.NIODispatcher;
import com.limegroup.gnutella.io.WriteObserver;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

class SocketInterestWriteAdapter
implements InterestWriteChannel {
    private volatile WriteObserver interested;
    private SocketChannel channel;
    private boolean shutdown = false;

    SocketInterestWriteAdapter(SocketChannel channel) {
        this.channel = channel;
    }

    public int write(ByteBuffer buffer) throws IOException {
        return this.channel.write(buffer);
    }

    public void close() throws IOException {
        this.channel.close();
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public synchronized void interest(WriteObserver observer, boolean on) {
        if (!this.shutdown) {
            this.interested = on ? observer : null;
            NIODispatcher.instance().interestWrite(this.channel, on);
        }
    }

    public boolean handleWrite() throws IOException {
        WriteObserver chain = this.interested;
        if (chain != null) {
            return chain.handleWrite();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        SocketInterestWriteAdapter socketInterestWriteAdapter = this;
        synchronized (socketInterestWriteAdapter) {
            if (this.shutdown) {
                return;
            }
            this.shutdown = true;
        }
        WriteObserver chain = this.interested;
        if (chain != null) {
            chain.shutdown();
        }
        this.interested = null;
    }

    public void handleIOException(IOException x) {
        throw new RuntimeException("unsupported", x);
    }
}

