/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.io;

import com.limegroup.gnutella.io.ChannelReader;
import com.limegroup.gnutella.io.InterestReadChannel;
import com.limegroup.gnutella.io.Throttle;
import com.limegroup.gnutella.io.ThrottleListener;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ThrottleReader
implements InterestReadChannel,
ChannelReader,
ThrottleListener {
    private static final Log LOG = LogFactory.getLog(ThrottleReader.class);
    private volatile InterestReadChannel channel;
    private final Throttle throttle;
    private int available;
    private Object attachment;
    private volatile boolean lastInterestState;

    public ThrottleReader(Throttle throttle) {
        this(throttle, null);
    }

    public ThrottleReader(Throttle throttle, InterestReadChannel channel) {
        this.throttle = throttle;
        this.channel = channel;
    }

    public InterestReadChannel getReadChannel() {
        return this.channel;
    }

    public void setReadChannel(InterestReadChannel channel) {
        this.channel = channel;
        this.throttle.interest(this);
    }

    public void setAttachment(Object att) {
        this.attachment = att;
    }

    public Object getAttachment() {
        return this.attachment;
    }

    public void interest(boolean status) {
        this.lastInterestState = status;
        if (this.channel != null) {
            if (status) {
                this.throttle.interest(this);
            } else {
                this.channel.interest(false);
            }
        }
    }

    public boolean bandwidthAvailable() {
        if (this.channel.isOpen() && this.lastInterestState) {
            this.channel.interest(true);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(ByteBuffer buffer) throws IOException {
        InterestReadChannel chain = this.channel;
        if (chain == null) {
            throw new IllegalStateException("reading with no chain!");
        }
        if (this.available == 0) {
            return 0;
        }
        int priorLimit = buffer.limit();
        if (buffer.remaining() > this.available) {
            buffer.limit(buffer.position() + this.available);
        }
        int totalRead = -1;
        try {
            totalRead = this.channel.read(buffer);
        }
        finally {
            buffer.limit(priorLimit);
        }
        this.available -= totalRead;
        return totalRead;
    }

    public void close() throws IOException {
        InterestReadChannel source = this.channel;
        if (source != null) {
            source.close();
        }
    }

    public boolean isOpen() {
        InterestReadChannel source = this.channel;
        return source != null ? source.isOpen() : false;
    }

    public void requestBandwidth() {
        this.available = this.throttle.request();
        this.channel.interest(false);
    }

    public void releaseBandwidth() {
        this.throttle.release(this.available);
        this.available = 0;
        if (this.lastInterestState) {
            this.throttle.interest(this);
        }
    }
}

