/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.io;

import com.limegroup.gnutella.io.ChannelWriter;
import com.limegroup.gnutella.io.InterestWriteChannel;
import com.limegroup.gnutella.io.Throttle;
import com.limegroup.gnutella.io.ThrottleListener;
import com.limegroup.gnutella.io.WriteObserver;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ThrottleWriter
implements ChannelWriter,
InterestWriteChannel,
ThrottleListener {
    private static final Log LOG = LogFactory.getLog(ThrottleWriter.class);
    private volatile InterestWriteChannel channel;
    private volatile WriteObserver observer;
    private final Throttle throttle;
    private int available;
    private Object attachment;

    public ThrottleWriter(Throttle throttle) {
        this(throttle, null);
    }

    public ThrottleWriter(Throttle throttle, InterestWriteChannel channel) {
        this.throttle = throttle;
        this.channel = channel;
    }

    public InterestWriteChannel getWriteChannel() {
        return this.channel;
    }

    public void setWriteChannel(InterestWriteChannel channel) {
        this.channel = channel;
        this.throttle.interest(this);
    }

    public void setAttachment(Object att) {
        this.attachment = att;
    }

    public Object getAttachment() {
        return this.attachment;
    }

    public void interest(WriteObserver observer, boolean status) {
        if (status) {
            this.observer = observer;
            if (this.channel != null) {
                this.throttle.interest(this);
            }
        } else {
            this.observer = null;
        }
    }

    public boolean bandwidthAvailable() {
        if (this.channel.isOpen()) {
            this.channel.interest(this, true);
            return true;
        }
        return false;
    }

    public int write(ByteBuffer buffer) throws IOException {
        InterestWriteChannel chain = this.channel;
        if (chain == null) {
            throw new IllegalStateException("writing with no chain!");
        }
        if (this.available == 0) {
            return 0;
        }
        int priorLimit = buffer.limit();
        if (buffer.remaining() > this.available) {
            buffer.limit(buffer.position() + this.available);
        }
        int totalWrote = this.channel.write(buffer);
        this.available -= totalWrote;
        buffer.limit(priorLimit);
        return totalWrote;
    }

    public void close() throws IOException {
        InterestWriteChannel source = this.channel;
        if (source != null) {
            source.close();
        }
    }

    public boolean isOpen() {
        InterestWriteChannel source = this.channel;
        return source != null ? source.isOpen() : false;
    }

    public void requestBandwidth() {
        this.available = this.throttle.request();
    }

    public void releaseBandwidth() {
        this.throttle.release(this.available);
        this.available = 0;
    }

    public boolean handleWrite() throws IOException {
        InterestWriteChannel chain = this.channel;
        if (chain == null) {
            throw new IllegalStateException("writing with no source.");
        }
        WriteObserver interested = this.observer;
        if (this.available != 0) {
            chain.interest(this, false);
            if (interested != null) {
                interested.handleWrite();
            }
            if ((interested = this.observer) != null) {
                this.throttle.interest(this);
                return true;
            }
            return false;
        }
        return true;
    }

    public void shutdown() {
        WriteObserver listener = this.observer;
        if (listener != null) {
            listener.shutdown();
        }
    }

    public void handleIOException(IOException x) {
        throw new RuntimeException("Unsupported", x);
    }
}

