/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.library;

import com.limegroup.gnutella.library.Container;
import com.limegroup.gnutella.settings.Settings;
import com.limegroup.gnutella.settings.SettingsHandler;
import com.limegroup.gnutella.settings.SharingSettings;
import java.io.File;
import java.util.Iterator;
import java.util.Set;

public class LibraryData
implements Settings {
    private final Container DATA = new Container("library.dat");
    public final Set DIRECTORIES_NOT_TO_SHARE = this.DATA.getSet("DIRECTORIES_NOT_TO_SHARE");
    public final Set SENSITIVE_DIRECTORIES_VALIDATED = this.DATA.getSet("SENSITIVE_DIRECTORIES_VALIDATED");
    public final Set SENSITIVE_DIRECTORIES_NOT_TO_SHARE = this.DATA.getSet("SENSITIVE_DIRECTORIES_NOT_TO_SHARE");
    public final Set SPECIAL_FILES_TO_SHARE = this.DATA.getSet("SPECIAL_FILES_TO_SHARE");
    public final Set FILES_NOT_TO_SHARE = this.DATA.getSet("FILES_NOT_TO_SHARE");
    private boolean shouldSave = true;

    public LibraryData() {
        SettingsHandler.addSettings(this);
    }

    public void save() {
        if (this.shouldSave) {
            this.DATA.save();
        }
    }

    public void revertToDefault() {
        this.DATA.clear();
    }

    public void setShouldSave(boolean save) {
        this.shouldSave = save;
    }

    public void reload() {
        this.DATA.load();
    }

    public final void clean() {
        SharingSettings.DIRECTORIES_TO_SHARE.clean();
        Set parents = SharingSettings.DIRECTORIES_TO_SHARE.getValue();
        this.clean(this.DIRECTORIES_NOT_TO_SHARE, parents);
        this.clean(this.FILES_NOT_TO_SHARE, parents);
        this.clean(this.SENSITIVE_DIRECTORIES_VALIDATED, parents);
        this.clean(this.SENSITIVE_DIRECTORIES_NOT_TO_SHARE, parents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clean(Set one, Set two) {
        Set set = one;
        synchronized (set) {
            Iterator i = one.iterator();
            while (i.hasNext()) {
                Object o = i.next();
                if (!(o instanceof File)) {
                    i.remove();
                    continue;
                }
                File f = (File)o;
                if (!f.exists()) {
                    i.remove();
                    continue;
                }
                if (two == null || this.containsParent(f, two)) continue;
                i.remove();
            }
        }
    }

    private boolean containsParent(File parent, Set set) {
        while (parent != null) {
            if (set.contains(parent)) {
                return true;
            }
            parent = parent.getParentFile();
        }
        return false;
    }
}

