/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.licenses;

import com.limegroup.gnutella.http.HttpClientManager;
import com.limegroup.gnutella.licenses.LicenseCache;
import com.limegroup.gnutella.licenses.NamedLicense;
import com.limegroup.gnutella.licenses.VerificationListener;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.ProcessingQueue;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.StringReader;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

abstract class AbstractLicense
implements NamedLicense,
Serializable,
Cloneable {
    private static final Log LOG = LogFactory.getLog(AbstractLicense.class);
    private static final ProcessingQueue VQUEUE = new ProcessingQueue("LicenseVerifier");
    private static final long serialVersionUID = 6508972367931096578L;
    protected transient int verified = 0;
    protected transient URI licenseLocation;
    private transient String licenseName;
    private long lastVerifiedTime;

    AbstractLicense(URI uri) {
        this.licenseLocation = uri;
    }

    public void setLicenseName(String name) {
        this.licenseName = name;
    }

    public boolean isVerifying() {
        return this.verified == 1;
    }

    public boolean isVerified() {
        return this.verified == 2;
    }

    public String getLicenseName() {
        return this.licenseName;
    }

    public URI getLicenseURI() {
        return this.licenseLocation;
    }

    public long getLastVerifiedTime() {
        return this.lastVerifiedTime;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.verified = 2;
    }

    protected abstract void clear();

    public void verify(VerificationListener listener) {
        this.verified = 1;
        this.clear();
        VQUEUE.add(new Verifier(listener));
    }

    protected String getBody(String url) {
        return this.getBodyFromURL(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getBodyFromURL(String url) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Contacting: " + url);
        }
        HttpClient client = HttpClientManager.getNewClient();
        GetMethod get = new GetMethod(url);
        get.addRequestHeader("User-Agent", CommonUtils.getHttpServer());
        try {
            HttpClientManager.executeMethodRedirecting(client, get);
            String string = get.getResponseBodyAsString();
            return string;
        }
        catch (IOException ioe) {
            LOG.warn("Can't contact license server: " + url, ioe);
            String string = null;
            return string;
        }
        finally {
            get.releaseConnection();
        }
    }

    protected abstract void parseDocumentNode(Node var1, boolean var2);

    protected void parseXML(String xml, boolean liveData) {
        if (xml == null) {
            return;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Attempting to parse: " + xml);
        }
        DOMParser parser = new DOMParser();
        InputSource is = new InputSource(new StringReader(xml));
        try {
            parser.parse(is);
        }
        catch (IOException ioe) {
            LOG.debug("IOX parsing XML\n" + xml, ioe);
            return;
        }
        catch (SAXException saxe) {
            LOG.debug("SAX parsing XML\n" + xml, saxe);
            return;
        }
        this.parseDocumentNode(parser.getDocument().getDocumentElement(), liveData);
    }

    private class Verifier
    implements Runnable {
        private final VerificationListener vc;

        Verifier(VerificationListener listener) {
            this.vc = listener;
        }

        public void run() {
            String body = AbstractLicense.this.getBody(AbstractLicense.this.getLicenseURI().toString());
            AbstractLicense.this.parseXML(body, true);
            AbstractLicense.this.lastVerifiedTime = System.currentTimeMillis();
            AbstractLicense.this.verified = 2;
            LicenseCache.instance().addVerifiedLicense(AbstractLicense.this);
            if (this.vc != null) {
                this.vc.licenseVerified(AbstractLicense.this);
            }
        }
    }
}

