/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.licenses;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.licenses.CCLicense;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class CCConstants {
    private static final Log LOG = LogFactory.getLog(CCLicense.class);
    public static final String CC_URI_PREFIX = "creativecommons.org/licenses/";
    public static final String URL_INDICATOR = "verify at";
    public static final String CC_RDF_HEADER = "<!-- <rdf:RDF xmlns=\"http://web.resource.org/cc/\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\">";
    public static final String CC_RDF_FOOTER = "</rdf:RDF> -->";
    public static final int ATTRIBUTION = 0;
    public static final int ATTRIBUTION_NO_DERIVS = 1;
    public static final int ATTRIBUTION_NON_COMMERCIAL = 2;
    public static final int ATTRIBUTION_NON_COMMERCIAL_NO_DERIVS = 3;
    public static final int ATTRIBUTION_SHARE = 4;
    public static final int ATTRIBUTION_SHARE_NON_COMMERCIAL = 6;
    public static final String ATTRIBUTION_URI = "http://creativecommons.org/licenses/by/2.5/";
    public static final String ATTRIBUTION_NO_DERIVS_URI = "http://creativecommons.org/licenses/by-nd/2.5/";
    public static final String ATTRIBUTION_NON_COMMERCIAL_URI = "http://creativecommons.org/licenses/by-nc/2.5/";
    public static final String ATTRIBUTION_NON_COMMERCIAL_NO_DERIVS_URI = "http://creativecommons.org/licenses/by-nc-nd/2.5/";
    public static final String ATTRIBUTION_SHARE_URI = "http://creativecommons.org/licenses/by-sa/2.5/";
    public static final String ATTRIBUTION_SHARE_NON_COMMERCIAL_URI = "http://creativecommons.org/licenses/by-nc-sa/2.5/";
    private static final Map LICENSE_URI_MAP = new HashMap();

    public static String getLicenseURI(int licenseType) {
        return (String)LICENSE_URI_MAP.get(new Integer(licenseType));
    }

    public static String getLicenseElement(int licenseType) {
        Integer licenseTypeI = new Integer(licenseType);
        Assert.that(LICENSE_URI_MAP.containsKey(licenseTypeI));
        StringBuffer ret = new StringBuffer();
        ret.append("<License rdf:about=\"").append(LICENSE_URI_MAP.get(licenseTypeI)).append("\">");
        ret.append("<requires rdf:resource=\"http://web.resource.org/cc/Attribution\" />");
        ret.append("<permits rdf:resource=\"http://web.resource.org/cc/Reproduction\" />");
        ret.append("<permits rdf:resource=\"http://web.resource.org/cc/Distribution\" />");
        if ((licenseType & 1) == 0) {
            ret.append("<permits rdf:resource=\"http://web.resource.org/cc/DerivativeWorks\" />");
        }
        if ((licenseType & 2) != 0) {
            ret.append("<prohibits rdf:resource=\"http://web.resource.org/cc/CommercialUse\" />");
        }
        if ((licenseType & 4) != 0) {
            ret.append("<requires rdf:resource=\"http://web.resource.org/cc/ShareAlike\" />");
        }
        ret.append("<requires rdf:resource=\"http://web.resource.org/cc/Notice\" />");
        ret.append("</License>");
        return ret.toString();
    }

    static URL guessLicenseDeed(String license) {
        if (license == null) {
            return null;
        }
        int idx = license.indexOf(CC_URI_PREFIX);
        if (idx == -1) {
            return null;
        }
        int httpIdx = license.lastIndexOf("http://", idx);
        if (httpIdx == -1) {
            return null;
        }
        if (httpIdx != 0 && license.charAt(httpIdx - 1) != ' ') {
            return null;
        }
        int spaceIdx = license.indexOf(" ", httpIdx);
        if (spaceIdx == -1) {
            spaceIdx = license.length();
        } else if (spaceIdx < idx) {
            return null;
        }
        try {
            return new URL(license.substring(httpIdx, spaceIdx));
        }
        catch (MalformedURLException bad) {
            LOG.warn("Unable to create URL from license: " + license, bad);
            return null;
        }
    }

    static {
        LICENSE_URI_MAP.put(new Integer(0), ATTRIBUTION_URI);
        LICENSE_URI_MAP.put(new Integer(1), ATTRIBUTION_NO_DERIVS_URI);
        LICENSE_URI_MAP.put(new Integer(2), ATTRIBUTION_NON_COMMERCIAL_URI);
        LICENSE_URI_MAP.put(new Integer(3), ATTRIBUTION_NON_COMMERCIAL_NO_DERIVS_URI);
        LICENSE_URI_MAP.put(new Integer(4), ATTRIBUTION_SHARE_URI);
        LICENSE_URI_MAP.put(new Integer(6), ATTRIBUTION_SHARE_NON_COMMERCIAL_URI);
    }
}

