/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.licenses;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LicenseConstants {
    public static final int NO_LICENSE = 0;
    public static final int CC_LICENSE = 1;
    public static final int WEED_LICENSE = 2;
    public static final int DRM_LICENSE = 3;
    public static final int GPL = 4;
    public static final int LGPL = 5;
    public static final int APACHE_BSD = 6;
    public static final int MIT_X = 7;
    public static final int FDL = 8;
    public static final int ARTISTIC = 9;
    public static final int PUBLIC_DOMAIN = 10;
    public static final int SHAREWARE = 11;
    private static final String[] LICENSE_DESCS;
    private static final Map LICENSE_DESC_CACHE;

    public static List getIndivisible(int type) {
        if (type >= LICENSE_DESCS.length) {
            return Collections.EMPTY_LIST;
        }
        if (type == 0 || type == 3) {
            return Collections.EMPTY_LIST;
        }
        Integer i = new Integer(type);
        List<String> ret = (ArrayList<String>)LICENSE_DESC_CACHE.get(i);
        if (ret != null) {
            return ret;
        }
        ret = new ArrayList<String>(1);
        ret.add(LICENSE_DESCS[type]);
        ret = Collections.unmodifiableList(ret);
        LICENSE_DESC_CACHE.put(i, ret);
        return ret;
    }

    public static int determineLicenseType(String license, String type) {
        if (LicenseConstants.hasCCLicense(license, type)) {
            return 1;
        }
        if (LicenseConstants.hasWeedLicense(type)) {
            return 2;
        }
        if (LicenseConstants.hasDRMLicense(type)) {
            return 3;
        }
        for (int i = 0; i < LICENSE_DESCS.length; ++i) {
            if (!LICENSE_DESCS[i].equals(type)) continue;
            return i;
        }
        return 0;
    }

    private static boolean hasCCLicense(String license, String type) {
        return type != null && type.equals("creativecommons.org/licenses/") || license != null && license.indexOf("creativecommons.org/licenses/") != -1 && license.indexOf("verify at") != -1;
    }

    private static boolean hasWeedLicense(String type) {
        return type != null && type.startsWith("http://www.shmedlic.com/license/3play.aspx") && type.indexOf(" vid: ") != -1 && type.indexOf(" cid: ") != -1;
    }

    private static boolean hasDRMLicense(String type) {
        return type != null && type.startsWith("licensed: ");
    }

    public static boolean isDRMLicense(int type) {
        return type == 2 || type == 3;
    }

    static {
        ArrayList<String> descList = new ArrayList<String>();
        descList.add("");
        descList.add("creativecommons.org/licenses/");
        descList.add("http://www.shmedlic.com/license/3play.aspx");
        descList.add("");
        descList.add("http://www.gnu.org/copyleft/gpl.html");
        descList.add("http://www.gnu.org/copyleft/lgpl.html");
        descList.add("http://opensource.org/licenses/apache2.0.php");
        descList.add("http://opensource.org/licenses/mit-license.php");
        descList.add("http://www.gnu.org/copyleft/fdl.html");
        descList.add("http://www.opensource.org/licenses/artistic-license.php");
        descList.add("http://www.public-domain.org");
        descList.add("http://en.wikipedia.org/wiki/Shareware");
        LICENSE_DESCS = descList.toArray(new String[0]);
        LICENSE_DESC_CACHE = new HashMap();
    }
}

