/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages;

import com.limegroup.gnutella.messages.BadGGEPBlockException;
import com.limegroup.gnutella.messages.GGEP;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GGEPParser {
    private static final Log LOG = LogFactory.getLog(GGEPParser.class);
    private GGEP normal = null;
    private GGEP secure = null;
    private int secureStart = -1;
    private int secureEnd = -1;

    public void scanForGGEPs(byte[] data, int idx) {
        while (idx < data.length && data[idx] != -61) {
            ++idx;
        }
        if (idx >= data.length) {
            LOG.debug("No GGEP in data");
            return;
        }
        int[] storage = new int[1];
        GGEP normal = null;
        GGEP secure = null;
        int secureStart = -1;
        int secureEnd = -1;
        try {
            while (secure == null && idx < data.length && data[idx] == -61) {
                GGEP ggep = new GGEP(data, idx, storage);
                if (ggep.hasKey("SB")) {
                    secure = ggep;
                    secureStart = idx;
                    secureEnd = storage[0];
                    break;
                }
                if (normal == null) {
                    normal = ggep;
                } else {
                    normal.merge(ggep);
                }
                idx = storage[0];
                storage[0] = -1;
            }
        }
        catch (BadGGEPBlockException ignored) {
            LOG.debug("Unable to create ggep", ignored);
        }
        this.normal = normal;
        this.secure = secure;
        this.secureStart = secureStart;
        this.secureEnd = secureEnd;
    }

    public GGEP getNormalGGEP() {
        return this.normal;
    }

    public GGEP getSecureGGEP() {
        return this.secure;
    }

    public int getSecureStartIndex() {
        return this.secureStart;
    }

    public int getSecureEndIndex() {
        return this.secureEnd;
    }
}

