/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.messages.PushRequest;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.messages.vendor.VendorMessageFactory;
import com.limegroup.gnutella.routing.RouteTableMessage;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.MessageSettings;
import com.limegroup.gnutella.statistics.ReceivedErrorStat;
import com.limegroup.gnutella.udpconnect.UDPConnectionMessage;
import com.limegroup.gnutella.util.DataUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MessageFactory {
    private static final Log LOG = LogFactory.getLog(MessageFactory.class);
    private static final MessageParser[] PARSERS = new MessageParser[255];
    private static final byte SOFT_MAX = ConnectionSettings.SOFT_MAX.getValue();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setParser(byte functionId, MessageParser parser) {
        if (parser == null) {
            throw new NullPointerException("MessageParser is null");
        }
        int index = functionId & 0xFF;
        MessageParser o = null;
        MessageParser[] messageParserArray = PARSERS;
        synchronized (PARSERS) {
            o = PARSERS[index];
            MessageFactory.PARSERS[index] = parser;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (o != null && LOG.isErrorEnabled()) {
                LOG.error("There was already a MessageParser of type " + o.getClass() + " registered for functionId " + functionId);
            }
            return;
        }
    }

    public static MessageParser getParser(byte functionId) {
        return PARSERS[functionId & 0xFF];
    }

    public static Message read(InputStream in) throws BadPacketException, IOException {
        return MessageFactory.read(in, new byte[23], -1, SOFT_MAX);
    }

    public static Message read(InputStream in, byte softMax) throws BadPacketException, IOException {
        return MessageFactory.read(in, new byte[23], -1, softMax);
    }

    public static Message read(InputStream in, int network) throws BadPacketException, IOException {
        return MessageFactory.read(in, new byte[23], network, SOFT_MAX);
    }

    public static Message read(InputStream in, byte[] buf, byte softMax) throws BadPacketException, IOException {
        return MessageFactory.read(in, buf, -1, softMax);
    }

    public static Message read(InputStream in, int network, byte[] buf) throws BadPacketException, IOException {
        return MessageFactory.read(in, buf, network, SOFT_MAX);
    }

    public static Message read(InputStream in, byte[] buf, int network, byte softMax) throws BadPacketException, IOException {
        int got;
        for (int i = 0; i < 23; i += got) {
            try {
                got = in.read(buf, i, 23 - i);
            }
            catch (InterruptedIOException e) {
                if (i == 0) {
                    return null;
                }
                throw e;
            }
            if (got != -1) continue;
            ReceivedErrorStat.CONNECTION_CLOSED.incrementStat();
            throw new IOException("Connection closed.");
        }
        int length = ByteOrder.leb2int(buf, 19);
        if (length < 0 || length > MessageSettings.MAX_LENGTH.getValue()) {
            ReceivedErrorStat.INVALID_LENGTH.incrementStat();
            throw new IOException("Unreasonable message length: " + length);
        }
        byte[] payload = null;
        if (length != 0) {
            int got2;
            payload = new byte[length];
            for (int i = 0; i < length; i += got2) {
                got2 = in.read(payload, i, length - i);
                if (got2 != -1) continue;
                ReceivedErrorStat.CONNECTION_CLOSED.incrementStat();
                throw new IOException("Connection closed.");
            }
        } else {
            payload = DataUtils.EMPTY_BYTE_ARRAY;
        }
        return MessageFactory.createMessage(buf, payload, softMax, network);
    }

    public static Message createMessage(byte[] header, byte[] payload, byte softMax, int network) throws BadPacketException, IOException {
        if (header.length < 19) {
            throw new IllegalArgumentException("header must be >= 19 bytes.");
        }
        byte func = header[16];
        MessageParser parser = MessageFactory.getParser(func);
        if (parser == null) {
            ReceivedErrorStat.INVALID_CODE.incrementStat();
            throw new BadPacketException("Unrecognized function code: " + func);
        }
        byte ttl = header[17];
        byte hops = header[18];
        int hardMax = 14;
        if (hops < 0) {
            ReceivedErrorStat.INVALID_HOPS.incrementStat();
            throw new BadPacketException("Negative (or very large) hops");
        }
        if (ttl < 0) {
            ReceivedErrorStat.INVALID_TTL.incrementStat();
            throw new BadPacketException("Negative (or very large) TTL");
        }
        if (hops > softMax && func != -127 && func != 1) {
            ReceivedErrorStat.HOPS_EXCEED_SOFT_MAX.incrementStat();
            throw new BadPacketException("func: " + func + ", ttl: " + ttl + ", hops: " + hops);
        }
        if (ttl + hops > hardMax) {
            ReceivedErrorStat.HOPS_AND_TTL_OVER_HARD_MAX.incrementStat();
            throw new BadPacketException("TTL+hops exceeds hard max; probably spam");
        }
        if (ttl + hops > softMax && func != -127 && func != 1) {
            ttl = (byte)(softMax - hops);
            Assert.that(ttl >= 0);
        }
        byte[] guid = new byte[16];
        System.arraycopy(header, 0, guid, 0, guid.length);
        return parser.parse(guid, ttl, hops, payload, network);
    }

    static {
        MessageFactory.setParser((byte)0, new PingRequestParser());
        MessageFactory.setParser((byte)1, new PingReplyParser());
        MessageFactory.setParser((byte)-128, new QueryRequestParser());
        MessageFactory.setParser((byte)-127, new QueryReplyParser());
        MessageFactory.setParser((byte)64, new PushRequestParser());
        MessageFactory.setParser((byte)48, new RouteTableUpdateParser());
        MessageFactory.setParser((byte)49, new VendorMessageParser());
        MessageFactory.setParser((byte)50, new VendorMessageStableParser());
        MessageFactory.setParser((byte)65, new UDPConnectionParser());
    }

    private static class UDPConnectionParser
    implements MessageParser {
        private UDPConnectionParser() {
        }

        public Message parse(byte[] guid, byte ttl, byte hops, byte[] payload, int network) throws BadPacketException {
            return UDPConnectionMessage.createMessage(guid, ttl, hops, payload);
        }
    }

    private static class VendorMessageStableParser
    implements MessageParser {
        private VendorMessageStableParser() {
        }

        public Message parse(byte[] guid, byte ttl, byte hops, byte[] payload, int network) throws BadPacketException {
            return VendorMessageFactory.deriveVendorMessage(guid, ttl, hops, payload, network);
        }
    }

    private static class VendorMessageParser
    implements MessageParser {
        private VendorMessageParser() {
        }

        public Message parse(byte[] guid, byte ttl, byte hops, byte[] payload, int network) throws BadPacketException {
            return VendorMessageFactory.deriveVendorMessage(guid, ttl, hops, payload, network);
        }
    }

    private static class RouteTableUpdateParser
    implements MessageParser {
        private RouteTableUpdateParser() {
        }

        public Message parse(byte[] guid, byte ttl, byte hops, byte[] payload, int network) throws BadPacketException {
            return RouteTableMessage.read(guid, ttl, hops, payload);
        }
    }

    private static class PushRequestParser
    implements MessageParser {
        private PushRequestParser() {
        }

        public Message parse(byte[] guid, byte ttl, byte hops, byte[] payload, int network) throws BadPacketException {
            return new PushRequest(guid, ttl, hops, payload, network);
        }
    }

    private static class QueryReplyParser
    implements MessageParser {
        private QueryReplyParser() {
        }

        public Message parse(byte[] guid, byte ttl, byte hops, byte[] payload, int network) throws BadPacketException {
            if (payload.length < 26) {
                throw new BadPacketException("Query reply too short: " + payload.length);
            }
            return new QueryReply(guid, ttl, hops, payload, network);
        }
    }

    private static class QueryRequestParser
    implements MessageParser {
        private QueryRequestParser() {
        }

        public Message parse(byte[] guid, byte ttl, byte hops, byte[] payload, int network) throws BadPacketException {
            if (payload.length < 3) {
                throw new BadPacketException("Query request too short: " + payload.length);
            }
            return QueryRequest.createNetworkQuery(guid, ttl, hops, payload, network);
        }
    }

    private static class PingReplyParser
    implements MessageParser {
        private PingReplyParser() {
        }

        public Message parse(byte[] guid, byte ttl, byte hops, byte[] payload, int network) throws BadPacketException {
            return PingReply.createFromNetwork(guid, ttl, hops, payload);
        }
    }

    private static class PingRequestParser
    implements MessageParser {
        private PingRequestParser() {
        }

        public Message parse(byte[] guid, byte ttl, byte hops, byte[] payload, int network) throws BadPacketException {
            if (payload.length > 0) {
                return new PingRequest(guid, ttl, hops, payload);
            }
            return new PingRequest(guid, ttl, hops);
        }
    }

    public static interface MessageParser {
        public Message parse(byte[] var1, byte var2, byte var3, byte[] var4, int var5) throws BadPacketException;
    }
}

