/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.statistics.DroppedSentMessageStatHandler;
import com.limegroup.gnutella.statistics.ReceivedErrorStat;
import com.limegroup.gnutella.statistics.SentMessageStatHandler;
import com.limegroup.gnutella.util.NetworkUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;

public class PushRequest
extends Message
implements Serializable {
    private static final int STANDARD_PAYLOAD_SIZE = 26;
    public static final long FW_TRANS_INDEX = 0x7FFFFFFDL;
    private byte[] payload;

    public PushRequest(byte[] guid, byte ttl, byte hops, byte[] payload, int network) throws BadPacketException {
        super(guid, (byte)64, ttl, hops, payload.length, network);
        if (payload.length < 26) {
            ReceivedErrorStat.PUSH_INVALID_PAYLOAD.incrementStat();
            throw new BadPacketException("Payload too small: " + payload.length);
        }
        this.payload = payload;
        if (!NetworkUtils.isValidPort(this.getPort())) {
            ReceivedErrorStat.PUSH_INVALID_PORT.incrementStat();
            throw new BadPacketException("invalid port");
        }
        String ip = NetworkUtils.ip2string(payload, 20);
        if (!NetworkUtils.isValidAddress(ip)) {
            ReceivedErrorStat.PUSH_INVALID_ADDRESS.incrementStat();
            throw new BadPacketException("invalid address: " + ip);
        }
    }

    public PushRequest(byte[] guid, byte ttl, byte[] clientGUID, long index, byte[] ip, int port) {
        this(guid, ttl, clientGUID, index, ip, port, -1);
    }

    public PushRequest(byte[] guid, byte ttl, byte[] clientGUID, long index, byte[] ip, int port, int network) {
        super(guid, (byte)64, ttl, (byte)0, 26, network);
        if (clientGUID.length != 16) {
            throw new IllegalArgumentException("invalid guid length: " + clientGUID.length);
        }
        if ((index & 0xFFFFFFFF00000000L) != 0L) {
            throw new IllegalArgumentException("invalid index: " + index);
        }
        if (ip.length != 4) {
            throw new IllegalArgumentException("invalid ip length: " + ip.length);
        }
        if (!NetworkUtils.isValidAddress(ip)) {
            throw new IllegalArgumentException("invalid ip " + NetworkUtils.ip2string(ip));
        }
        if (!NetworkUtils.isValidPort(port)) {
            throw new IllegalArgumentException("invalid port: " + port);
        }
        this.payload = new byte[26];
        System.arraycopy(clientGUID, 0, this.payload, 0, 16);
        ByteOrder.int2leb((int)index, this.payload, 16);
        this.payload[20] = ip[0];
        this.payload[21] = ip[1];
        this.payload[22] = ip[2];
        this.payload[23] = ip[3];
        ByteOrder.short2leb((short)port, this.payload, 24);
    }

    protected void writePayload(OutputStream out) throws IOException {
        out.write(this.payload);
        SentMessageStatHandler.TCP_PUSH_REQUESTS.addMessage(this);
    }

    public byte[] getClientGUID() {
        byte[] ret = new byte[16];
        System.arraycopy(this.payload, 0, ret, 0, 16);
        return ret;
    }

    public long getIndex() {
        return ByteOrder.uint2long(ByteOrder.leb2int(this.payload, 16));
    }

    public boolean isFirewallTransferPush() {
        return this.getIndex() == 0x7FFFFFFDL;
    }

    public byte[] getIP() {
        byte[] ret = new byte[]{this.payload[20], this.payload[21], this.payload[22], this.payload[23]};
        return ret;
    }

    public int getPort() {
        return ByteOrder.ushort2int(ByteOrder.leb2short(this.payload, 24));
    }

    public Message stripExtendedPayload() {
        byte[] newPayload = new byte[26];
        System.arraycopy(this.payload, 0, newPayload, 0, 26);
        try {
            return new PushRequest(this.getGUID(), this.getTTL(), this.getHops(), newPayload, this.getNetwork());
        }
        catch (BadPacketException e) {
            Assert.that(false, "Standard packet length not allowed!");
            return null;
        }
    }

    public void recordDrop() {
        DroppedSentMessageStatHandler.TCP_PUSH_REQUESTS.addMessage(this);
    }

    public String toString() {
        return "PushRequest(" + super.toString() + " " + NetworkUtils.ip2string(this.getIP()) + ":" + this.getPort() + ")";
    }
}

