/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.messages.BadGGEPPropertyException;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.GGEP;
import com.limegroup.gnutella.messages.GGEPParser;
import com.limegroup.gnutella.messages.IPPortCombo;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.QueryReplyData;
import com.limegroup.gnutella.messages.SecureGGEPData;
import com.limegroup.gnutella.messages.SecureMessage;
import com.limegroup.gnutella.search.HostData;
import com.limegroup.gnutella.statistics.DroppedSentMessageStatHandler;
import com.limegroup.gnutella.statistics.ReceivedErrorStat;
import com.limegroup.gnutella.statistics.SentMessageStatHandler;
import com.limegroup.gnutella.util.DataUtils;
import com.limegroup.gnutella.util.IpPort;
import com.limegroup.gnutella.util.IpPortSet;
import com.limegroup.gnutella.util.NetworkUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class QueryReply
extends Message
implements SecureMessage {
    public static final int XML_MAX_SIZE = 32768;
    public static final int COMMON_PAYLOAD_LEN = 4;
    private static final byte PUSH_MASK = 1;
    private static final byte BUSY_MASK = 4;
    private static final byte UPLOADED_MASK = 8;
    private static final byte SPEED_MASK = 16;
    private static final byte GGEP_MASK = 32;
    private static final byte CHAT_MASK = 1;
    static final int TRUE = 1;
    static final int FALSE = 0;
    static final int UNDEFINED = -1;
    private static final GGEPUtil _ggepUtil = new GGEPUtil();
    private byte[] _payload;
    private byte[] _address = new byte[4];
    private int _secureStatus = 0;
    private boolean _parsed = false;
    private volatile QueryReplyData _data;
    private volatile boolean _multicastAllowed = false;
    private byte[] clientGUID = null;

    public QueryReply(byte[] guid, byte ttl, int port, byte[] ip, long speed, Response[] responses, byte[] clientGUID, boolean isMulticastReply) {
        this(guid, ttl, port, ip, speed, responses, clientGUID, DataUtils.EMPTY_BYTE_ARRAY, false, false, false, false, false, false, true, isMulticastReply, false, Collections.EMPTY_SET);
    }

    public QueryReply(byte[] guid, byte ttl, int port, byte[] ip, long speed, Response[] responses, byte[] clientGUID, boolean needsPush, boolean isBusy, boolean finishedUpload, boolean measuredSpeed, boolean supportsChat, boolean isMulticastReply) {
        this(guid, ttl, port, ip, speed, responses, clientGUID, DataUtils.EMPTY_BYTE_ARRAY, true, needsPush, isBusy, finishedUpload, measuredSpeed, supportsChat, true, isMulticastReply, false, Collections.EMPTY_SET);
    }

    public QueryReply(byte[] guid, byte ttl, int port, byte[] ip, long speed, Response[] responses, byte[] clientGUID, byte[] xmlBytes, boolean needsPush, boolean isBusy, boolean finishedUpload, boolean measuredSpeed, boolean supportsChat, boolean isMulticastReply) throws IllegalArgumentException {
        this(guid, ttl, port, ip, speed, responses, clientGUID, xmlBytes, needsPush, isBusy, finishedUpload, measuredSpeed, supportsChat, isMulticastReply, Collections.EMPTY_SET);
    }

    public QueryReply(byte[] guid, byte ttl, int port, byte[] ip, long speed, Response[] responses, byte[] clientGUID, byte[] xmlBytes, boolean needsPush, boolean isBusy, boolean finishedUpload, boolean measuredSpeed, boolean supportsChat, boolean isMulticastReply, Set proxies) throws IllegalArgumentException {
        this(guid, ttl, port, ip, speed, responses, clientGUID, xmlBytes, true, needsPush, isBusy, finishedUpload, measuredSpeed, supportsChat, true, isMulticastReply, false, proxies);
    }

    public QueryReply(byte[] guid, byte ttl, int port, byte[] ip, long speed, Response[] responses, byte[] clientGUID, byte[] xmlBytes, boolean needsPush, boolean isBusy, boolean finishedUpload, boolean measuredSpeed, boolean supportsChat, boolean isMulticastReply, boolean supportsFWTransfer, Set proxies) throws IllegalArgumentException {
        this(guid, ttl, port, ip, speed, responses, clientGUID, xmlBytes, true, needsPush, isBusy, finishedUpload, measuredSpeed, supportsChat, true, isMulticastReply, supportsFWTransfer, proxies);
    }

    public QueryReply(byte[] guid, byte ttl, byte hops, byte[] payload) throws BadPacketException {
        this(guid, ttl, hops, payload, -1);
    }

    public QueryReply(byte[] guid, byte ttl, byte hops, byte[] payload, int network) throws BadPacketException {
        super(guid, (byte)-127, ttl, hops, payload.length, network);
        this._payload = payload;
        if (!NetworkUtils.isValidPort(this.getPort())) {
            ReceivedErrorStat.REPLY_INVALID_PORT.incrementStat();
            throw new BadPacketException("invalid port");
        }
        if ((this.getSpeed() & 0xFFFFFFFF00000000L) != 0L) {
            ReceivedErrorStat.REPLY_INVALID_SPEED.incrementStat();
            throw new BadPacketException("invalid speed: " + this.getSpeed());
        }
        this.setAddress();
        if (!NetworkUtils.isValidAddress(this.getIPBytes())) {
            ReceivedErrorStat.REPLY_INVALID_ADDRESS.incrementStat();
            throw new BadPacketException("invalid address");
        }
    }

    public QueryReply(byte[] guid, QueryReply reply) {
        super(guid, (byte)-127, reply.getTTL(), reply.getHops(), reply.getLength());
        this._payload = reply._payload;
        this.setAddress();
    }

    private QueryReply(byte[] guid, byte ttl, int port, byte[] ip, long speed, Response[] responses, byte[] clientGUID, byte[] xmlBytes, boolean includeQHD, boolean needsPush, boolean isBusy, boolean finishedUpload, boolean measuredSpeed, boolean supportsChat, boolean supportsBH, boolean isMulticastReply, boolean supportsFWTransfer, Set proxies) {
        super(guid, (byte)-127, ttl, (byte)0, 0, 16);
        if (xmlBytes.length > 32768) {
            throw new IllegalArgumentException("xml too large: " + new String(xmlBytes));
        }
        int n = responses.length;
        if (!NetworkUtils.isValidPort(port)) {
            throw new IllegalArgumentException("invalid port: " + port);
        }
        if (ip.length != 4) {
            throw new IllegalArgumentException("invalid ip length: " + ip.length);
        }
        if (!NetworkUtils.isValidAddress(ip)) {
            throw new IllegalArgumentException("invalid address: " + NetworkUtils.ip2string(ip));
        }
        if ((speed & 0xFFFFFFFF00000000L) != 0L) {
            throw new IllegalArgumentException("invalid speed: " + speed);
        }
        if (n >= 256) {
            throw new IllegalArgumentException("invalid num responses: " + n);
        }
        this._data = new QueryReplyData();
        this._data.setXmlBytes(xmlBytes);
        this._data.setProxies(proxies);
        this._data.setSupportsFWTransfer(supportsFWTransfer);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            baos.write(n);
            ByteOrder.short2leb((short)port, baos);
            baos.write(ip, 0, ip.length);
            ByteOrder.int2leb((int)speed, baos);
            for (int left = n; left > 0; --left) {
                Response r = responses[n - left];
                r.writeToStream(baos);
            }
            if (includeQHD) {
                baos.write(76);
                baos.write(73);
                baos.write(77);
                baos.write(69);
                baos.write(4);
                int ggepLen = _ggepUtil.getQRGGEP(false, false, false, Collections.EMPTY_SET).length;
                boolean hasProxies = proxies != null && proxies.size() > 0;
                byte flags = (byte)((needsPush && !isMulticastReply ? 1 : 0) | 4 | 8 | 0x10 | 0x20);
                byte controls = (byte)(1 | (isBusy && !isMulticastReply ? 4 : 0) | (finishedUpload ? 8 : 0) | (measuredSpeed || isMulticastReply ? 16 : 0) | (supportsBH || isMulticastReply || hasProxies || supportsFWTransfer ? 32 : (ggepLen > 0 ? 32 : 0)));
                baos.write(flags);
                baos.write(controls);
                int xmlSize = xmlBytes.length + 1;
                if (xmlSize > 32768) {
                    xmlSize = 32768;
                }
                ByteOrder.short2leb((short)xmlSize, baos);
                int chatSupport = supportsChat ? 1 : 0;
                baos.write(chatSupport);
                byte[] ggepBytes = _ggepUtil.getQRGGEP(supportsBH, isMulticastReply, supportsFWTransfer, proxies);
                baos.write(ggepBytes, 0, ggepBytes.length);
                this.writeSecureGGEP(baos, xmlBytes);
                baos.write(xmlBytes, 0, xmlBytes.length);
                baos.write(0);
            }
            baos.write(clientGUID, 0, 16);
            this._payload = baos.toByteArray();
            this.updateLength(this._payload.length);
        }
        catch (IOException reallyBad) {
            ErrorService.error(reallyBad);
        }
        this.setAddress();
    }

    protected void writeSecureGGEP(ByteArrayOutputStream out, byte[] xml) {
    }

    private void setAddress() {
        this._address[0] = this._payload[3];
        this._address[1] = this._payload[4];
        this._address[2] = this._payload[5];
        this._address[3] = this._payload[6];
    }

    public void setOOBAddress(InetAddress addr, int port) {
        this._address = addr.getAddress();
        ByteOrder.short2leb((short)port, this._payload, 1);
    }

    public void setGUID(GUID guid) {
        super.setGUID(guid);
    }

    public void writePayload(OutputStream out) throws IOException {
        out.write(this._payload);
        SentMessageStatHandler.TCP_QUERY_REPLIES.addMessage(this);
    }

    public void setBrowseHostReply(boolean isBH) {
        this.parseResults();
        this._data.setBrowseHostReply(isBH);
    }

    public boolean isBrowseHostReply() {
        this.parseResults();
        return this._data.isBrowseHostReply();
    }

    public byte[] getXMLBytes() {
        this.parseResults();
        return this._data.getXmlBytes();
    }

    public short getResultCount() {
        return (short)ByteOrder.ubyte2int(this._payload[0]);
    }

    public short getUniqueResultCount() {
        this.parseResults();
        return this._data.getUniqueResultURNs();
    }

    public int getPort() {
        return ByteOrder.ushort2int(ByteOrder.leb2short(this._payload, 1));
    }

    public String getIP() {
        return NetworkUtils.ip2string(this._address);
    }

    public byte[] getIPBytes() {
        return this._address;
    }

    public long getSpeed() {
        return ByteOrder.uint2long(ByteOrder.leb2int(this._payload, 7));
    }

    public Response[] getResultsArray() throws BadPacketException {
        this.parseResults();
        Response[] responses = this._data.getResponses();
        if (responses == null) {
            throw new BadPacketException();
        }
        return responses;
    }

    public Iterator getResults() throws BadPacketException {
        this.parseResults();
        Response[] responses = this._data.getResponses();
        if (responses == null) {
            throw new BadPacketException();
        }
        List<Response> list = Arrays.asList(responses);
        return list.iterator();
    }

    public List getResultsAsList() throws BadPacketException {
        this.parseResults();
        Response[] responses = this._data.getResponses();
        if (responses == null) {
            throw new BadPacketException("results are null");
        }
        List<Response> list = Arrays.asList(responses);
        return list;
    }

    public String getVendor() throws BadPacketException {
        this.parseResults();
        String vendor = this._data.getVendor();
        if (vendor == null) {
            throw new BadPacketException();
        }
        return vendor;
    }

    public boolean getNeedsPush() throws BadPacketException {
        this.parseResults();
        switch (this._data.getPushFlag()) {
            case -1: {
                throw new BadPacketException();
            }
            case 1: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        Assert.that(false, "Bad value for push flag: " + this._data.getPushFlag());
        return false;
    }

    public boolean getIsBusy() throws BadPacketException {
        this.parseResults();
        switch (this._data.getBusyFlag()) {
            case -1: {
                throw new BadPacketException();
            }
            case 1: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        Assert.that(false, "Bad value for busy flag: " + this._data.getBusyFlag());
        return false;
    }

    public boolean getHadSuccessfulUpload() throws BadPacketException {
        this.parseResults();
        switch (this._data.getUploadedFlag()) {
            case -1: {
                throw new BadPacketException();
            }
            case 1: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        Assert.that(false, "Bad value for uploaded flag: " + this._data.getUploadedFlag());
        return false;
    }

    public boolean getIsMeasuredSpeed() throws BadPacketException {
        this.parseResults();
        switch (this._data.getMeasuredSpeedFlag()) {
            case -1: {
                throw new BadPacketException();
            }
            case 1: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        Assert.that(false, "Bad value for measured speed flag: " + this._data.getMeasuredSpeedFlag());
        return false;
    }

    public byte[] getSecureSignature() {
        this.parseResults();
        SecureGGEPData sg = this._data.getSecureGGEP();
        if (sg != null) {
            try {
                return sg.getGGEP().getBytes("SIG");
            }
            catch (BadGGEPPropertyException bgpe) {
                return null;
            }
        }
        return null;
    }

    public void updateSignatureWithSecuredBytes(Signature signature) throws SignatureException {
        this.parseResults();
        SecureGGEPData sg = this._data.getSecureGGEP();
        if (sg != null) {
            signature.update(this._payload, 0, sg.getStartIndex());
            int end = sg.getEndIndex();
            int length = this._payload.length - 16 - end;
            signature.update(this._payload, end, length);
        }
    }

    public synchronized int getSecureStatus() {
        return this._secureStatus;
    }

    public synchronized void setSecureStatus(int secureStatus) {
        this._secureStatus = secureStatus;
    }

    public boolean getSupportsChat() {
        this.parseResults();
        return this._data.isSupportsChat();
    }

    public boolean getSupportsFWTransfer() {
        this.parseResults();
        return this._data.isSupportsFWTransfer();
    }

    public byte getFWTransferVersion() {
        this.parseResults();
        return this._data.getFwTransferVersion();
    }

    public boolean getSupportsBrowseHost() {
        this.parseResults();
        return this._data.isSupportsBrowseHost();
    }

    public boolean isReplyToMulticastQuery() {
        this.parseResults();
        return this._multicastAllowed && this._data.isReplyToMulticast();
    }

    public void setMulticastAllowed(boolean allowed) {
        this._multicastAllowed = allowed;
    }

    public boolean isFakeMulticast() {
        this.parseResults();
        return !this._multicastAllowed && this._data.isReplyToMulticast();
    }

    public Set getPushProxies() {
        this.parseResults();
        return this._data.getProxies();
    }

    public HostData getHostData() throws BadPacketException {
        this.parseResults();
        HostData hd = this._data.getHostData();
        if (hd == null) {
            throw new BadPacketException();
        }
        return hd;
    }

    public boolean hasSecureData() {
        this.parseResults();
        return this._data.getSecureGGEP() != null;
    }

    private synchronized void parseResults() {
        if (this._parsed) {
            return;
        }
        this._parsed = true;
        this.parseResults2();
    }

    private void parseResults2() {
        int left;
        int i = 11;
        this._data = new QueryReplyData();
        Response[] responses = new Response[left];
        HashSet urns = new HashSet();
        short uniqueURNs = 0;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(this._payload, i, this._payload.length - i);
            for (left = this.getResultCount(); left > 0; --left) {
                Response r;
                responses[responses.length - left] = r = Response.createFromStream(bais);
                i += r.getLength();
                if (r.getUrns().isEmpty()) {
                    uniqueURNs = (short)(uniqueURNs + 1);
                    continue;
                }
                urns.addAll(r.getUrns());
            }
            this._data.setResponses(responses);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return;
        }
        catch (IOException e) {
            return;
        }
        uniqueURNs = (short)(uniqueURNs + (short)urns.size());
        this._data.setUniqueResultURNs(uniqueURNs);
        try {
            int privateLength;
            if (i >= this._payload.length - 16) {
                throw new BadPacketException("No QHD");
            }
            String vendorT = null;
            int pushFlagT = -1;
            int busyFlagT = -1;
            int uploadedFlagT = -1;
            int measuredSpeedFlagT = -1;
            boolean supportsChatT = false;
            boolean supportsBrowseHostT = false;
            boolean replyToMulticastT = false;
            Set proxies = null;
            try {
                vendorT = new String(this._payload, i, 4, "ISO-8859-1");
                Assert.that(vendorT.length() == 4, "Vendor length wrong.  Wrong character encoding?");
            }
            catch (UnsupportedEncodingException e) {
                Assert.that(false, "No support for ISO-8859-1 encoding");
            }
            int length = ByteOrder.ubyte2int(this._payload[i += 4]);
            if (length <= 0) {
                throw new BadPacketException("Common payload length zero.");
            }
            if (++i + length > this._payload.length - 16) {
                throw new BadPacketException("Common payload length imprecise!");
            }
            if (length > 1) {
                byte control = this._payload[i];
                byte flags = this._payload[i + 1];
                if ((flags & 1) != 0) {
                    int n = pushFlagT = (control & 1) == 1 ? 1 : 0;
                }
                if ((control & 4) != 0) {
                    int n = busyFlagT = (flags & 4) != 0 ? 1 : 0;
                }
                if ((control & 8) != 0) {
                    int n = uploadedFlagT = (flags & 8) != 0 ? 1 : 0;
                }
                if ((control & 0x10) != 0) {
                    int n = measuredSpeedFlagT = (flags & 0x10) != 0 ? 1 : 0;
                }
                if ((control & 0x20) != 0 && (flags & 0x20) != 0) {
                    GGEPParser parser = new GGEPParser();
                    parser.scanForGGEPs(this._payload, i + 2);
                    GGEP ggep = parser.getNormalGGEP();
                    if (ggep != null) {
                        try {
                            supportsBrowseHostT = ggep.hasKey("BH");
                            if (ggep.hasKey("FW")) {
                                this._data.setFwTransferVersion(ggep.getBytes("FW")[0]);
                                this._data.setSupportsFWTransfer(this._data.getFwTransferVersion() > 0);
                            }
                            replyToMulticastT = ggep.hasKey("MCAST");
                            proxies = _ggepUtil.getPushProxies(ggep);
                        }
                        catch (BadGGEPPropertyException bgpe) {
                            // empty catch block
                        }
                    }
                    if (parser.getSecureGGEP() != null) {
                        this._data.setSecureGGEP(new SecureGGEPData(parser));
                    }
                }
                i += 2;
            }
            if (length > 2) {
                int b;
                int temp;
                int a;
                int xmlSize;
                if ((xmlSize = (a = (temp = ByteOrder.ubyte2int(this._payload[i++]))) | (b = (temp = ByteOrder.ubyte2int(this._payload[i++])) << 8)) > 1) {
                    int xmlInPayloadIndex = this._payload.length - 16 - xmlSize;
                    byte[] xmlBytes = new byte[xmlSize - 1];
                    System.arraycopy(this._payload, xmlInPayloadIndex, xmlBytes, 0, xmlSize - 1);
                    this._data.setXmlBytes(xmlBytes);
                } else {
                    this._data.setXmlBytes(DataUtils.EMPTY_BYTE_ARRAY);
                }
            }
            if ((privateLength = this._payload.length - i) > 0 && (vendorT.equals("LIME") || vendorT.equals("RAZA"))) {
                byte privateFlags = this._payload[i];
                boolean bl = supportsChatT = (privateFlags & 1) != 0;
            }
            if (i > this._payload.length - 16) {
                throw new BadPacketException("Common payload length too large.");
            }
            Assert.that(vendorT != null);
            this._data.setVendor(vendorT.toUpperCase(Locale.US));
            this._data.setPushFlag(pushFlagT);
            this._data.setBusyFlag(busyFlagT);
            this._data.setUploadedFlag(uploadedFlagT);
            this._data.setMeasuredSpeedFlag(measuredSpeedFlagT);
            this._data.setSupportsChat(supportsChatT);
            this._data.setSupportsBrowseHost(supportsBrowseHostT);
            this._data.setReplyToMulticast(replyToMulticastT);
            if (proxies == null) {
                this._data.setProxies(Collections.EMPTY_SET);
            } else {
                this._data.setProxies(proxies);
            }
            this._data.setHostData(new HostData(this));
        }
        catch (BadPacketException e) {
            return;
        }
        catch (IndexOutOfBoundsException e) {
            return;
        }
    }

    public byte[] getClientGUID() {
        if (this.clientGUID == null) {
            byte[] result = new byte[16];
            int length = super.getLength();
            System.arraycopy(this._payload, length - 16, result, 0, 16);
            this.clientGUID = result;
        }
        return this.clientGUID;
    }

    public Message stripExtendedPayload() {
        return this;
    }

    public String toString() {
        return "QueryReply::\r\n" + this.getResultCount() + " hits\r\n" + super.toString() + "\r\n" + "ip: " + this.getIP() + "\r\n";
    }

    public int calculateQualityOfService(boolean iFirewalled) {
        int heFirewalled;
        int busy;
        boolean YES = true;
        boolean MAYBE = false;
        int NO = -1;
        try {
            busy = this.getIsBusy() ? 1 : -1;
        }
        catch (BadPacketException e) {
            busy = 0;
        }
        boolean isMCastReply = this.isReplyToMulticastQuery();
        if (isMCastReply) {
            iFirewalled = false;
            heFirewalled = -1;
        } else if (NetworkUtils.isPrivateAddress(this.getIPBytes())) {
            heFirewalled = 1;
        } else {
            try {
                heFirewalled = this.getNeedsPush() ? 1 : -1;
            }
            catch (BadPacketException e) {
                heFirewalled = 0;
            }
        }
        boolean hasPushProxies = false;
        if (this.getPushProxies() != null && this.getPushProxies().size() > 1) {
            hasPushProxies = true;
        }
        if (this.getSupportsFWTransfer() && UDPService.instance().canDoFWT()) {
            iFirewalled = false;
            heFirewalled = -1;
        }
        if (Arrays.equals(this._address, RouterService.getAddress())) {
            return 3;
        }
        if (isMCastReply) {
            return 4;
        }
        if (iFirewalled && heFirewalled == 1) {
            return -1;
        }
        if (busy == 0 || heFirewalled == 0) {
            return 0;
        }
        if (busy == 1) {
            Assert.that(heFirewalled == -1 || !iFirewalled);
            if (heFirewalled == 1) {
                return 0;
            }
            return 1;
        }
        if (busy == -1) {
            Assert.that(heFirewalled == -1 || !iFirewalled);
            if (heFirewalled == 1 && !hasPushProxies) {
                return 2;
            }
            return 3;
        }
        Assert.that(false, "Unexpected case!");
        return -1;
    }

    public static boolean isFirewalledQuality(int quality) {
        return quality == 0 || quality == 2;
    }

    public void recordDrop() {
        DroppedSentMessageStatHandler.TCP_QUERY_REPLIES.addMessage(this);
    }

    static class GGEPUtil {
        private final byte[] _standardGGEP;
        private final byte[] _bhGGEP;
        private final byte[] _mcGGEP;
        private final byte[] _comboGGEP;

        public GGEPUtil() {
            ByteArrayOutputStream oStream = new ByteArrayOutputStream();
            try {
                GGEP standard = new GGEP(false);
                standard.write(oStream);
            }
            catch (IOException writeError) {
                // empty catch block
            }
            this._standardGGEP = oStream.toByteArray();
            oStream.reset();
            try {
                GGEP bhost = new GGEP(false);
                bhost.put("BH");
                bhost.write(oStream);
            }
            catch (IOException writeError) {
                // empty catch block
            }
            this._bhGGEP = oStream.toByteArray();
            Assert.that(this._bhGGEP != null);
            oStream.reset();
            try {
                GGEP mcast = new GGEP(false);
                mcast.put("MCAST");
                mcast.write(oStream);
            }
            catch (IOException writeError) {
                // empty catch block
            }
            this._mcGGEP = oStream.toByteArray();
            Assert.that(this._mcGGEP != null);
            oStream.reset();
            try {
                GGEP combo = new GGEP(false);
                combo.put("MCAST");
                combo.put("BH");
                combo.write(oStream);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this._comboGGEP = oStream.toByteArray();
            Assert.that(this._comboGGEP != null);
        }

        public byte[] getQRGGEP(boolean supportsBH, boolean isMulticastResponse, boolean supportsFWTransfer, Set proxies) {
            byte[] retGGEPBlock = this._standardGGEP;
            if (proxies != null && proxies.size() > 0) {
                int MAX_PROXIES = 4;
                GGEP retGGEP = new GGEP();
                if (supportsBH) {
                    retGGEP.put("BH");
                }
                if (isMulticastResponse) {
                    retGGEP.put("MCAST");
                }
                if (supportsFWTransfer) {
                    retGGEP.put("FW", new byte[]{1});
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                int numWritten = 0;
                Iterator iter = proxies.iterator();
                while (iter.hasNext() && numWritten < 4) {
                    IpPort ppi = (IpPort)iter.next();
                    String host = ppi.getAddress();
                    int port = ppi.getPort();
                    try {
                        IPPortCombo combo = new IPPortCombo(host, port);
                        baos.write(combo.toBytes());
                        ++numWritten;
                    }
                    catch (UnknownHostException bad) {
                    }
                    catch (IOException terrible) {
                        ErrorService.error(terrible);
                    }
                }
                try {
                    if (numWritten > 0) {
                        retGGEP.put("PUSH", baos.toByteArray());
                    }
                    baos.reset();
                    retGGEP.write(baos);
                    retGGEPBlock = baos.toByteArray();
                }
                catch (IOException terrible) {
                    ErrorService.error(terrible);
                }
            } else if (supportsBH && isMulticastResponse) {
                retGGEPBlock = this._comboGGEP;
            } else if (supportsBH) {
                retGGEPBlock = this._bhGGEP;
            } else if (isMulticastResponse) {
                retGGEPBlock = this._mcGGEP;
            }
            return retGGEPBlock;
        }

        public Set getPushProxies(GGEP ggep) {
            IpPortSet proxies = null;
            if (ggep.hasKey("PUSH")) {
                try {
                    byte[] proxyBytes = ggep.getBytes("PUSH");
                    ByteArrayInputStream bais = new ByteArrayInputStream(proxyBytes);
                    while (bais.available() > 0) {
                        byte[] combo = new byte[6];
                        if (bais.read(combo, 0, combo.length) != combo.length) continue;
                        try {
                            if (proxies == null) {
                                proxies = new IpPortSet();
                            }
                            proxies.add(IPPortCombo.getCombo(combo));
                        }
                        catch (BadPacketException malformedPair) {}
                    }
                }
                catch (BadGGEPPropertyException badGGEPPropertyException) {
                    // empty catch block
                }
            }
            if (proxies == null) {
                return Collections.EMPTY_SET;
            }
            return proxies;
        }
    }
}

