/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages;

import com.limegroup.gnutella.messages.SecureMessage;
import com.limegroup.gnutella.messages.SecureMessageCallback;
import com.limegroup.gnutella.security.SignatureVerifier;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.ProcessingQueue;
import java.io.File;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SecureMessageVerifier {
    private static final Log LOG = LogFactory.getLog(SecureMessageVerifier.class);
    private final ProcessingQueue QUEUE = new ProcessingQueue("SecureMessageVerifier");
    private PublicKey pubKey;

    public void verify(SecureMessage sm, SecureMessageCallback smc) {
        this.QUEUE.add(new Verifier(sm, smc));
    }

    private void initializePublicKey() {
        if (this.pubKey == null) {
            this.pubKey = this.createPublicKey();
        }
    }

    protected PublicKey createPublicKey() {
        return SignatureVerifier.readKey(this.getKeyFile(), "DSA");
    }

    protected File getKeyFile() {
        return new File(CommonUtils.getUserSettingsDir(), "secureMessage.key");
    }

    private void verifyMessage(SecureMessage message, SecureMessageCallback callback) {
        if (this.pubKey == null) {
            LOG.warn("Cannot verify message without a public key.");
            message.setSecureStatus(0);
            callback.handleSecureMessage(message, false);
            return;
        }
        byte[] signature = message.getSecureSignature();
        if (signature == null) {
            LOG.warn("Cannot verify message without a signature.");
            message.setSecureStatus(0);
            callback.handleSecureMessage(message, false);
            return;
        }
        try {
            Signature verifier = Signature.getInstance("SHA1withDSA");
            verifier.initVerify(this.pubKey);
            message.updateSignatureWithSecuredBytes(verifier);
            if (verifier.verify(signature)) {
                message.setSecureStatus(2);
                callback.handleSecureMessage(message, true);
                return;
            }
        }
        catch (NoSuchAlgorithmException nsax) {
            LOG.error("No alg.", nsax);
        }
        catch (InvalidKeyException ikx) {
            LOG.error("Invalid key", ikx);
        }
        catch (SignatureException sx) {
            LOG.error("Bad sig", sx);
        }
        catch (ClassCastException ccx) {
            LOG.error("bad cast", ccx);
        }
        message.setSecureStatus(1);
        callback.handleSecureMessage(message, false);
    }

    private class Verifier
    implements Runnable {
        private final SecureMessage message;
        private final SecureMessageCallback callback;

        Verifier(SecureMessage message, SecureMessageCallback callback) {
            this.message = message;
            this.callback = callback;
        }

        public void run() {
            SecureMessageVerifier.this.initializePublicKey();
            SecureMessageVerifier.this.verifyMessage(this.message, this.callback);
        }
    }
}

