/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.messages.BadGGEPBlockException;
import com.limegroup.gnutella.messages.BadGGEPPropertyException;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.GGEP;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class ContentRequest
extends VendorMessage {
    public static final int VERSION = 1;

    public ContentRequest(byte[] guid, byte ttl, byte hops, int version, byte[] payload) throws BadPacketException {
        super(guid, ttl, hops, F_LIME_VENDOR_ID, 28, version, payload);
        if (this.getPayload().length < 1) {
            throw new BadPacketException("UNSUPPORTED PAYLOAD LENGTH: " + this.getPayload().length);
        }
    }

    public ContentRequest(URN sha1) {
        super(F_LIME_VENDOR_ID, 28, 1, ContentRequest.derivePayload(sha1));
    }

    private static byte[] derivePayload(URN sha1) {
        if (sha1 == null) {
            throw new NullPointerException("null sha1");
        }
        GGEP ggep = new GGEP(true);
        ggep.put("S1", sha1.getBytes());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ggep.write(out);
        }
        catch (IOException iox) {
            ErrorService.error(iox);
        }
        return out.toByteArray();
    }

    public URN getURN() {
        try {
            GGEP ggep = new GGEP(this.getPayload(), 0);
            return URN.createSHA1UrnFromBytes(ggep.getBytes("S1"));
        }
        catch (BadGGEPBlockException e) {
        }
        catch (BadGGEPPropertyException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }
}

