/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.messages.BadGGEPBlockException;
import com.limegroup.gnutella.messages.BadGGEPPropertyException;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.GGEP;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class HeadPing
extends VendorMessage {
    public static final int VERSION = 1;
    public static final int PLAIN = 0;
    public static final int INTERVALS = 1;
    public static final int ALT_LOCS = 2;
    public static final int PUSH_ALTLOCS = 4;
    public static final int FWT_PUSH_ALTLOCS = 8;
    public static final int GGEP_PING = 16;
    private static final String GGEP_PUSH = "PUSH";
    public static final int FEATURE_MASK = 31;
    private final URN _urn;
    private final byte _features;
    private GGEP _ggep;
    private final GUID _clientGUID;

    protected HeadPing(byte[] guid, byte ttl, byte hops, int version, byte[] payload) throws BadPacketException {
        super(guid, ttl, hops, F_LIME_VENDOR_ID, 23, version, payload);
        if (this.getVersion() == 1 && (payload == null || payload.length < 42)) {
            throw new BadPacketException();
        }
        this._features = (byte)(payload[0] & 0x1F);
        String urnStr = new String(payload, 1, 41);
        if (!URN.isUrn(urnStr)) {
            throw new BadPacketException("udp head request did not contain an urn");
        }
        URN urn = null;
        try {
            urn = URN.createSHA1Urn(urnStr);
        }
        catch (IOException oops) {
            throw new BadPacketException("failed to parse an urn");
        }
        finally {
            this._urn = urn;
        }
        GGEP g = null;
        if ((this._features & 0x10) == 16) {
            if (payload.length < 43) {
                throw new BadPacketException("no ggep was found.");
            }
            try {
                g = new GGEP(payload, 42, null);
            }
            catch (BadGGEPBlockException bpx) {
                throw new BadPacketException("invalid ggep block");
            }
        }
        this._ggep = g;
        GUID clientGuid = null;
        if (this._ggep != null) {
            try {
                clientGuid = new GUID(this._ggep.getBytes(GGEP_PUSH));
            }
            catch (BadGGEPPropertyException noGuid) {
                // empty catch block
            }
        }
        this._clientGUID = clientGuid;
    }

    public HeadPing(GUID g, URN sha1, int features) {
        this(g, sha1, null, features);
    }

    public HeadPing(GUID g, URN sha1, GUID clientGUID, int features) {
        super(F_LIME_VENDOR_ID, 23, 1, HeadPing.derivePayload(sha1, clientGUID, features));
        this._features = (byte)(features & 0x1F);
        this._urn = sha1;
        this._clientGUID = clientGUID;
        this.setGUID(g);
    }

    public HeadPing(URN urn) {
        this(new GUID(GUID.makeGuid()), urn, 0);
    }

    public HeadPing(HeadPing original) {
        super(F_LIME_VENDOR_ID, 23, 1, original.getPayload());
        this._features = original.getFeatures();
        this._urn = original.getUrn();
        this._clientGUID = original.getClientGuid();
        this.setGUID(new GUID(original.getGUID()));
    }

    private static byte[] derivePayload(URN urn, GUID clientGUID, int features) {
        features &= 0x1F;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream daos = new DataOutputStream(baos);
        String urnStr = urn.httpStringValue();
        GGEP ggep = null;
        if (clientGUID != null) {
            features |= 0x10;
            ggep = new GGEP(true);
            ggep.put(GGEP_PUSH, clientGUID.bytes());
        }
        try {
            daos.writeByte(features);
            daos.writeBytes(urnStr);
            if (ggep != null) {
                ggep.write(daos);
            }
        }
        catch (IOException huh) {
            ErrorService.error(huh);
        }
        return baos.toByteArray();
    }

    public URN getUrn() {
        return this._urn;
    }

    public boolean requestsRanges() {
        return (this._features & 1) == 1;
    }

    public boolean requestsAltlocs() {
        return (this._features & 2) == 2;
    }

    public boolean requestsPushLocs() {
        return (this._features & 4) == 4;
    }

    public boolean requestsFWTPushLocs() {
        return (this._features & 8) == 8;
    }

    public byte getFeatures() {
        return this._features;
    }

    public GUID getClientGuid() {
        return this._clientGUID;
    }
}

