/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.IPPortCombo;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;

public final class PushProxyAcknowledgement
extends VendorMessage {
    public static final int VERSION = 2;
    private final InetAddress _addr;
    private final int _port;

    PushProxyAcknowledgement(byte[] guid, byte ttl, byte hops, int version, byte[] payload) throws BadPacketException {
        super(guid, ttl, hops, F_LIME_VENDOR_ID, 22, version, payload);
        if (this.getVersion() == 1) {
            throw new BadPacketException("DEPRECATED VERSION");
        }
        if (this.getVersion() > 2) {
            throw new BadPacketException("UNSUPPORTED VERSION");
        }
        if (this.getPayload().length != 6) {
            throw new BadPacketException("UNSUPPORTED PAYLOAD LENGTH: " + payload.length);
        }
        IPPortCombo combo = IPPortCombo.getCombo(this.getPayload());
        this._addr = combo.getInetAddress();
        this._port = combo.getPort();
    }

    public PushProxyAcknowledgement(InetAddress addr, int port) {
        super(F_LIME_VENDOR_ID, 22, 2, PushProxyAcknowledgement.derivePayload(addr, port));
        this._addr = addr;
        this._port = port;
    }

    public PushProxyAcknowledgement(InetAddress addr, int port, GUID guid) {
        super(F_LIME_VENDOR_ID, 22, 2, PushProxyAcknowledgement.derivePayload(addr, port));
        this._addr = addr;
        this._port = port;
        this.setGUID(guid);
    }

    public int getListeningPort() {
        return this._port;
    }

    public InetAddress getListeningAddress() {
        return this._addr;
    }

    private static byte[] derivePayload(InetAddress addr, int port) {
        try {
            IPPortCombo combo = new IPPortCombo(addr.getHostAddress(), port);
            return combo.toBytes();
        }
        catch (UnknownHostException uhe) {
            throw new IllegalArgumentException(uhe.getMessage());
        }
    }

    protected void writePayload(OutputStream out) throws IOException {
        super.writePayload(out);
    }

    public void recordDrop() {
        super.recordDrop();
    }
}

