/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.Connection;
import com.limegroup.gnutella.Constants;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.messages.IPPortCombo;
import com.limegroup.gnutella.messages.vendor.UDPCrawlerPing;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.GZIPOutputStream;

public class UDPCrawlerPong
extends VendorMessage {
    public static final int VERSION = 1;
    public static final String AGENT_SEP = ";";

    public UDPCrawlerPong(UDPCrawlerPing request) {
        super(F_LIME_VENDOR_ID, 6, 1, UDPCrawlerPong.derivePayload(request));
        this.setGUID(new GUID(request.getGUID()));
    }

    private static byte[] derivePayload(UDPCrawlerPing request) {
        Connection c;
        byte format = (byte)(request.getFormat() & 0x3F);
        List endpointsUP = new LinkedList<Connection>();
        List endpointsLeaf = new LinkedList<Connection>();
        Iterator iter = RouterService.getConnectionManager().getInitializedConnections().iterator();
        boolean newOnly = request.hasNewOnly();
        while (iter.hasNext()) {
            c = (Connection)iter.next();
            if (newOnly) {
                if (c.remoteHostSupportsUDPCrawling() < 1) continue;
                endpointsUP.add(c);
                continue;
            }
            if (!c.isGoodUltrapeer()) continue;
            endpointsUP.add(c);
        }
        iter = RouterService.getConnectionManager().getInitializedClientConnections().iterator();
        while (iter.hasNext()) {
            c = (Connection)iter.next();
            endpointsLeaf.add(c);
        }
        if (!request.hasLocaleInfo()) {
            if (request.getNumberUP() != -1 && request.getNumberUP() < endpointsUP.size()) {
                int index = (int)Math.floor(Math.random() * (double)(endpointsUP.size() - request.getNumberUP()));
                endpointsUP = endpointsUP.subList(index, index + request.getNumberUP());
            }
            if (request.getNumberLeaves() != -1 && request.getNumberLeaves() < endpointsLeaf.size()) {
                int index = (int)Math.floor(Math.random() * (double)(endpointsLeaf.size() - request.getNumberLeaves()));
                endpointsLeaf = endpointsLeaf.subList(index, index + request.getNumberLeaves());
            }
        } else {
            String myLocale = ApplicationSettings.LANGUAGE.getValue();
            List prefedcons = RouterService.getConnectionManager().getInitializedConnectionsMatchLocale(myLocale);
            endpointsUP.removeAll(prefedcons);
            prefedcons.addAll(endpointsUP);
            endpointsUP = prefedcons;
            prefedcons = RouterService.getConnectionManager().getInitializedClientConnectionsMatchLocale(myLocale);
            endpointsLeaf.removeAll(prefedcons);
            prefedcons.addAll(endpointsLeaf);
            endpointsLeaf = prefedcons;
            if (request.getNumberUP() != -1 && request.getNumberUP() < endpointsUP.size()) {
                endpointsUP = endpointsUP.subList(0, request.getNumberUP());
            }
            if (request.getNumberLeaves() != -1 && request.getNumberLeaves() < endpointsLeaf.size()) {
                endpointsLeaf = endpointsLeaf.subList(0, request.getNumberLeaves());
            }
        }
        int bytesPerResult = 6;
        if (request.hasConnectionTime()) {
            bytesPerResult += 2;
        }
        if (request.hasLocaleInfo()) {
            bytesPerResult += 2;
        }
        if (request.hasReplies()) {
            bytesPerResult += 4;
        }
        int index = request.hasNodeUptime() ? 7 : 3;
        byte[] result = new byte[(endpointsUP.size() + endpointsLeaf.size()) * bytesPerResult + index];
        result[0] = (byte)endpointsUP.size();
        result[1] = (byte)endpointsLeaf.size();
        result[2] = format;
        if (request.hasNodeUptime()) {
            long currentAverage = RouterService.getConnectionManager().getCurrentAverageUptime() / 1000L;
            if (currentAverage > Integer.MAX_VALUE) {
                currentAverage = Integer.MAX_VALUE;
            }
            ByteOrder.int2leb((int)currentAverage, result, 3);
        }
        endpointsUP.addAll(endpointsLeaf);
        long now = System.currentTimeMillis();
        iter = endpointsUP.iterator();
        while (iter.hasNext()) {
            ManagedConnection c2 = (ManagedConnection)iter.next();
            System.arraycopy(UDPCrawlerPong.packIPAddress(c2.getInetAddress(), c2.getPort()), 0, result, index, 6);
            index += 6;
            if (request.hasConnectionTime()) {
                long uptime = now - c2.getConnectionTime();
                short packed = (short)(uptime / Constants.MINUTE);
                ByteOrder.short2leb(packed, result, index);
                index += 2;
            }
            if (request.hasLocaleInfo()) {
                System.arraycopy(c2.getLocalePref().getBytes(), 0, result, index, 2);
                index += 2;
            }
            if (!request.hasReplies()) continue;
            ByteOrder.int2leb(ByteOrder.long2int(c2.getNumQueryReplies()), result, index);
            index += 4;
        }
        if (request.hasUserAgent()) {
            StringBuffer agents = new StringBuffer();
            iter = endpointsUP.iterator();
            while (iter.hasNext()) {
                Connection c3 = (Connection)iter.next();
                String agent = c3.getUserAgent();
                agent = StringUtils.replace(agent, AGENT_SEP, "\\;");
                agents.append(agent).append(AGENT_SEP);
            }
            agents.append(CommonUtils.getHttpServer());
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                GZIPOutputStream zout = new GZIPOutputStream(baos);
                byte[] length = new byte[2];
                ByteOrder.short2leb((short)agents.length(), length, 0);
                zout.write(length);
                zout.write(agents.toString().getBytes());
                zout.flush();
                zout.close();
            }
            catch (IOException huh) {
                ErrorService.error(huh);
            }
            byte[] agentsB = baos.toByteArray();
            byte[] resTemp = result;
            result = new byte[result.length + agentsB.length + 2];
            System.arraycopy(resTemp, 0, result, 0, resTemp.length);
            ByteOrder.short2leb((short)agentsB.length, result, resTemp.length);
            System.arraycopy(agentsB, 0, result, resTemp.length + 2, agentsB.length);
        }
        return result;
    }

    private static byte[] packIPAddress(InetAddress addr, int port) {
        try {
            IPPortCombo combo = new IPPortCombo(addr.getHostAddress(), port);
            return combo.toBytes();
        }
        catch (UnknownHostException uhe) {
            throw new IllegalArgumentException(uhe.getMessage());
        }
    }
}

