/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.statistics.ReceivedErrorStat;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public abstract class VendorMessage
extends Message {
    public static final int F_MESSAGES_SUPPORTED = 0;
    public static final int F_HOPS_FLOW = 4;
    public static final int F_TCP_CONNECT_BACK = 7;
    public static final int F_UDP_CONNECT_BACK = 7;
    public static final int F_UDP_CONNECT_BACK_REDIR = 8;
    public static final int F_CAPABILITIES = 10;
    public static final int F_LIME_ACK = 11;
    public static final int F_REPLY_NUMBER = 12;
    public static final int F_PUSH_PROXY_REQ = 21;
    public static final int F_PUSH_PROXY_ACK = 22;
    public static final int F_GIVE_STATS = 14;
    public static final int F_STATISTICS = 15;
    public static final int F_CRAWLER_PING = 5;
    public static final int F_CRAWLER_PONG = 6;
    public static final int F_SIMPP_REQ = 16;
    public static final int F_SIMPP = 17;
    public static final int F_UDP_HEAD_PING = 23;
    public static final int F_UDP_HEAD_PONG = 24;
    public static final int F_HEADER_UPDATE = 25;
    public static final int F_UPDATE_REQ = 26;
    public static final int F_UPDATE_RESP = 27;
    public static final int F_CONTENT_REQ = 28;
    public static final int F_CONTENT_RESP = 29;
    public static final byte[] F_LIME_VENDOR_ID = new byte[]{76, 73, 77, 69};
    public static final byte[] F_BEAR_VENDOR_ID = new byte[]{66, 69, 65, 82};
    public static final byte[] F_GTKG_VENDOR_ID = new byte[]{71, 84, 75, 71};
    public static final byte[] F_NULL_VENDOR_ID = new byte[]{0, 0, 0, 0};
    static final int LENGTH_MINUS_PAYLOAD = 8;
    private final byte[] _vendorID;
    private final int _selector;
    private final int _version;
    private final byte[] _payload;
    private final int _hashCode;

    protected VendorMessage(byte[] vendorIDBytes, int selector, int version, byte[] payload) {
        this(vendorIDBytes, selector, version, payload, -1);
    }

    protected VendorMessage(byte[] vendorIDBytes, int selector, int version, byte[] payload, int network) {
        super((byte)49, (byte)1, 8 + payload.length, network);
        if (vendorIDBytes.length != 4) {
            throw new IllegalArgumentException("wrong vendorID length: " + vendorIDBytes.length);
        }
        if ((selector & 0xFFFF0000) != 0) {
            throw new IllegalArgumentException("invalid selector: " + selector);
        }
        if ((version & 0xFFFF0000) != 0) {
            throw new IllegalArgumentException("invalid version: " + version);
        }
        this._vendorID = vendorIDBytes;
        this._selector = selector;
        this._version = version;
        this._payload = payload;
        this._hashCode = VendorMessage.computeHashCode(this._version, this._selector, this._vendorID, this._payload);
    }

    protected VendorMessage(byte[] guid, byte ttl, byte hops, byte[] vendorID, int selector, int version, byte[] payload) throws BadPacketException {
        this(guid, ttl, hops, vendorID, selector, version, payload, -1);
    }

    protected VendorMessage(byte[] guid, byte ttl, byte hops, byte[] vendorID, int selector, int version, byte[] payload, int network) throws BadPacketException {
        super(guid, (byte)49, ttl, hops, 8 + payload.length, network);
        if (vendorID.length != 4) {
            ReceivedErrorStat.VENDOR_INVALID_ID.incrementStat();
            throw new BadPacketException("Vendor ID Invalid!");
        }
        if ((selector & 0xFFFF0000) != 0) {
            ReceivedErrorStat.VENDOR_INVALID_SELECTOR.incrementStat();
            throw new BadPacketException("Selector Invalid!");
        }
        if ((version & 0xFFFF0000) != 0) {
            ReceivedErrorStat.VENDOR_INVALID_VERSION.incrementStat();
            throw new BadPacketException("Version Invalid!");
        }
        this._vendorID = vendorID;
        this._selector = selector;
        this._version = version;
        this._payload = payload;
        this._hashCode = VendorMessage.computeHashCode(this._version, this._selector, this._vendorID, this._payload);
    }

    private static int computeHashCode(int version, int selector, byte[] vendorID, byte[] payload) {
        int i;
        int hashCode = 0;
        hashCode += 17 * version;
        hashCode += 17 * selector;
        for (i = 0; i < vendorID.length; ++i) {
            hashCode += 17 * vendorID[i];
        }
        for (i = 0; i < payload.length; ++i) {
            hashCode += 17 * payload[i];
        }
        return hashCode;
    }

    protected byte[] getPayload() {
        return this._payload;
    }

    protected int getVersion() {
        return this._version;
    }

    public boolean equals(Object other) {
        if (other instanceof VendorMessage) {
            VendorMessage vmp = (VendorMessage)other;
            return this._selector == vmp._selector && Arrays.equals(this._vendorID, vmp._vendorID) && Arrays.equals(this._payload, vmp._payload);
        }
        return false;
    }

    public int hashCode() {
        return this._hashCode;
    }

    protected void writePayload(OutputStream out) throws IOException {
        out.write(this._vendorID);
        ByteOrder.short2leb((short)this._selector, out);
        ByteOrder.short2leb((short)this._version, out);
        out.write(this.getPayload());
    }

    public Message stripExtendedPayload() {
        return this;
    }

    public void recordDrop() {
    }
}

