/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.metadata;

import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.metadata.WRMXML;
import com.limegroup.gnutella.metadata.WeedInfo;
import com.limegroup.gnutella.util.CountingInputStream;
import com.limegroup.gnutella.util.IOUtils;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class ASFParser {
    private static final Log LOG = LogFactory.getLog(ASFParser.class);
    private static final int TYPE_STRING = 0;
    private static final int TYPE_BINARY = 1;
    private static final int TYPE_BOOLEAN = 2;
    private static final int TYPE_INT = 3;
    private static final int TYPE_LONG = 4;
    private String _album;
    private String _artist;
    private String _title;
    private String _year;
    private String _copyright;
    private String _rating;
    private String _genre;
    private String _comment;
    private String _drmType;
    private short _track = (short)-1;
    private int _bitrate = -1;
    private int _length = -1;
    private int _width = -1;
    private int _height = -1;
    private boolean _hasAudio;
    private boolean _hasVideo;
    private WeedInfo _weed;
    private WRMXML _wrmdata;

    String getAlbum() {
        return this._album;
    }

    String getArtist() {
        return this._artist;
    }

    String getTitle() {
        return this._title;
    }

    String getYear() {
        return this._year;
    }

    String getCopyright() {
        return this._copyright;
    }

    String getRating() {
        return this._rating;
    }

    String getGenre() {
        return this._genre;
    }

    String getComment() {
        return this._comment;
    }

    short getTrack() {
        return this._track;
    }

    int getBitrate() {
        return this._bitrate;
    }

    int getLength() {
        return this._length;
    }

    int getWidth() {
        return this._width;
    }

    int getHeight() {
        return this._height;
    }

    WeedInfo getWeedInfo() {
        return this._weed;
    }

    WRMXML getWRMXML() {
        return this._wrmdata;
    }

    boolean hasAudio() {
        return this._hasAudio;
    }

    boolean hasVideo() {
        return this._hasVideo;
    }

    String getLicenseInfo() {
        if (this._weed != null) {
            return this._weed.getLicenseInfo();
        }
        if (this._wrmdata != null && this._drmType != null) {
            return "licensed: " + this._drmType;
        }
        return null;
    }

    ASFParser(File f) throws IOException {
        this.parseFile(f);
    }

    protected void parseFile(File f) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Parsing file: " + f);
        }
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(f));
            this.parse(is);
        }
        catch (IOException iox) {
            try {
                LOG.warn("IOX while parsing", iox);
                throw iox;
            }
            catch (Throwable throwable) {
                IOUtils.close(is);
                throw throwable;
            }
        }
        IOUtils.close(is);
    }

    private void parse(InputStream is) throws IOException {
        CountingInputStream counter = new CountingInputStream(is);
        DataInputStream ds = new DataInputStream(counter);
        byte[] marker = new byte[IDs.HEADER_ID.length];
        ds.readFully(marker);
        if (!Arrays.equals(marker, IDs.HEADER_ID)) {
            throw new IOException("not an ASF file");
        }
        long dataOffset = ByteOrder.leb2long(ds);
        int objectCount = ByteOrder.leb2int(ds);
        IOUtils.ensureSkip(ds, 2L);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Data Offset: " + dataOffset + ", objectCount: " + objectCount);
        }
        if (dataOffset < 0L) {
            throw new IOException("ASF file is corrupt. Data offset negative:" + dataOffset);
        }
        if (objectCount < 0) {
            throw new IOException("ASF file is corrupt. Object count unreasonable:" + ByteOrder.uint2long(objectCount));
        }
        if (objectCount > 100) {
            throw new IOException("object count very high: " + objectCount);
        }
        byte[] object = new byte[16];
        for (int i = 0; i < objectCount; ++i) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Parsing object[" + i + "]");
            }
            ds.readFully(object);
            long size = ByteOrder.leb2long(ds) - 24L;
            if (size < 0L) {
                throw new IOException("ASF file is corrupt.  Object size < 0 :" + size);
            }
            counter.clearAmountRead();
            this.readObject(ds, object, size);
            int read = counter.getAmountRead();
            if ((long)read > size) {
                throw new IOException("read (" + read + ") more than size (" + size + ")");
            }
            if ((long)read == size) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Skipping to next object.  Read: " + read + ", size: " + size);
            }
            IOUtils.ensureSkip(ds, size - (long)read);
        }
    }

    private void readObject(DataInputStream ds, byte[] id, long size) throws IOException {
        if (Arrays.equals(id, IDs.FILE_PROPERTIES_ID)) {
            this.parseFileProperties(ds);
        } else if (Arrays.equals(id, IDs.STREAM_PROPERTIES_ID)) {
            this.parseStreamProperties(ds);
        } else if (Arrays.equals(id, IDs.EXTENDED_STREAM_PROPERTIES_ID)) {
            this.parseExtendedStreamProperties(ds);
        } else if (Arrays.equals(id, IDs.CONTENT_DESCRIPTION_ID)) {
            this.parseContentDescription(ds);
        } else if (Arrays.equals(id, IDs.EXTENDED_CONTENT_DESCRIPTION_ID)) {
            this.parseExtendedContentDescription(ds);
        } else if (Arrays.equals(id, IDs.CONTENT_ENCRYPTION_ID)) {
            this.parseContentEncryption(ds);
        } else if (Arrays.equals(id, IDs.EXTENDED_CONTENT_ENCRYPTION_ID)) {
            this.parseExtendedContentEncryption(ds);
        } else {
            LOG.debug("Unknown Object, ignoring.");
        }
    }

    private void parseFileProperties(DataInputStream ds) throws IOException {
        LOG.debug("Parsing file properties");
        IOUtils.ensureSkip(ds, 48L);
        int duration = (int)(ByteOrder.leb2long(ds) / 10000000L);
        if (duration < 0) {
            throw new IOException("ASF file corrupt.  Duration < 0:" + duration);
        }
        this._length = duration;
        IOUtils.ensureSkip(ds, 20L);
        int maxBR = ByteOrder.leb2int(ds);
        if (maxBR < 0) {
            throw new IOException("ASF file corrupt.  Max bitrate > 2 Gb/s:" + ByteOrder.uint2long(maxBR));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("maxBitrate: " + maxBR);
        }
        this._bitrate = maxBR / 1000;
    }

    private void parseStreamProperties(DataInputStream ds) throws IOException {
        LOG.debug("Parsing stream properties");
        byte[] streamID = new byte[16];
        ds.readFully(streamID);
        if (Arrays.equals(streamID, IDs.AUDIO_STREAM_ID)) {
            this._hasAudio = true;
        } else if (Arrays.equals(streamID, IDs.VIDEO_STREAM_ID)) {
            this._hasVideo = true;
            IOUtils.ensureSkip(ds, 38L);
            this._width = ByteOrder.leb2int(ds);
            if (this._width < 0) {
                throw new IOException("ASF file corrupt.  Video width excessive:" + ByteOrder.uint2long(this._width));
            }
            this._height = ByteOrder.leb2int(ds);
            if (this._height < 0) {
                throw new IOException("ASF file corrupt.  Video height excessive:" + ByteOrder.uint2long(this._height));
            }
        }
    }

    private void parseExtendedStreamProperties(DataInputStream ds) throws IOException {
        LOG.debug("Parsing extended stream properties");
        IOUtils.ensureSkip(ds, 56L);
        int channels = ByteOrder.ushort2int(ByteOrder.leb2short(ds));
        int sampleRate = ByteOrder.leb2int(ds);
        if (sampleRate < 0) {
            throw new IOException("ASF file corrupt.  Sample rate excessive:" + ByteOrder.uint2long(sampleRate));
        }
        int byteRate = ByteOrder.leb2int(ds);
        if (byteRate < 0) {
            throw new IOException("ASF file corrupt.  Byte rate excessive:" + ByteOrder.uint2long(byteRate));
        }
        if (this._bitrate == -1) {
            this._bitrate = byteRate * 8 / 1000;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("channels: " + channels + ", sampleRate: " + sampleRate + ", byteRate: " + byteRate + ", bitRate: " + this._bitrate);
        }
    }

    private void parseContentEncryption(DataInputStream ds) throws IOException {
        LOG.debug("Parsing content encryption");
        long skipSize = ByteOrder.uint2long(ByteOrder.leb2int(ds));
        IOUtils.ensureSkip(ds, skipSize);
        int typeSize = ByteOrder.leb2int(ds);
        if (typeSize < 0) {
            throw new IOException("ASF file is corrupt.  Type size < 0: " + typeSize);
        }
        byte[] b = new byte[typeSize];
        ds.readFully(b);
        this._drmType = new String(b).trim();
        skipSize = ByteOrder.uint2long(ByteOrder.leb2int(ds));
        IOUtils.ensureSkip(ds, skipSize);
        skipSize = ByteOrder.uint2long(ByteOrder.leb2int(ds));
        IOUtils.ensureSkip(ds, skipSize);
    }

    private void parseExtendedContentEncryption(DataInputStream ds) throws IOException {
        LOG.debug("Parsing extended content encryption");
        int size = ByteOrder.leb2int(ds);
        if (size < 0) {
            throw new IOException("ASF file reports excessive length of encryption data:" + ByteOrder.uint2long(size));
        }
        byte[] b = new byte[size];
        ds.readFully(b);
        String xml = new String(b, "UTF-16").trim();
        WRMXML wrmdata = new WRMXML(xml);
        if (!wrmdata.isValid()) {
            LOG.debug("WRM Data is invalid.");
            return;
        }
        this._wrmdata = wrmdata;
        WeedInfo weed = new WeedInfo(wrmdata);
        if (weed.isValid()) {
            LOG.debug("Parsed weed data.");
            this._weed = weed;
            this._wrmdata = weed;
            if (this._weed.getAuthor() != null) {
                this._artist = this._weed.getAuthor();
            }
            if (this._weed.getTitle() != null) {
                this._title = this._weed.getTitle();
            }
            if (this._weed.getDescription() != null) {
                this._comment = this._weed.getDescription();
            }
            if (this._weed.getCollection() != null) {
                this._album = this._weed.getCollection();
            }
            if (this._weed.getCopyright() != null) {
                this._copyright = this._weed.getCopyright();
            }
            return;
        }
    }

    private void parseContentDescription(DataInputStream ds) throws IOException {
        int i;
        LOG.debug("Parsing Content Description");
        int[] sizes = new int[]{-1, -1, -1, -1, -1};
        for (int i2 = 0; i2 < sizes.length; ++i2) {
            sizes[i2] = ByteOrder.ushort2int(ByteOrder.leb2short(ds));
        }
        byte[][] info = new byte[5][];
        for (i = 0; i < sizes.length; ++i) {
            info[i] = new byte[sizes[i]];
        }
        for (i = 0; i < info.length; ++i) {
            ds.readFully(info[i]);
        }
        this._title = this.string(info[0]);
        this._artist = this.string(info[1]);
        this._copyright = this.string(info[2]);
        this._comment = this.string(info[3]);
        this._rating = this.string(info[4]);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Standard Tag Values.  Title: " + this._title + ", Author: " + this._artist + ", Copyright: " + this._copyright + ", Description: " + this._comment + ", Rating: " + this._rating);
        }
    }

    private void parseExtendedContentDescription(DataInputStream ds) throws IOException {
        LOG.debug("Parsing extended content description");
        int fieldCount = ByteOrder.ushort2int(ByteOrder.leb2short(ds));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Extended fieldCount: " + fieldCount);
        }
        block7: for (int i = 0; i < fieldCount; ++i) {
            int fieldSize = ByteOrder.ushort2int(ByteOrder.leb2short(ds));
            byte[] field = new byte[fieldSize];
            ds.readFully(field);
            String fieldName = this.string(field);
            int dataType = ByteOrder.ushort2int(ByteOrder.leb2short(ds));
            int dataSize = ByteOrder.ushort2int(ByteOrder.leb2short(ds));
            switch (dataType) {
                case 0: {
                    this.parseExtendedString(fieldName, dataSize, ds);
                    continue block7;
                }
                case 1: {
                    this.parseExtendedBinary(fieldName, dataSize, ds);
                    continue block7;
                }
                case 2: {
                    this.parseExtendedBoolean(fieldName, dataSize, ds);
                    continue block7;
                }
                case 3: {
                    this.parseExtendedInt(fieldName, dataSize, ds);
                    continue block7;
                }
                case 4: {
                    this.parseExtendedInt(fieldName, dataSize, ds);
                    continue block7;
                }
                default: {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Unknown dataType: " + dataType + " for field: " + fieldName);
                    }
                    IOUtils.ensureSkip(ds, dataSize);
                }
            }
        }
    }

    private void parseExtendedString(String field, int size, DataInputStream ds) throws IOException {
        byte[] data = new byte[Math.min(250, size)];
        ds.readFully(data);
        int leftover = Math.max(0, size - 250);
        IOUtils.ensureSkip(ds, leftover);
        String info = this.string(data);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Parsing extended String.  field: " + field + ", Value: " + info);
        }
        if ("WM/Title".equals(field)) {
            if (this._title == null) {
                this._title = info;
            }
        } else if ("WM/Author".equals(field)) {
            if (this._artist == null) {
                this._artist = info;
            }
        } else if ("WM/AlbumTitle".equals(field)) {
            if (this._album == null) {
                this._album = info;
            }
        } else if ("WM/TrackNumber".equals(field)) {
            if (this._track == -1) {
                this._track = this.toShort(info);
            }
        } else if ("WM/Year".equals(field)) {
            if (this._year == null) {
                this._year = info;
            }
        } else if ("WM/Genre".equals(field)) {
            if (this._genre == null) {
                this._genre = info;
            }
        } else if ("WM/Description".equals(field) && this._comment == null) {
            this._comment = info;
        }
    }

    private void parseExtendedBoolean(String field, int size, DataInputStream ds) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Ignoring boolean field: " + field + ", size: " + size);
        }
        IOUtils.ensureSkip(ds, size);
    }

    private void parseExtendedInt(String field, int size, DataInputStream ds) throws IOException {
        if (size != 4) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Int field size != 4, ignoring.   Field: " + field + ", size: " + size);
            }
            IOUtils.ensureSkip(ds, size);
            return;
        }
        int value = ByteOrder.leb2int(ds);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Parsing extended int, field: " + field + ", size: " + size + ", value: " + value);
        }
        if ("WM/TrackNumber".equals(field) && this._track == -1) {
            short shortValue = (short)value;
            if (shortValue < 0) {
                throw new IOException("ASF file reports negative track number " + shortValue);
            }
            this._track = shortValue;
        }
    }

    private void parseExtendedBinary(String field, int size, DataInputStream ds) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Ignoring binary field: " + field + ", size: " + size);
        }
        IOUtils.ensureSkip(ds, size);
    }

    private void parseExtendedLong(String field, int size, DataInputStream ds) throws IOException {
        if (size != 8) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Long field size != 8, ignoring.   Field: " + field + ", size: " + size);
            }
            IOUtils.ensureSkip(ds, size);
            return;
        }
        long value = ByteOrder.leb2long(ds);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Ignoring long field: " + field + ", size: " + size + ", value: " + value);
        }
    }

    private short toShort(String x) {
        try {
            return Short.parseShort(x);
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    private String string(byte[] x) throws IOException {
        if (x == null) {
            return null;
        }
        try {
            return new String(x, "UTF-16LE").trim();
        }
        catch (UnsupportedEncodingException uee) {
            int pos = 0;
            for (int i = 0; i < x.length; ++i) {
                if (x[i] == 0) continue;
                x[pos++] = x[i];
            }
            return new String(x, 0, pos, "UTF-8");
        }
    }

    private static class Extended {
        private static final String WM_TITLE = "WM/Title";
        private static final String WM_AUTHOR = "WM/Author";
        private static final String WM_ALBUMTITLE = "WM/AlbumTitle";
        private static final String WM_TRACK = "WM/Track";
        private static final String WM_TRACK_NUMBER = "WM/TrackNumber";
        private static final String WM_YEAR = "WM/Year";
        private static final String WM_GENRE = "WM/Genre";
        private static final String WM_DESCRIPTION = "WM/Description";
        private static final String WM_LYRICS = "WM/Lyrics";
        private static final String VBR = "IsVBR";
        private static final String WM_UNIQUE_FILE_IDENTIFIER = "WM/UniqueFileIdentifier";
        private static final String WM_ALBUMARTIST = "WM/AlbumArtist";
        private static final String ID3 = "ID3";
        private static final String WM_PROVIDER = "WM/Provider";
        private static final String WM_PROVIDER_RATING = "WM/ProviderRating";
        private static final String WM_PUBLISHER = "WM/Publisher";
        private static final String WM_COMPOSER = "WM/Composer";
        private static final String WM_ENCODING_TIME = "WM/EncodingTime";

        private Extended() {
        }
    }

    private static class IDs {
        private static final byte[] HEADER_ID = new byte[]{48, 38, -78, 117, -114, 102, -49, 17, -90, -39, 0, -86, 0, 98, -50, 108};
        private static final byte[] FILE_PROPERTIES_ID = new byte[]{-95, -36, -85, -116, 71, -87, -49, 17, -114, -28, 0, -64, 12, 32, 83, 101};
        private static final byte[] STREAM_PROPERTIES_ID = new byte[]{-111, 7, -36, -73, -73, -87, -49, 17, -114, -26, 0, -64, 12, 32, 83, 101};
        private static final byte[] EXTENDED_STREAM_PROPERTIES_ID = new byte[]{-53, -91, -26, 20, 114, -58, 50, 67, -125, -103, -87, 105, 82, 6, 91, 90};
        private static final byte[] CONTENT_DESCRIPTION_ID = new byte[]{51, 38, -78, 117, -114, 102, -49, 17, -90, -39, 0, -86, 0, 98, -50, 108};
        private static final byte[] EXTENDED_CONTENT_DESCRIPTION_ID = new byte[]{64, -92, -48, -46, 7, -29, -46, 17, -105, -16, 0, -96, -55, 94, -88, 80};
        private static final byte[] CONTENT_ENCRYPTION_ID = new byte[]{-5, -77, 17, 34, 35, -67, -46, 17, -76, -73, 0, -96, -55, 85, -4, 110};
        private static final byte[] EXTENDED_CONTENT_ENCRYPTION_ID = new byte[]{20, -26, -118, 41, 34, 38, 23, 76, -71, 53, -38, -32, 126, -23, 40, -100};
        private static final byte[] CODEC_LIST_ID = new byte[]{64, 82, -47, -122, 29, 49, -48, 17, -93, -92, 0, -96, -55, 3, 72, -10};
        private static final byte[] AUDIO_STREAM_ID = new byte[]{64, -98, 105, -8, 77, 91, -49, 17, -88, -3, 0, -128, 95, 92, 68, 43};
        private static final byte[] VIDEO_STREAM_ID = new byte[]{-64, -17, 25, -68, 77, 91, -49, 17, -88, -3, 0, -128, 95, 92, 68, 43};

        private IDs() {
        }
    }
}

