/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.metadata;

import com.limegroup.gnutella.metadata.FLACMetaData;
import com.limegroup.gnutella.metadata.M4AMetaData;
import com.limegroup.gnutella.metadata.MP3MetaData;
import com.limegroup.gnutella.metadata.MetaData;
import com.limegroup.gnutella.metadata.OGGMetaData;
import com.limegroup.gnutella.metadata.WMAMetaData;
import com.limegroup.gnutella.util.NameValue;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AudioMetaData
extends MetaData {
    private String title;
    private String artist;
    private String album;
    private String year;
    private String comment;
    private short track = (short)-1;
    private String genre;
    private int bitrate = -1;
    private int length = -1;
    private short totalTracks = (short)-1;
    private short disk = (short)-1;
    private short totalDisks = (short)-1;
    private String license;
    private String price;
    private String licensetype;
    public static final String ISO_LATIN_1 = "8859_1";
    public static final String UNICODE = "Unicode";
    public static String schemaURI = "http://www.limewire.com/schemas/audio.xsd";
    private static final String DLM = "__";
    private static final String KPX = "audios__audio__";
    public static final String TRACK_KEY = "audios__audio__track__";
    public static final String ARTIST_KEY = "audios__audio__artist__";
    public static final String ALBUM_KEY = "audios__audio__album__";
    public static final String TITLE_KEY = "audios__audio__title__";
    public static final String GENRE_KEY = "audios__audio__genre__";
    public static final String YEAR_KEY = "audios__audio__year__";
    public static final String COMMENTS_KEY = "audios__audio__comments__";
    public static final String BITRATE_KEY = "audios__audio__bitrate__";
    public static final String SECONDS_KEY = "audios__audio__seconds__";
    public static final String LICENSE_KEY = "audios__audio__license__";
    public static final String PRICE_KEY = "audios__audio__price__";
    public static final String LICENSE_TYPE_KEY = "audios__audio__licensetype__";

    protected AudioMetaData() throws IOException {
    }

    public AudioMetaData(File f) throws IOException {
        this.parseFile(f);
    }

    public static AudioMetaData parseAudioFile(File f) throws IOException {
        if (LimeXMLUtils.isMP3File(f)) {
            return new MP3MetaData(f);
        }
        if (LimeXMLUtils.isOGGFile(f)) {
            return new OGGMetaData(f);
        }
        if (LimeXMLUtils.isFLACFile(f)) {
            return new FLACMetaData(f);
        }
        if (LimeXMLUtils.isM4AFile(f)) {
            return new M4AMetaData(f);
        }
        if (LimeXMLUtils.isWMAFile(f)) {
            return new WMAMetaData(f);
        }
        return null;
    }

    public String getSchemaURI() {
        return schemaURI;
    }

    public String toString() {
        return "ID3Data: title[" + this.title + "], artist[" + this.artist + "], album[" + this.album + "], year[" + this.year + "], comment[" + this.comment + "], track[" + this.track + "], genre[" + this.genre + "], bitrate[" + this.bitrate + "], length[" + this.length + "], license[" + this.license + "], price[" + this.price + "], licensetype[" + this.licensetype + "]";
    }

    public String getTitle() {
        return this.title;
    }

    public String getArtist() {
        return this.artist;
    }

    public String getAlbum() {
        return this.album;
    }

    public String getYear() {
        return this.year;
    }

    public String getComment() {
        return this.comment;
    }

    public short getTrack() {
        return this.track;
    }

    public short getTotalTracks() {
        return this.totalTracks;
    }

    public short getDisk() {
        return this.disk;
    }

    public short getTotalDisks() {
        return this.totalDisks;
    }

    public String getGenre() {
        return this.genre;
    }

    public int getBitrate() {
        return this.bitrate;
    }

    public int getLength() {
        return this.length;
    }

    public String getLicense() {
        return this.license;
    }

    public String getLicenseType() {
        return this.licensetype;
    }

    void setPrice(String price) {
        this.price = price;
    }

    void setTitle(String title) {
        this.title = title;
    }

    void setArtist(String artist) {
        this.artist = artist;
    }

    void setAlbum(String album) {
        this.album = album;
    }

    void setYear(String year) {
        this.year = year;
    }

    void setComment(String comment) {
        this.comment = comment;
    }

    void setTrack(short track) {
        this.track = track;
    }

    void setTotalTracks(short total) {
        this.totalTracks = total;
    }

    void setDisk(short disk) {
        this.disk = disk;
    }

    void setTotalDisks(short total) {
        this.totalDisks = total;
    }

    void setGenre(String genre) {
        this.genre = genre;
    }

    void setBitrate(int bitrate) {
        this.bitrate = bitrate;
    }

    void setLength(int length) {
        this.length = length;
    }

    void setLicense(String license) {
        this.license = license;
    }

    void setLicenseType(String licensetype) {
        this.licensetype = licensetype;
    }

    public boolean isComplete() {
        return this.isValid(this.title) && this.isValid(this.artist) && this.isValid(this.album) && this.isValid(this.year) && this.isValid(this.comment) && this.isValid(this.track) && this.isValid(this.genre) && this.isValid(this.bitrate) && this.isValid(this.length) && this.isValid(this.license) && this.isValid(this.licensetype);
    }

    public List toNameValueList() {
        ArrayList list = new ArrayList();
        this.add(list, this.title, TITLE_KEY);
        this.add(list, this.artist, ARTIST_KEY);
        this.add(list, this.album, ALBUM_KEY);
        this.add(list, this.year, YEAR_KEY);
        this.add(list, this.comment, COMMENTS_KEY);
        this.add(list, this.track, TRACK_KEY);
        this.add(list, this.genre, GENRE_KEY);
        this.add(list, this.bitrate, BITRATE_KEY);
        this.add(list, this.length, SECONDS_KEY);
        this.add(list, this.license, LICENSE_KEY);
        this.add(list, this.licensetype, LICENSE_TYPE_KEY);
        return list;
    }

    private void add(List list, String value, String key) {
        if (this.isValid(value)) {
            list.add(new NameValue(key, value.trim()));
        }
    }

    private void add(List list, int value, String key) {
        if (this.isValid(value)) {
            list.add(new NameValue(key, "" + value));
        }
    }

    private boolean isValid(String s) {
        return s != null && !s.trim().equals("");
    }

    private boolean isValid(int i) {
        return i >= 0;
    }

    protected void appendStrings(String key, String value, StringBuffer appendTo) {
        appendTo.append(key);
        appendTo.append(value);
        appendTo.append("\"");
    }

    protected int getTrimmedLength(byte[] bytes, int includedLength) {
        int i;
        for (i = includedLength - 1; i >= 0 && (bytes[i] == 0 || bytes[i] == 32); --i) {
        }
        for (int j = 0; j <= i; ++j) {
            if (bytes[j] != 0) continue;
            bytes[j] = 32;
        }
        return i + 1;
    }

    public static boolean isCorrupted(LimeXMLDocument doc) {
        if (!schemaURI.equals(doc.getSchemaURI())) {
            return false;
        }
        Set existing = doc.getNameValueSet();
        Iterator i = existing.iterator();
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!name.equals(ALBUM_KEY) && !name.equals(ARTIST_KEY) || value.length() != 30 || value.charAt(29) == ' ' || value.charAt(28) != ' ') continue;
            return true;
        }
        return false;
    }

    public static LimeXMLDocument fixCorruption(LimeXMLDocument oldDoc) {
        Set existing = oldDoc.getNameValueSet();
        ArrayList<NameValue> info = new ArrayList<NameValue>(existing.size());
        Iterator i = existing.iterator();
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            if ((name.equals(ALBUM_KEY) || name.equals(ARTIST_KEY)) && value.length() == 30 && value.charAt(29) != ' ' && value.charAt(28) == ' ') {
                value = value.substring(0, 29).trim();
            }
            info.add(new NameValue(name, value));
        }
        return new LimeXMLDocument(info, oldDoc.getSchemaURI());
    }

    public static boolean isNonLimeAudioField(String fieldName) {
        return !fieldName.equals(TRACK_KEY) && !fieldName.equals(ARTIST_KEY) && !fieldName.equals(ALBUM_KEY) && !fieldName.equals(TITLE_KEY) && !fieldName.equals(GENRE_KEY) && !fieldName.equals(YEAR_KEY) && !fieldName.equals(COMMENTS_KEY) && !fieldName.equals(BITRATE_KEY) && !fieldName.equals(SECONDS_KEY) && !fieldName.equals(LICENSE_KEY) && !fieldName.equals(PRICE_KEY) && !fieldName.equals(LICENSE_TYPE_KEY);
    }
}

