/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.metadata;

import com.limegroup.gnutella.metadata.MetaData;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLSchemaRepository;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class MetaDataReader {
    private MetaDataReader() {
    }

    public static LimeXMLDocument readDocument(File file) throws IOException {
        MetaData data = MetaData.parse(file);
        if (data == null) {
            throw new IOException("unable to parse file");
        }
        List nameValList = data.toNameValueList();
        if (nameValList.isEmpty()) {
            throw new IOException("invalid/no data.");
        }
        String uri = data.getSchemaURI();
        if (LimeXMLSchemaRepository.instance().getSchema(uri) == null) {
            throw new IOException("schema: " + uri + " doesn't exist");
        }
        return new LimeXMLDocument(nameValList, uri);
    }
}

