/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.metadata;

import com.limegroup.gnutella.metadata.ASFParser;
import com.limegroup.gnutella.metadata.AudioMetaData;
import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WMAMetaData
extends AudioMetaData {
    private static final Log LOG = LogFactory.getLog(WMAMetaData.class);

    public WMAMetaData(File f) throws IOException {
        super(f);
    }

    public WMAMetaData(ASFParser p) throws IOException {
        this.set(p);
    }

    protected void parseFile(File f) throws IOException {
        ASFParser data = new ASFParser(f);
        this.set(data);
    }

    private void set(ASFParser data) throws IOException {
        if (data.hasVideo()) {
            throw new IOException("use WMV instead!");
        }
        if (!data.hasAudio()) {
            throw new IOException("no audio data!");
        }
        this.setTitle(data.getTitle());
        this.setAlbum(data.getAlbum());
        this.setArtist(data.getArtist());
        this.setYear(data.getYear());
        this.setComment(data.getComment());
        this.setTrack(data.getTrack());
        this.setBitrate(data.getBitrate());
        this.setLength(data.getLength());
        this.setGenre(data.getGenre());
        this.setLicense(data.getCopyright());
        if (data.getLicenseInfo() != null) {
            this.setLicenseType(data.getLicenseInfo());
        }
    }
}

