/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.metadata;

import com.limegroup.gnutella.xml.LimeXMLUtils;
import java.io.IOException;
import java.io.StringReader;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WRMXML {
    public static final String PROTECTED = "licensed: ";
    protected String _securityversion;
    protected String _cid;
    protected String _lainfo;
    protected String _kid;
    protected String _checksum;
    protected String _hashalgorithm;
    protected String _signalgorithm;
    protected String _signatureValue;
    protected Node _documentNode;

    WRMXML(String xml) {
        this.parse(xml);
    }

    WRMXML(Node documentNode) {
        this.parseDocument(documentNode);
    }

    public boolean isValid() {
        return this._documentNode != null && this._lainfo != null && this._hashalgorithm != null && this._signalgorithm != null && this._signatureValue != null;
    }

    public String getSecurityVersion() {
        return this._securityversion;
    }

    public String getCID() {
        return this._cid;
    }

    public String getLAInfo() {
        return this._lainfo;
    }

    public String getKID() {
        return this._kid;
    }

    public String getHashAlgorithm() {
        return this._hashalgorithm;
    }

    public String getSignAlgorithm() {
        return this._signalgorithm;
    }

    public String getSignatureValue() {
        return this._signatureValue;
    }

    public String getChecksum() {
        return this._checksum;
    }

    protected void parse(String xml) {
        DOMParser parser = new DOMParser();
        InputSource is = new InputSource(new StringReader(xml));
        try {
            parser.parse(is);
        }
        catch (IOException ioe) {
            return;
        }
        catch (SAXException saxe) {
            return;
        }
        this.parseDocument(parser.getDocument().getDocumentElement());
    }

    protected void parseDocument(Node node) {
        this._documentNode = node;
        if (!this._documentNode.getNodeName().equals("WRMHEADER")) {
            return;
        }
        NodeList children = this._documentNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            this.parseNode(child.getNodeName(), child);
        }
    }

    protected void parseNode(String nodeName, Node data) {
        NodeList children = data.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            this.parseAttributes(nodeName, child);
            String name = child.getNodeName();
            String value = LimeXMLUtils.getTextContent(child);
            if (value == null || (value = value.trim()).equals("")) continue;
            this.parseChild(nodeName, name, null, value);
        }
    }

    protected void parseAttributes(String parentNodeName, Node child) {
        NamedNodeMap nnm = child.getAttributes();
        String name = child.getNodeName();
        for (int i = 0; i < nnm.getLength(); ++i) {
            Node attribute = nnm.item(i);
            String attrName = attribute.getNodeName();
            String attrValue = attribute.getNodeValue();
            if (attrValue == null || (attrValue = attrValue.trim()).equals("")) continue;
            this.parseChild(parentNodeName, name, attrName, attrValue);
        }
    }

    protected void parseChild(String nodeName, String name, String attribute, String value) {
        if (nodeName.equals("DATA")) {
            if (attribute != null) {
                return;
            }
            if (name.equals("SECURITYVERSION")) {
                this._securityversion = value;
            } else if (name.equals("CID")) {
                this._cid = value;
            } else if (name.equals("LAINFO")) {
                this._lainfo = value;
            } else if (name.equals("KID")) {
                this._kid = value;
            } else if (name.equals("CHECKSUM")) {
                this._checksum = value;
            }
        } else if (nodeName.equals("SIGNATURE")) {
            if (name.equals("HASHALGORITHM") && "type".equals(attribute)) {
                this._hashalgorithm = value;
            } else if (name.equals("SIGNALGORITHM") && "type".equals(attribute)) {
                this._signalgorithm = value;
            } else if (name.equals("VALUE") && attribute == null) {
                this._signatureValue = value;
            }
        }
    }
}

