/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.search;

import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.util.NetworkUtils;
import java.util.Set;

public final class HostData {
    private final byte[] CLIENT_GUID;
    private final byte[] MESSAGE_GUID;
    private final int SPEED;
    private final boolean FIREWALLED;
    private final boolean BUSY;
    private final boolean MULTICAST;
    private final boolean CHAT_ENABLED;
    private final boolean BROWSE_HOST_ENABLED;
    private final boolean MEASURED_SPEED;
    private final int PORT;
    private final String IP;
    private final int QUALITY;
    private final String VENDOR_CODE;
    private final Set PROXIES;
    private final boolean CAN_DO_FWTRANSFER;
    private final int FWT_VERSION;

    public HostData(QueryReply reply) {
        this.CLIENT_GUID = reply.getClientGUID();
        this.MESSAGE_GUID = reply.getGUID();
        this.IP = reply.getIP();
        this.PORT = reply.getPort();
        boolean firewalled = true;
        boolean busy = true;
        boolean browseHostEnabled = false;
        boolean chatEnabled = false;
        boolean measuredSpeed = false;
        boolean multicast = false;
        String vendor = "";
        try {
            firewalled = reply.getNeedsPush() || NetworkUtils.isPrivateAddress(this.IP);
        }
        catch (BadPacketException e) {
            firewalled = true;
        }
        try {
            measuredSpeed = reply.getIsMeasuredSpeed();
        }
        catch (BadPacketException e) {
            measuredSpeed = false;
        }
        try {
            busy = reply.getIsBusy();
        }
        catch (BadPacketException bad) {
            busy = true;
        }
        try {
            vendor = reply.getVendor();
        }
        catch (BadPacketException bad) {
            // empty catch block
        }
        browseHostEnabled = reply.getSupportsBrowseHost();
        chatEnabled = reply.getSupportsChat() && !firewalled;
        multicast = reply.isReplyToMulticastQuery();
        this.FIREWALLED = firewalled && !multicast;
        this.BUSY = busy;
        this.BROWSE_HOST_ENABLED = browseHostEnabled;
        this.CHAT_ENABLED = chatEnabled;
        this.MEASURED_SPEED = measuredSpeed || multicast;
        this.MULTICAST = multicast;
        this.VENDOR_CODE = vendor;
        boolean ifirewalled = !RouterService.acceptedIncomingConnection();
        this.QUALITY = reply.calculateQualityOfService(ifirewalled);
        this.PROXIES = reply.getPushProxies();
        this.CAN_DO_FWTRANSFER = reply.getSupportsFWTransfer();
        this.FWT_VERSION = reply.getFWTransferVersion();
        this.SPEED = multicast ? Integer.MAX_VALUE : ByteOrder.long2int(reply.getSpeed());
    }

    public byte[] getClientGUID() {
        return this.CLIENT_GUID;
    }

    public String getVendorCode() {
        return this.VENDOR_CODE;
    }

    public byte[] getMessageGUID() {
        return this.MESSAGE_GUID;
    }

    public int getSpeed() {
        return this.SPEED;
    }

    public int getQuality() {
        return this.QUALITY;
    }

    public String getIP() {
        return this.IP;
    }

    public int getPort() {
        return this.PORT;
    }

    public boolean isFirewalled() {
        return this.FIREWALLED;
    }

    public boolean isBusy() {
        return this.BUSY;
    }

    public boolean isBrowseHostEnabled() {
        return this.BROWSE_HOST_ENABLED;
    }

    public boolean isChatEnabled() {
        return this.CHAT_ENABLED;
    }

    public boolean isMeasuredSpeed() {
        return this.MEASURED_SPEED;
    }

    public boolean isReplyToMulticastQuery() {
        return this.MULTICAST;
    }

    public Set getPushProxies() {
        return this.PROXIES;
    }

    public boolean supportsFWTransfer() {
        return this.CAN_DO_FWTRANSFER;
    }

    public int getFWTVersionSupported() {
        return this.FWT_VERSION;
    }
}

