/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.search;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.search.QueryHandler;
import com.limegroup.gnutella.util.ProcessingQueue;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class QueryDispatcher
implements Runnable {
    private final Map QUERIES = new HashMap();
    private final List NEW_QUERIES = Collections.synchronizedList(new LinkedList());
    private static final QueryDispatcher INSTANCE = new QueryDispatcher();
    private final ProcessingQueue PROCESSOR = new ProcessingQueue("QueryDispatcher");
    private boolean _active;

    public static QueryDispatcher instance() {
        return INSTANCE;
    }

    private QueryDispatcher() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addQuery(QueryHandler handler) {
        handler.sendQuery();
        List list = this.NEW_QUERIES;
        synchronized (list) {
            this.NEW_QUERIES.add(handler);
            if (this.NEW_QUERIES.size() == 1 && !this._active) {
                this._active = true;
                this.PROCESSOR.add(this);
            }
        }
    }

    public void removeReplyHandler(ReplyHandler handler) {
        if (!handler.isSupernodeClientConnection()) {
            return;
        }
        this.remove(handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLeafResultsForQuery(GUID queryGUID, int numResults) {
        Map map = this.QUERIES;
        synchronized (map) {
            QueryHandler qh = (QueryHandler)this.QUERIES.get(queryGUID);
            if (qh != null) {
                qh.updateLeafResults(numResults);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLeafResultsForQuery(GUID queryGUID) {
        Map map = this.QUERIES;
        synchronized (map) {
            QueryHandler qh = (QueryHandler)this.QUERIES.get(queryGUID);
            if (qh == null) {
                return -1;
            }
            return qh.getNumResultsReportedByLeaf();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(ReplyHandler handler) {
        QueryHandler qh;
        Iterator<Object> iter;
        Object object = this.NEW_QUERIES;
        synchronized (object) {
            iter = this.NEW_QUERIES.iterator();
            while (iter.hasNext()) {
                qh = (QueryHandler)iter.next();
                if (qh.getReplyHandler() != handler) continue;
                iter.remove();
            }
        }
        object = this.QUERIES;
        synchronized (object) {
            iter = this.QUERIES.values().iterator();
            while (iter.hasNext()) {
                qh = (QueryHandler)iter.next();
                if (qh.getReplyHandler() != handler) continue;
                iter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(GUID guid) {
        QueryHandler qh;
        Iterator<Object> iter;
        Object object = this.NEW_QUERIES;
        synchronized (object) {
            iter = this.NEW_QUERIES.iterator();
            while (iter.hasNext()) {
                qh = (QueryHandler)iter.next();
                if (!qh.getGUID().equals(guid)) continue;
                iter.remove();
            }
        }
        object = this.QUERIES;
        synchronized (object) {
            iter = this.QUERIES.values().iterator();
            while (iter.hasNext()) {
                qh = (QueryHandler)iter.next();
                if (!qh.getGUID().equals(guid)) continue;
                iter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            try {
                Thread.sleep(400L);
            }
            catch (InterruptedException ignored) {
                // empty catch block
            }
            try {
                if (this.processQueries()) continue;
                List ignored = this.NEW_QUERIES;
                synchronized (ignored) {
                    if (this.NEW_QUERIES.isEmpty()) {
                        this._active = false;
                        return;
                    }
                    continue;
                }
            }
            catch (Throwable t) {
                ErrorService.error(t);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processQueries() {
        Object object = this.NEW_QUERIES;
        synchronized (object) {
            Map map = this.QUERIES;
            synchronized (map) {
                Iterator iter = this.NEW_QUERIES.iterator();
                while (iter.hasNext()) {
                    QueryHandler qh = (QueryHandler)iter.next();
                    this.QUERIES.put(qh.getGUID(), qh);
                }
            }
            this.NEW_QUERIES.clear();
        }
        object = this.QUERIES;
        synchronized (object) {
            Iterator iter = this.QUERIES.values().iterator();
            while (iter.hasNext()) {
                QueryHandler handler = (QueryHandler)iter.next();
                handler.sendQuery();
                if (!handler.hasEnoughResults()) continue;
                iter.remove();
            }
            return !this.QUERIES.isEmpty();
        }
    }

    public void addToRemove(GUID g) {
        this.remove(g);
    }
}

