/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.search;

import com.limegroup.gnutella.Connection;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.ForMeReplyHandler;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.routing.QueryRouteTable;
import com.limegroup.gnutella.search.ProbeQuery;
import com.limegroup.gnutella.search.ResultCounter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class QueryHandler {
    private static final Log LOG = LogFactory.getLog(QueryHandler.class);
    private final int RESULTS;
    public static final byte MAX_QUERY_TTL = 6;
    public static final int ULTRAPEER_RESULTS = 150;
    public static final double UP_RESULT_BUMP = 1.15;
    private static final int OLD_LEAF_RESULTS = 20;
    private static final int NEW_LEAF_RESULTS = 38;
    private static final int HASH_QUERY_RESULTS = 10;
    private static final int MAXIMUM_ROUTED_FOR_LEAVES = 75;
    private volatile long _timeToWaitPerHop = 2400L;
    private volatile long _timeToDecreasePerHop = 10L;
    private volatile int _numDecrements = 0;
    public static final int MAX_QUERY_TIME = 200000;
    private static MessageRouter _messageRouter = RouterService.getMessageRouter();
    private static ConnectionManager _connectionManager = RouterService.getConnectionManager();
    private volatile int _numResultsReportedByLeaf = 0;
    private volatile long _nextQueryTime = 0L;
    private volatile int _theoreticalHostsQueried = 1;
    private final ResultCounter RESULT_COUNTER;
    private final List QUERIED_CONNECTIONS = new ArrayList();
    private final List QUERIED_PROBE_CONNECTIONS = new ArrayList();
    private volatile long _queryStartTime = 0L;
    private volatile long _curTime = 0L;
    private final ReplyHandler REPLY_HANDLER;
    final QueryRequest QUERY;
    private volatile boolean _forwardedToLeaves = false;
    private boolean _probeQuerySent;
    private final String _prefLocale;

    private QueryHandler(QueryRequest query, int results, ReplyHandler handler, ResultCounter counter) {
        if (query == null) {
            throw new IllegalArgumentException("null query");
        }
        if (handler == null) {
            throw new IllegalArgumentException("null reply handler");
        }
        if (counter == null) {
            throw new IllegalArgumentException("null result counter");
        }
        boolean isHashQuery = !query.getQueryUrns().isEmpty();
        this.QUERY = query;
        this.RESULTS = isHashQuery ? 10 : results;
        this.REPLY_HANDLER = handler;
        this.RESULT_COUNTER = counter;
        this._prefLocale = handler.getLocalePref();
    }

    public static QueryHandler createHandler(QueryRequest query, ReplyHandler handler, ResultCounter counter) {
        return new QueryHandler(query, 150, handler, counter);
    }

    public static QueryHandler createHandlerForMe(QueryRequest query, ResultCounter counter) {
        return new QueryHandler(query, 172, ForMeReplyHandler.instance(), counter);
    }

    public static QueryHandler createHandlerForOldLeaf(QueryRequest query, ReplyHandler handler, ResultCounter counter) {
        return new QueryHandler(query, 20, handler, counter);
    }

    public static QueryHandler createHandlerForNewLeaf(QueryRequest query, ReplyHandler handler, ResultCounter counter) {
        return new QueryHandler(query, 38, handler, counter);
    }

    public static QueryRequest createQuery(QueryRequest query, byte ttl) {
        if (ttl < 1 || ttl > 6) {
            throw new IllegalArgumentException("ttl too high: " + ttl);
        }
        if (query == null) {
            throw new NullPointerException("null query");
        }
        if (query.getHops() == 0) {
            return QueryRequest.createQuery(query, ttl);
        }
        try {
            return QueryRequest.createNetworkQuery(query.getGUID(), ttl, query.getHops(), query.getPayload(), query.getNetwork());
        }
        catch (BadPacketException e) {
            ErrorService.error(e);
            return null;
        }
    }

    QueryRequest createQuery(byte ttl) {
        return QueryHandler.createQuery(this.QUERY, ttl);
    }

    public void sendQuery() {
        if (this.hasEnoughResults()) {
            return;
        }
        this._curTime = System.currentTimeMillis();
        if (this._curTime < this._nextQueryTime) {
            return;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Query = " + this.QUERY.getQuery() + ", numHostsQueried: " + this._theoreticalHostsQueried);
        }
        if (this._queryStartTime == 0L) {
            this._queryStartTime = this._curTime;
        }
        if (!this._forwardedToLeaves) {
            this._forwardedToLeaves = true;
            QueryRouteTable qrt = RouterService.getMessageRouter().getQueryRouteTable();
            QueryRequest query = QueryHandler.createQuery(this.QUERY, (byte)1);
            this._theoreticalHostsQueried += 25;
            if (qrt != null && qrt.contains(query)) {
                RouterService.getMessageRouter().forwardQueryRequestToLeaves(query, this.REPLY_HANDLER);
                this._nextQueryTime = System.currentTimeMillis() + this._timeToWaitPerHop;
                return;
            }
        }
        if (!this._probeQuerySent) {
            ProbeQuery pq = new ProbeQuery(_connectionManager.getInitializedConnections(), this);
            long timeToWait = pq.getTimeToWait();
            this._theoreticalHostsQueried += pq.sendProbe();
            this._nextQueryTime = System.currentTimeMillis() + timeToWait;
            this._probeQuerySent = true;
            return;
        }
        int newHosts = this.sendQuery(new ArrayList(_connectionManager.getInitializedConnections()));
        if (newHosts == 0) {
            this._nextQueryTime = System.currentTimeMillis() + 6000L;
        }
        this._theoreticalHostsQueried += newHosts;
        if (this._timeToWaitPerHop > 100L && System.currentTimeMillis() - this._queryStartTime > 6000L) {
            this._timeToWaitPerHop -= this._timeToDecreasePerHop;
            int resultFactor = Math.max(1, this.RESULTS / 2 - 30 * this.RESULT_COUNTER.getNumResults());
            int decrementFactor = Math.max(1, this._numDecrements / 6);
            int currentDecrease = resultFactor * decrementFactor;
            currentDecrease = Math.max(5, currentDecrease);
            this._timeToDecreasePerHop += (long)currentDecrease;
            ++this._numDecrements;
            if (this._timeToWaitPerHop < 100L) {
                this._timeToWaitPerHop = 100L;
            }
        }
    }

    private int sendQuery(List ultrapeersAll) {
        int hostsToQueryPerConnection;
        int remainingConnections;
        List ultrapeers = _connectionManager.getInitializedConnectionsMatchLocale(this._prefLocale);
        this.QUERIED_CONNECTIONS.retainAll(ultrapeersAll);
        this.QUERIED_PROBE_CONNECTIONS.retainAll(ultrapeersAll);
        if (!ultrapeers.isEmpty()) {
            ultrapeers.removeAll(this.QUERIED_CONNECTIONS);
            ultrapeers.removeAll(this.QUERIED_PROBE_CONNECTIONS);
        }
        if (ultrapeers.isEmpty()) {
            ultrapeers = ultrapeersAll;
            ultrapeers.removeAll(this.QUERIED_CONNECTIONS);
            ultrapeers.removeAll(this.QUERIED_PROBE_CONNECTIONS);
        }
        int length = ultrapeers.size();
        if (LOG.isTraceEnabled()) {
            LOG.trace("potential querier size: " + length);
        }
        int ttl = 0;
        ManagedConnection mc = null;
        Collections.shuffle(ultrapeers);
        for (int i = 0; i < length; ++i) {
            ManagedConnection curConnection = (ManagedConnection)ultrapeers.get(i);
            if (!curConnection.isStable(this._curTime)) continue;
            mc = curConnection;
            break;
        }
        if ((remainingConnections = Math.max(length + this.QUERIED_PROBE_CONNECTIONS.size(), 0)) == 0) {
            return 0;
        }
        if (remainingConnections > 4) {
            remainingConnections -= 4;
        }
        boolean probeConnection = false;
        if (mc == null) {
            if (this.QUERIED_PROBE_CONNECTIONS.isEmpty()) {
                return 0;
            }
            mc = (ManagedConnection)this.QUERIED_PROBE_CONNECTIONS.remove(0);
            probeConnection = true;
        }
        int results = this._numResultsReportedByLeaf > 0 ? this._numResultsReportedByLeaf : this.RESULT_COUNTER.getNumResults();
        double resultsPerHost = (double)results / (double)this._theoreticalHostsQueried;
        int resultsNeeded = this.RESULTS - results;
        int hostsToQuery = 40000;
        if (resultsPerHost != 0.0) {
            hostsToQuery = (int)((double)resultsNeeded / resultsPerHost);
        }
        if ((ttl = QueryHandler.calculateNewTTL(hostsToQueryPerConnection = hostsToQuery / remainingConnections, mc.getNumIntraUltrapeerConnections(), mc.headers().getMaxTTL())) == 1 && (mc.isUltrapeerQueryRoutingConnection() && !mc.shouldForwardQuery(this.QUERY) || probeConnection)) {
            ttl = 2;
        }
        QueryRequest query = QueryHandler.createQuery(this.QUERY, (byte)ttl);
        return QueryHandler.sendQueryToHost(query, mc, this);
    }

    static int sendQueryToHost(QueryRequest query, ManagedConnection mc, QueryHandler handler) {
        if (!_messageRouter.originateQuery(query, mc)) {
            return 0;
        }
        byte ttl = query.getTTL();
        if (ttl == 1 && mc.supportsProbeQueries()) {
            handler.QUERIED_PROBE_CONNECTIONS.add(mc);
        } else {
            handler.QUERIED_CONNECTIONS.add(mc);
            if (LOG.isTraceEnabled()) {
                LOG.trace("QUERIED_CONNECTIONS.size() = " + handler.QUERIED_CONNECTIONS.size());
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Querying host " + mc.getAddress() + " with ttl " + query.getTTL());
        }
        handler._nextQueryTime = System.currentTimeMillis() + (long)ttl * handler._timeToWaitPerHop;
        return QueryHandler.calculateNewHosts(mc, ttl);
    }

    private static byte calculateNewTTL(int hostsToQueryPerConnection, int degree, byte maxTTL) {
        if (maxTTL > 6) {
            maxTTL = (byte)6;
        }
        for (byte i = 1; i < 6; i = (byte)(i + 1)) {
            int hosts = (int)(16.0 * (double)QueryHandler.calculateNewHosts(degree, i));
            if (hosts < hostsToQueryPerConnection) continue;
            if (i > maxTTL) {
                return maxTTL;
            }
            return i;
        }
        return maxTTL;
    }

    private static int calculateNewHosts(Connection conn, byte ttl) {
        return QueryHandler.calculateNewHosts(conn.getNumIntraUltrapeerConnections(), ttl);
    }

    private static int calculateNewHosts(int degree, byte ttl) {
        double newHosts = 0.0;
        while (ttl > 0) {
            newHosts += Math.pow(degree - 1, ttl - 1);
            ttl = (byte)(ttl - 1);
        }
        return (int)newHosts;
    }

    public boolean hasEnoughResults() {
        if (this._queryStartTime == 0L) {
            return false;
        }
        if (this._numResultsReportedByLeaf > 0) {
            if (this.RESULT_COUNTER.getNumResults() >= 75) {
                return true;
            }
            if (this._numResultsReportedByLeaf > this.RESULTS) {
                return true;
            }
        } else if (this.RESULT_COUNTER.getNumResults() >= this.RESULTS) {
            return true;
        }
        if (this._theoreticalHostsQueried > 110000) {
            return true;
        }
        int queryLength = (int)(System.currentTimeMillis() - this._queryStartTime);
        return queryLength > 200000;
    }

    public void updateLeafResults(int numResults) {
        if (numResults > this._numResultsReportedByLeaf) {
            this._numResultsReportedByLeaf = numResults;
        }
    }

    public int getNumResultsReportedByLeaf() {
        return this._numResultsReportedByLeaf;
    }

    public ReplyHandler getReplyHandler() {
        return this.REPLY_HANDLER;
    }

    public long getTimeToWaitPerHop() {
        return this._timeToWaitPerHop;
    }

    public String toString() {
        return "QueryHandler: QUERY: " + this.QUERY;
    }

    public GUID getGUID() {
        return new GUID(this.QUERY.getGUID());
    }
}

