/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.settings;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.settings.Setting;
import java.util.Properties;

public abstract class AbstractNumberSetting
extends Setting {
    protected final Number MAX_VALUE;
    protected final Number MIN_VALUE;

    protected AbstractNumberSetting(Properties defaultProps, Properties props, String key, String defaultValue, String simppKey, Number min, Number max) {
        super(defaultProps, props, key, defaultValue, simppKey);
        Comparable comparableMax;
        if (max != null && min != null && (comparableMax = (Comparable)((Object)max)).compareTo(min) < 0) {
            throw new IllegalArgumentException("max less than min");
        }
        this.MAX_VALUE = max;
        this.MIN_VALUE = min;
    }

    protected void setValue(String value) {
        if (this.isSimppEnabled()) {
            Assert.that(this.MAX_VALUE != null, "simpp setting created with no max");
            Assert.that(this.MIN_VALUE != null, "simpp setting created with no min");
        }
        value = this.normalizeValue(value);
        super.setValue(value);
    }

    protected String normalizeValue(String value) {
        Comparable comparableValue = null;
        try {
            comparableValue = this.convertToComparable(value);
        }
        catch (NumberFormatException e) {
            return this.DEFAULT_VALUE;
        }
        if (this.MAX_VALUE != null && comparableValue.compareTo(this.MAX_VALUE) > 0) {
            return this.MAX_VALUE.toString();
        }
        if (this.MIN_VALUE != null && comparableValue.compareTo(this.MIN_VALUE) < 0) {
            return this.MIN_VALUE.toString();
        }
        return value;
    }

    protected abstract Comparable convertToComparable(String var1);
}

