/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.settings;

import com.limegroup.gnutella.settings.Setting;
import com.limegroup.gnutella.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

public class FileArraySetting
extends Setting {
    private File[] value;

    FileArraySetting(Properties defaultProps, Properties props, String key, File[] defaultValue) {
        this(defaultProps, props, key, defaultValue, null);
    }

    FileArraySetting(Properties defaultProps, Properties props, String key, File[] defaultValue, String simppKey) {
        super(defaultProps, props, key, FileArraySetting.decode(defaultValue), simppKey);
        this.setPrivate(true);
    }

    public File[] getValue() {
        return this.value;
    }

    public synchronized void setValue(File[] value) {
        super.setValue(FileArraySetting.decode(value));
    }

    public synchronized void add(File file) {
        if (file == null) {
            return;
        }
        File[] newValue = new File[this.value.length + 1];
        System.arraycopy(this.value, 0, newValue, 0, this.value.length);
        newValue[this.value.length] = file;
        this.setValue(newValue);
    }

    public synchronized boolean remove(File file) {
        if (file == null) {
            return false;
        }
        int index = this.indexOf(file);
        if (index == -1) {
            return false;
        }
        File[] newValue = new File[this.value.length - 1];
        System.arraycopy(this.value, 0, newValue, 0, index);
        System.arraycopy(this.value, index + 1, newValue, index, this.value.length - index - 1);
        this.setValue(newValue);
        return true;
    }

    public synchronized boolean contains(File file) {
        return this.indexOf(file) >= 0;
    }

    public synchronized int indexOf(File file) {
        if (file == null) {
            return -1;
        }
        List<File> list = Arrays.asList(this.value);
        Iterator<File> it = list.iterator();
        int i = 0;
        while (it.hasNext()) {
            try {
                if (FileUtils.getCanonicalFile(it.next()).equals(FileUtils.getCanonicalFile(file))) {
                    return i;
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
            ++i;
        }
        return -1;
    }

    public synchronized int length() {
        return this.value.length;
    }

    protected synchronized void loadValue(String sValue) {
        this.value = FileArraySetting.encode(sValue);
    }

    private static final File[] encode(String src) {
        if (src == null || src.length() == 0) {
            return new File[0];
        }
        StringTokenizer tokenizer = new StringTokenizer(src, ";");
        File[] dirs = new File[tokenizer.countTokens()];
        for (int i = 0; i < dirs.length; ++i) {
            dirs[i] = new File(tokenizer.nextToken());
        }
        return dirs;
    }

    private static final String decode(File[] src) {
        if (src == null || src.length == 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < src.length; ++i) {
            buffer.append(src[i].getAbsolutePath());
            if (i >= src.length - 1) continue;
            buffer.append(';');
        }
        return buffer.toString();
    }

    public synchronized void clean() {
        LinkedList<File> list = new LinkedList<File>();
        File file = null;
        for (int i = 0; i < this.value.length; ++i) {
            file = this.value[i];
            if (file == null || !file.exists()) continue;
            list.add(file);
        }
        this.setValue(list.toArray(new File[0]));
    }
}

