/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.settings;

import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.settings.BooleanSetting;
import com.limegroup.gnutella.settings.FileSetSetting;
import com.limegroup.gnutella.settings.FileSetting;
import com.limegroup.gnutella.settings.IntSetting;
import com.limegroup.gnutella.settings.LimeProps;
import com.limegroup.gnutella.settings.StringSetting;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;

public class SharingSettings
extends LimeProps {
    private static final Hashtable downloadDirsByDescription = new Hashtable();
    public static final File DEFAULT_SAVE_DIR = new File(CommonUtils.getUserHomeDir(), "Shared");
    public static final BooleanSetting ADD_ALTERNATE_FOR_SELF = FACTORY.createBooleanSetting("ADD_ALTERNATE_FOR_SELF", true);
    public static final FileSetting DIRECTORY_FOR_SAVING_FILES = (FileSetting)FACTORY.createFileSetting("DIRECTORY_FOR_SAVING_FILES", DEFAULT_SAVE_DIR).setAlwaysSave(true);
    public static final FileSetting INCOMPLETE_DIRECTORY = FACTORY.createFileSetting("INCOMPLETE_DIRECTORY", new File(DIRECTORY_FOR_SAVING_FILES.getValue().getParent(), "Incomplete"));
    public static final FileSetting DOWNLOAD_SNAPSHOT_FILE = FACTORY.createFileSetting("DOWNLOAD_SNAPSHOT_FILE", new File(INCOMPLETE_DIRECTORY.getValue(), "downloads.dat"));
    public static final FileSetting DOWNLOAD_SNAPSHOT_BACKUP_FILE = FACTORY.createFileSetting("DOWNLOAD_SNAPSHOT_BACKUP_FILE", new File(INCOMPLETE_DIRECTORY.getValue(), "downloads.bak"));
    public static final IntSetting INCOMPLETE_PURGE_TIME = FACTORY.createIntSetting("INCOMPLETE_PURGE_TIME", 7);
    public static final BooleanSetting CLEAR_DOWNLOAD = FACTORY.createBooleanSetting("CLEAR_DOWNLOAD", false);
    private static final String DEFAULT_EXTENSIONS_TO_SHARE = "asx;html;htm;xml;txt;pdf;ps;rtf;doc;tex;mp3;mp4;wav;wax;au;aif;aiff;ra;ram;wma;wm;wmv;mp2v;mlv;mpa;mpv2;mid;midi;rmi;aifc;snd;flac;fla;mpg;mpeg;asf;qt;mov;avi;mpe;swf;dcr;gif;jpg;jpeg;jpe;png;tif;tiff;exe;zip;gz;gzip;hqx;tar;tgz;z;rmj;lqt;rar;ace;sit;smi;img;ogg;rm;bin;dmg;jve;nsv;med;mod;7z;iso;lwtp;pmf;m4a;idx;bz2;sea;pf;arc;arj;bz;tbz;mime;taz;ua;toast;lit;rpm;deb;pkg;sxw;l6t;srt;sub;idx;mkv;ogm;shn;flac;fla;dvi;rmvp;kar;cdg;ccd;cue;c;h;m;java;jar;pl;py;pyc;pyo;pyz";
    public static final FileSetSetting DIRECTORIES_TO_SHARE = FACTORY.createFileSetSetting("DIRECTORIES_TO_SEARCH_FOR_FILES", new File[0]);
    public static final BooleanSetting SHARE_DOWNLOADED_FILES_IN_NON_SHARED_DIRECTORIES = FACTORY.createBooleanSetting("SHARE_DOWNLOADED_FILES_IN_NON_SHARED_DIRECTORIES", true);
    public static final StringSetting EXTENSIONS_TO_SHARE = FACTORY.createStringSetting("EXTENSIONS_TO_SEARCH_FOR", "asx;html;htm;xml;txt;pdf;ps;rtf;doc;tex;mp3;mp4;wav;wax;au;aif;aiff;ra;ram;wma;wm;wmv;mp2v;mlv;mpa;mpv2;mid;midi;rmi;aifc;snd;flac;fla;mpg;mpeg;asf;qt;mov;avi;mpe;swf;dcr;gif;jpg;jpeg;jpe;png;tif;tiff;exe;zip;gz;gzip;hqx;tar;tgz;z;rmj;lqt;rar;ace;sit;smi;img;ogg;rm;bin;dmg;jve;nsv;med;mod;7z;iso;lwtp;pmf;m4a;idx;bz2;sea;pf;arc;arj;bz;tbz;mime;taz;ua;toast;lit;rpm;deb;pkg;sxw;l6t;srt;sub;idx;mkv;ogm;shn;flac;fla;dvi;rmvp;kar;cdg;ccd;cue;c;h;m;java;jar;pl;py;pyc;pyo;pyz");
    public static final IntSetting FREELOADER_ALLOWED = FACTORY.createIntSetting("FREELOADER_ALLOWED", 100);
    public static final IntSetting FREELOADER_FILES = FACTORY.createIntSetting("FREELOADER_FILES", 1);
    public static final IntSetting PERSISTENT_HTTP_CONNECTION_TIMEOUT = FACTORY.createIntSetting("PERSISTENT_HTTP_CONNECTION_TIMEOUT", 15000);
    public static final BooleanSetting CLEAR_UPLOAD = FACTORY.createBooleanSetting("CLEAR_UPLOAD", true);
    public static final BooleanSetting ALLOW_BROWSER = FACTORY.createBooleanSetting("ALLOW_BROWSER", false);
    public static final BooleanSetting FRIENDLY_HASHING = FACTORY.createBooleanSetting("FRIENDLY_HASHING", true);
    public static final StringSetting CREATIVE_COMMONS_INTRO_URL = FACTORY.createSettableStringSetting("CREATIVE_COMMONS_URL", "http://creativecommons.org/about/licenses/how1", "creativeCommonsURL");
    public static final StringSetting CREATIVE_COMMONS_VERIFICATION_URL = FACTORY.createSettableStringSetting("CREATIVE_COMMONS_VERIFICATION_URL", "http://creativecommons.org/technology/embedding#2", "creativeCommonsVerificationURL");

    private SharingSettings() {
    }

    public static final void setSaveDirectory(File saveDir) throws IOException {
        if (saveDir == null) {
            throw new NullPointerException();
        }
        if (!saveDir.isDirectory() && !saveDir.mkdirs()) {
            throw new IOException("could not create save dir");
        }
        String parentDir = saveDir.getParent();
        File incDir = new File(parentDir, "Incomplete");
        if (!incDir.isDirectory() && !incDir.mkdirs()) {
            throw new IOException("could not create incomplete dir");
        }
        FileUtils.setWriteable(saveDir);
        FileUtils.setWriteable(incDir);
        if (!(saveDir.canRead() && saveDir.canWrite() && incDir.canRead() && incDir.canWrite())) {
            throw new IOException("could not write to selected directory");
        }
        try {
            saveDir = FileUtils.getCanonicalFile(saveDir);
        }
        catch (IOException ignored) {
            // empty catch block
        }
        try {
            incDir = FileUtils.getCanonicalFile(incDir);
        }
        catch (IOException ignored) {
            // empty catch block
        }
        File snapFile = new File(incDir, "downloads.dat");
        try {
            snapFile = FileUtils.getCanonicalFile(snapFile);
        }
        catch (IOException ignored) {
            // empty catch block
        }
        File snapBackup = new File(incDir, "downloads.bak");
        try {
            snapBackup = FileUtils.getCanonicalFile(snapBackup);
        }
        catch (IOException ignored) {
            // empty catch block
        }
        DIRECTORY_FOR_SAVING_FILES.setValue(saveDir);
        INCOMPLETE_DIRECTORY.setValue(incDir);
        DOWNLOAD_SNAPSHOT_FILE.setValue(snapFile);
        DOWNLOAD_SNAPSHOT_BACKUP_FILE.setValue(snapBackup);
    }

    public static final File getSaveDirectory() {
        return DIRECTORY_FOR_SAVING_FILES.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Set getAllSaveDirectories() {
        HashSet<File> set = new HashSet<File>(7);
        set.add(SharingSettings.getSaveDirectory());
        Hashtable hashtable = downloadDirsByDescription;
        synchronized (hashtable) {
            Iterator i = downloadDirsByDescription.values().iterator();
            while (i.hasNext()) {
                FileSetting next = (FileSetting)i.next();
                set.add(next.getValue());
            }
        }
        return set;
    }

    public static final FileSetting getFileSettingForMediaType(MediaType type) {
        FileSetting setting = (FileSetting)downloadDirsByDescription.get(type.getMimeType());
        if (setting == null) {
            setting = FACTORY.createProxyFileSetting("DIRECTORY_FOR_SAVING_" + type.getMimeType() + "_FILES", DIRECTORY_FOR_SAVING_FILES);
            downloadDirsByDescription.put(type.getMimeType(), setting);
        }
        return setting;
    }
}

