/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.settings;

import com.limegroup.gnutella.settings.Setting;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

public class StringSetSetting
extends Setting {
    private Set value;

    public StringSetSetting(Properties defaultProps, Properties props, String key, String defaultValue) {
        super(defaultProps, props, key, defaultValue, null);
    }

    public synchronized Set getValue() {
        return this.value;
    }

    public synchronized String[] getValueAsArray() {
        return this.value.toArray(new String[this.value.size()]);
    }

    protected synchronized void loadValue(String sValue) {
        this.value = StringSetSetting.encode(sValue);
    }

    private static final Set encode(String src) {
        if (src == null || src.length() == 0) {
            return new HashSet();
        }
        StringTokenizer tokenizer = new StringTokenizer(src, ";");
        int size = tokenizer.countTokens();
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < size; ++i) {
            set.add(tokenizer.nextToken());
        }
        return set;
    }

    private static final String decode(Set src) {
        if (src == null || src.isEmpty()) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        Iterator i = src.iterator();
        while (i.hasNext()) {
            buffer.append(i.next());
            if (!i.hasNext()) continue;
            buffer.append(';');
        }
        return buffer.toString();
    }

    public synchronized void setValue(Set value) {
        super.setValue(StringSetSetting.decode(value));
    }

    public synchronized boolean add(String s) {
        if (this.value.add(s)) {
            this.setValue(StringSetSetting.decode(this.value));
            return true;
        }
        return false;
    }

    public synchronized boolean remove(String s) {
        if (this.value.remove(s)) {
            this.setValue(StringSetSetting.decode(this.value));
            return true;
        }
        return false;
    }

    public synchronized boolean contains(String s) {
        return this.value.contains(s);
    }
}

